/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Reason about why a Job was created from a
 * [`jobs.query`](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query) method when
 * used with `JOB_CREATION_OPTIONAL` Job creation mode. For
 * [`jobs.insert`](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/insert) method
 * calls it will always be `REQUESTED`. [Preview](/products/#product-launch-stages)
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobCreationReason extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Specifies the high level reason why a Job was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String code;

  /**
   * Output only. Specifies the high level reason why a Job was created.
   * @return value or {@code null} for none
   */
  public java.lang.String getCode() {
    return code;
  }

  /**
   * Output only. Specifies the high level reason why a Job was created.
   * @param code code or {@code null} for none
   */
  public JobCreationReason setCode(java.lang.String code) {
    this.code = code;
    return this;
  }

  @Override
  public JobCreationReason set(String fieldName, Object value) {
    return (JobCreationReason) super.set(fieldName, value);
  }

  @Override
  public JobCreationReason clone() {
    return (JobCreationReason) super.clone();
  }

}
