/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for BiEngineStatistics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BiEngineStatistics extends com.google.api.client.json.GenericJson {

  /**
   * [Output-only] Specifies which mode of BI Engine acceleration was performed (if any).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accelerationMode;

  /**
   * [Output-only] Specifies which mode of BI Engine acceleration was performed (if any).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String biEngineMode;

  /**
   * In case of DISABLED or PARTIAL bi_engine_mode, these contain the explanatory reasons as to why
   * BI Engine could not accelerate. In case the full query was accelerated, this field is not
   * populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BiEngineReason> biEngineReasons;

  static {
    // hack to force ProGuard to consider BiEngineReason used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(BiEngineReason.class);
  }

  /**
   * [Output-only] Specifies which mode of BI Engine acceleration was performed (if any).
   * @return value or {@code null} for none
   */
  public java.lang.String getAccelerationMode() {
    return accelerationMode;
  }

  /**
   * [Output-only] Specifies which mode of BI Engine acceleration was performed (if any).
   * @param accelerationMode accelerationMode or {@code null} for none
   */
  public BiEngineStatistics setAccelerationMode(java.lang.String accelerationMode) {
    this.accelerationMode = accelerationMode;
    return this;
  }

  /**
   * [Output-only] Specifies which mode of BI Engine acceleration was performed (if any).
   * @return value or {@code null} for none
   */
  public java.lang.String getBiEngineMode() {
    return biEngineMode;
  }

  /**
   * [Output-only] Specifies which mode of BI Engine acceleration was performed (if any).
   * @param biEngineMode biEngineMode or {@code null} for none
   */
  public BiEngineStatistics setBiEngineMode(java.lang.String biEngineMode) {
    this.biEngineMode = biEngineMode;
    return this;
  }

  /**
   * In case of DISABLED or PARTIAL bi_engine_mode, these contain the explanatory reasons as to why
   * BI Engine could not accelerate. In case the full query was accelerated, this field is not
   * populated.
   * @return value or {@code null} for none
   */
  public java.util.List<BiEngineReason> getBiEngineReasons() {
    return biEngineReasons;
  }

  /**
   * In case of DISABLED or PARTIAL bi_engine_mode, these contain the explanatory reasons as to why
   * BI Engine could not accelerate. In case the full query was accelerated, this field is not
   * populated.
   * @param biEngineReasons biEngineReasons or {@code null} for none
   */
  public BiEngineStatistics setBiEngineReasons(java.util.List<BiEngineReason> biEngineReasons) {
    this.biEngineReasons = biEngineReasons;
    return this;
  }

  @Override
  public BiEngineStatistics set(String fieldName, Object value) {
    return (BiEngineStatistics) super.set(fieldName, value);
  }

  @Override
  public BiEngineStatistics clone() {
    return (BiEngineStatistics) super.clone();
  }

}
