/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Represents access on a subset of rows on the specified table, defined by its filter predicate.
 * Access to the subset of rows is controlled by its IAM policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RowAccessPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The time when this row access policy was created, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTime;

  /**
   * Output only. A hash of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Required. A SQL boolean expression that represents the rows defined by this row access policy,
   * similar to the boolean expression in a WHERE clause of a SELECT query on a table. References to
   * other tables, routines, and temporary functions are not supported. Examples: region="EU"
   * date_field = CAST('2019-9-27' as DATE) nullable_field is not NULL numeric_field BETWEEN 1.0 AND
   * 5.0
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filterPredicate;

  /**
   * Output only. The time when this row access policy was last modified, in milliseconds since the
   * epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastModifiedTime;

  /**
   * Required. Reference describing the ID of this row access policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RowAccessPolicyReference rowAccessPolicyReference;

  /**
   * Output only. The time when this row access policy was created, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public String getCreationTime() {
    return creationTime;
  }

  /**
   * Output only. The time when this row access policy was created, in milliseconds since the epoch.
   * @param creationTime creationTime or {@code null} for none
   */
  public RowAccessPolicy setCreationTime(String creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Output only. A hash of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Output only. A hash of this resource.
   * @param etag etag or {@code null} for none
   */
  public RowAccessPolicy setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Required. A SQL boolean expression that represents the rows defined by this row access policy,
   * similar to the boolean expression in a WHERE clause of a SELECT query on a table. References to
   * other tables, routines, and temporary functions are not supported. Examples: region="EU"
   * date_field = CAST('2019-9-27' as DATE) nullable_field is not NULL numeric_field BETWEEN 1.0 AND
   * 5.0
   * @return value or {@code null} for none
   */
  public java.lang.String getFilterPredicate() {
    return filterPredicate;
  }

  /**
   * Required. A SQL boolean expression that represents the rows defined by this row access policy,
   * similar to the boolean expression in a WHERE clause of a SELECT query on a table. References to
   * other tables, routines, and temporary functions are not supported. Examples: region="EU"
   * date_field = CAST('2019-9-27' as DATE) nullable_field is not NULL numeric_field BETWEEN 1.0 AND
   * 5.0
   * @param filterPredicate filterPredicate or {@code null} for none
   */
  public RowAccessPolicy setFilterPredicate(java.lang.String filterPredicate) {
    this.filterPredicate = filterPredicate;
    return this;
  }

  /**
   * Output only. The time when this row access policy was last modified, in milliseconds since the
   * epoch.
   * @return value or {@code null} for none
   */
  public String getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * Output only. The time when this row access policy was last modified, in milliseconds since the
   * epoch.
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public RowAccessPolicy setLastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * Required. Reference describing the ID of this row access policy.
   * @return value or {@code null} for none
   */
  public RowAccessPolicyReference getRowAccessPolicyReference() {
    return rowAccessPolicyReference;
  }

  /**
   * Required. Reference describing the ID of this row access policy.
   * @param rowAccessPolicyReference rowAccessPolicyReference or {@code null} for none
   */
  public RowAccessPolicy setRowAccessPolicyReference(RowAccessPolicyReference rowAccessPolicyReference) {
    this.rowAccessPolicyReference = rowAccessPolicyReference;
    return this;
  }

  @Override
  public RowAccessPolicy set(String fieldName, Object value) {
    return (RowAccessPolicy) super.set(fieldName, value);
  }

  @Override
  public RowAccessPolicy clone() {
    return (RowAccessPolicy) super.clone();
  }

}
