/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.bigquery;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.bigquery.BigqueryRequest;
import com.google.api.services.bigquery.BigqueryRequestInitializer;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.ProjectList;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableList;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bigquery
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "bigquery/v2/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/bigquery/v2/";

    public Bigquery(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Bigquery(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Datasets datasets() {
        return new Datasets();
    }

    public Jobs jobs() {
        return new Jobs();
    }

    public Projects projects() {
        return new Projects();
    }

    public Tabledata tabledata() {
        return new Tabledata();
    }

    public Tables tables() {
        return new Tables();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.15.0-rc of the BigQuery API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Bigquery.DEFAULT_ROOT_URL, Bigquery.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Bigquery build() {
            return new Bigquery(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setBigqueryRequestInitializer(BigqueryRequestInitializer bigqueryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)bigqueryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Tables {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, String string2, Table table) throws IOException {
            Insert insert = new Insert(string, string2, table);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, Table table) throws IOException {
            Patch patch = new Patch(string, string2, string3, table);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, String string3, Table table) throws IOException {
            Update update = new Update(string, string2, string3, table);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Update(String string, String string2, String string3, Table table) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)table, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Update setTableId(String string) {
                this.tableId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Patch(String string, String string2, String string3, Table table) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)table, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Patch setTableId(String string) {
                this.tableId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<TableList> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, TableList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Insert(String string, String string2, Table table) {
                super(Bigquery.this, "POST", REST_PATH, (Object)table, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Insert setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest<Table> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Get(String string, String string2, String string3) {
                super(Bigquery.this, "GET", REST_PATH, null, Table.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Get setTableId(String string) {
                this.tableId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;

            protected Delete(String string, String string2, String string3) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public Delete setTableId(String string) {
                this.tableId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Tabledata {
        public List list(String string, String string2, String string3) throws IOException {
            List list = new List(string, string2, string3);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<TableDataList> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}/tables/{tableId}/data";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private String tableId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private BigInteger startIndex;

            protected List(String string, String string2, String string3) {
                super(Bigquery.this, "GET", REST_PATH, null, TableDataList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
                this.tableId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter tableId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public List setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public String getTableId() {
                return this.tableId;
            }

            public List setTableId(String string) {
                this.tableId = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public BigInteger getStartIndex() {
                return this.startIndex;
            }

            public List setStartIndex(BigInteger bigInteger) {
                this.startIndex = bigInteger;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Projects {
        public List list() throws IOException {
            List list = new List();
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<ProjectList> {
            private static final String REST_PATH = "projects";
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List() {
                super(Bigquery.this, "GET", REST_PATH, null, ProjectList.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }

    public class Jobs {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetQueryResults getQueryResults(String string, String string2) throws IOException {
            GetQueryResults getQueryResults = new GetQueryResults(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)getQueryResults);
            return getQueryResults;
        }

        public Insert insert(String string, Job job) throws IOException {
            Insert insert = new Insert(string, job);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(String string, Job job, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string, job, abstractInputStreamContent);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Query query(String string, QueryRequest queryRequest) throws IOException {
            Query query = new Query(string, queryRequest);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)query);
            return query;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Query
        extends BigqueryRequest<QueryResponse> {
            private static final String REST_PATH = "projects/{projectId}/queries";
            @Key
            private String projectId;

            protected Query(String string, QueryRequest queryRequest) {
                super(Bigquery.this, "POST", REST_PATH, (Object)queryRequest, QueryResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Query setAlt(String string) {
                return (Query)super.setAlt(string);
            }

            public Query setFields(String string) {
                return (Query)super.setFields(string);
            }

            public Query setKey(String string) {
                return (Query)super.setKey(string);
            }

            public Query setOauthToken(String string) {
                return (Query)super.setOauthToken(string);
            }

            public Query setPrettyPrint(Boolean bl) {
                return (Query)super.setPrettyPrint(bl);
            }

            public Query setQuotaUser(String string) {
                return (Query)super.setQuotaUser(string);
            }

            public Query setUserIp(String string) {
                return (Query)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Query setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Query set(String string, Object object) {
                return (Query)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<JobList> {
            private static final String REST_PATH = "projects/{projectId}/jobs";
            @Key
            private String projectId;
            @Key
            private String projection;
            @Key
            private java.util.List<String> stateFilter;
            @Key
            private Boolean allUsers;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(String string) {
                super(Bigquery.this, "GET", REST_PATH, null, JobList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public java.util.List<String> getStateFilter() {
                return this.stateFilter;
            }

            public List setStateFilter(java.util.List<String> list) {
                this.stateFilter = list;
                return this;
            }

            public Boolean getAllUsers() {
                return this.allUsers;
            }

            public List setAllUsers(Boolean bl) {
                this.allUsers = bl;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest<Job> {
            private static final String REST_PATH = "projects/{projectId}/jobs";
            @Key
            private String projectId;

            protected Insert(String string, Job job) {
                super(Bigquery.this, "POST", REST_PATH, (Object)job, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            protected Insert(String string, Job job, AbstractInputStreamContent abstractInputStreamContent) {
                super(Bigquery.this, "POST", "/upload/" + Bigquery.this.getServicePath() + REST_PATH, (Object)job, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetQueryResults
        extends BigqueryRequest<GetQueryResultsResponse> {
            private static final String REST_PATH = "projects/{projectId}/queries/{jobId}";
            @Key
            private String projectId;
            @Key
            private String jobId;
            @Key
            private Long timeoutMs;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private BigInteger startIndex;

            protected GetQueryResults(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, GetQueryResultsResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetQueryResults setAlt(String string) {
                return (GetQueryResults)super.setAlt(string);
            }

            public GetQueryResults setFields(String string) {
                return (GetQueryResults)super.setFields(string);
            }

            public GetQueryResults setKey(String string) {
                return (GetQueryResults)super.setKey(string);
            }

            public GetQueryResults setOauthToken(String string) {
                return (GetQueryResults)super.setOauthToken(string);
            }

            public GetQueryResults setPrettyPrint(Boolean bl) {
                return (GetQueryResults)super.setPrettyPrint(bl);
            }

            public GetQueryResults setQuotaUser(String string) {
                return (GetQueryResults)super.setQuotaUser(string);
            }

            public GetQueryResults setUserIp(String string) {
                return (GetQueryResults)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetQueryResults setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public GetQueryResults setJobId(String string) {
                this.jobId = string;
                return this;
            }

            public Long getTimeoutMs() {
                return this.timeoutMs;
            }

            public GetQueryResults setTimeoutMs(Long l) {
                this.timeoutMs = l;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public GetQueryResults setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public GetQueryResults setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public BigInteger getStartIndex() {
                return this.startIndex;
            }

            public GetQueryResults setStartIndex(BigInteger bigInteger) {
                this.startIndex = bigInteger;
                return this;
            }

            @Override
            public GetQueryResults set(String string, Object object) {
                return (GetQueryResults)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest<Job> {
            private static final String REST_PATH = "projects/{projectId}/jobs/{jobId}";
            @Key
            private String projectId;
            @Key
            private String jobId;

            protected Get(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, Job.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getJobId() {
                return this.jobId;
            }

            public Get setJobId(String string) {
                this.jobId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Datasets {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Dataset dataset) throws IOException {
            Insert insert = new Insert(string, dataset);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Dataset dataset) throws IOException {
            Patch patch = new Patch(string, string2, dataset);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Dataset dataset) throws IOException {
            Update update = new Update(string, string2, dataset);
            Bigquery.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Update(String string, String string2, Dataset dataset) {
                super(Bigquery.this, "PUT", REST_PATH, (Object)dataset, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Update setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Patch(String string, String string2, Dataset dataset) {
                super(Bigquery.this, "PATCH", REST_PATH, (Object)dataset, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Patch setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Patch setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends BigqueryRequest<DatasetList> {
            private static final String REST_PATH = "projects/{projectId}/datasets";
            @Key
            private String projectId;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Bigquery.this, "GET", REST_PATH, null, DatasetList.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public List setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets";
            @Key
            private String projectId;

            protected Insert(String string, Dataset dataset) {
                super(Bigquery.this, "POST", REST_PATH, (Object)dataset, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Insert setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends BigqueryRequest<Dataset> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;

            protected Get(String string, String string2) {
                super(Bigquery.this, "GET", REST_PATH, null, Dataset.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Get setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends BigqueryRequest<Void> {
            private static final String REST_PATH = "projects/{projectId}/datasets/{datasetId}";
            @Key
            private String projectId;
            @Key
            private String datasetId;
            @Key
            private Boolean deleteContents;

            protected Delete(String string, String string2) {
                super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                this.datasetId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter datasetId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String string) {
                this.projectId = string;
                return this;
            }

            public String getDatasetId() {
                return this.datasetId;
            }

            public Delete setDatasetId(String string) {
                this.datasetId = string;
                return this;
            }

            public Boolean getDeleteContents() {
                return this.deleteContents;
            }

            public Delete setDeleteContents(Boolean bl) {
                this.deleteContents = bl;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

