/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.analyticsreporting.v4;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Preconditions;
import com.google.api.services.analyticsreporting.v4.AnalyticsReportingRequest;
import com.google.api.services.analyticsreporting.v4.AnalyticsReportingRequestInitializer;
import com.google.api.services.analyticsreporting.v4.model.GetReportsRequest;
import com.google.api.services.analyticsreporting.v4.model.GetReportsResponse;
import com.google.api.services.analyticsreporting.v4.model.SearchUserActivityRequest;
import com.google.api.services.analyticsreporting.v4.model.SearchUserActivityResponse;
import java.io.IOException;

public class AnalyticsReporting
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://analyticsreporting.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://analyticsreporting.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://analyticsreporting.googleapis.com/";

    public AnalyticsReporting(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AnalyticsReporting(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Reports reports() {
        return new Reports();
    }

    public UserActivity userActivity() {
        return new UserActivity();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Analytics Reporting API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return AnalyticsReporting.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://analyticsreporting.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), AnalyticsReporting.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AnalyticsReporting.DEFAULT_BATCH_PATH);
        }

        public AnalyticsReporting build() {
            return new AnalyticsReporting(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAnalyticsReportingRequestInitializer(AnalyticsReportingRequestInitializer analyticsreportingRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)analyticsreportingRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class UserActivity {
        public Search search(SearchUserActivityRequest content) throws IOException {
            Search result = new Search(content);
            AnalyticsReporting.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends AnalyticsReportingRequest<SearchUserActivityResponse> {
            private static final String REST_PATH = "v4/userActivity:search";

            protected Search(SearchUserActivityRequest content) {
                super(AnalyticsReporting.this, "POST", REST_PATH, (Object)content, SearchUserActivityResponse.class);
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }
    }

    public class Reports {
        public BatchGet batchGet(GetReportsRequest content) throws IOException {
            BatchGet result = new BatchGet(content);
            AnalyticsReporting.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class BatchGet
        extends AnalyticsReportingRequest<GetReportsResponse> {
            private static final String REST_PATH = "v4/reports:batchGet";

            protected BatchGet(GetReportsRequest content) {
                super(AnalyticsReporting.this, "POST", REST_PATH, (Object)content, GetReportsResponse.class);
            }

            public BatchGet set$Xgafv(String $Xgafv) {
                return (BatchGet)super.set$Xgafv($Xgafv);
            }

            public BatchGet setAccessToken(String accessToken) {
                return (BatchGet)super.setAccessToken(accessToken);
            }

            public BatchGet setAlt(String alt) {
                return (BatchGet)super.setAlt(alt);
            }

            public BatchGet setCallback(String callback) {
                return (BatchGet)super.setCallback(callback);
            }

            public BatchGet setFields(String fields) {
                return (BatchGet)super.setFields(fields);
            }

            public BatchGet setKey(String key) {
                return (BatchGet)super.setKey(key);
            }

            public BatchGet setOauthToken(String oauthToken) {
                return (BatchGet)super.setOauthToken(oauthToken);
            }

            public BatchGet setPrettyPrint(Boolean prettyPrint) {
                return (BatchGet)super.setPrettyPrint(prettyPrint);
            }

            public BatchGet setQuotaUser(String quotaUser) {
                return (BatchGet)super.setQuotaUser(quotaUser);
            }

            public BatchGet setUploadType(String uploadType) {
                return (BatchGet)super.setUploadType(uploadType);
            }

            public BatchGet setUploadProtocol(String uploadProtocol) {
                return (BatchGet)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public BatchGet set(String parameterName, Object value) {
                return (BatchGet)super.set(parameterName, value);
            }
        }
    }
}

