/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-18 at 00:39:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * The Pivot describes the pivot section in the request. The Pivot helps rearrange the information
 * in the table for certain reports by pivoting your data on a second dimension.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Pivot extends com.google.api.client.json.GenericJson {

  /**
   * DimensionFilterClauses are logically combined with an `AND` operator: only data that is
   * included by all these DimensionFilterClauses contributes to the values in this pivot region.
   * Dimension filters can be used to restrict the columns shown in the pivot region. For example if
   * you have `ga:browser` as the requested dimension in the pivot region, and you specify key
   * filters to restrict `ga:browser` to only "IE" or "Firefox", then only those two browsers would
   * show up as columns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionFilterClause> dimensionFilterClauses;

  static {
    // hack to force ProGuard to consider DimensionFilterClause used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DimensionFilterClause.class);
  }

  /**
   * A list of dimensions to show as pivot columns. A Pivot can have a maximum of 4 dimensions.
   * Pivot dimensions are part of the restriction on the total number of dimensions allowed in the
   * request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Dimension> dimensions;

  static {
    // hack to force ProGuard to consider Dimension used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Dimension.class);
  }

  /**
   * Specifies the maximum number of groups to return. The default value is 10, also the maximum
   * value is 1,000.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxGroupCount;

  /**
   * The pivot metrics. Pivot metrics are part of the restriction on total number of metrics allowed
   * in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Metric> metrics;

  /**
   * If k metrics were requested, then the response will contain some data-dependent multiple of k
   * columns in the report.  E.g., if you pivoted on the dimension `ga:browser` then you'd get k
   * columns for "Firefox", k columns for "IE", k columns for "Chrome", etc. The ordering of the
   * groups of columns is determined by descending order of "total" for the first of the k values.
   * Ties are broken by lexicographic ordering of the first pivot dimension, then lexicographic
   * ordering of the second pivot dimension, and so on.  E.g., if the totals for the first value for
   * Firefox, IE, and Chrome were 8, 2, 8, respectively, the order of columns would be Chrome,
   * Firefox, IE.
   *
   * The following let you choose which of the groups of k columns are included in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startGroup;

  /**
   * DimensionFilterClauses are logically combined with an `AND` operator: only data that is
   * included by all these DimensionFilterClauses contributes to the values in this pivot region.
   * Dimension filters can be used to restrict the columns shown in the pivot region. For example if
   * you have `ga:browser` as the requested dimension in the pivot region, and you specify key
   * filters to restrict `ga:browser` to only "IE" or "Firefox", then only those two browsers would
   * show up as columns.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionFilterClause> getDimensionFilterClauses() {
    return dimensionFilterClauses;
  }

  /**
   * DimensionFilterClauses are logically combined with an `AND` operator: only data that is
   * included by all these DimensionFilterClauses contributes to the values in this pivot region.
   * Dimension filters can be used to restrict the columns shown in the pivot region. For example if
   * you have `ga:browser` as the requested dimension in the pivot region, and you specify key
   * filters to restrict `ga:browser` to only "IE" or "Firefox", then only those two browsers would
   * show up as columns.
   * @param dimensionFilterClauses dimensionFilterClauses or {@code null} for none
   */
  public Pivot setDimensionFilterClauses(java.util.List<DimensionFilterClause> dimensionFilterClauses) {
    this.dimensionFilterClauses = dimensionFilterClauses;
    return this;
  }

  /**
   * A list of dimensions to show as pivot columns. A Pivot can have a maximum of 4 dimensions.
   * Pivot dimensions are part of the restriction on the total number of dimensions allowed in the
   * request.
   * @return value or {@code null} for none
   */
  public java.util.List<Dimension> getDimensions() {
    return dimensions;
  }

  /**
   * A list of dimensions to show as pivot columns. A Pivot can have a maximum of 4 dimensions.
   * Pivot dimensions are part of the restriction on the total number of dimensions allowed in the
   * request.
   * @param dimensions dimensions or {@code null} for none
   */
  public Pivot setDimensions(java.util.List<Dimension> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * Specifies the maximum number of groups to return. The default value is 10, also the maximum
   * value is 1,000.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxGroupCount() {
    return maxGroupCount;
  }

  /**
   * Specifies the maximum number of groups to return. The default value is 10, also the maximum
   * value is 1,000.
   * @param maxGroupCount maxGroupCount or {@code null} for none
   */
  public Pivot setMaxGroupCount(java.lang.Integer maxGroupCount) {
    this.maxGroupCount = maxGroupCount;
    return this;
  }

  /**
   * The pivot metrics. Pivot metrics are part of the restriction on total number of metrics allowed
   * in the request.
   * @return value or {@code null} for none
   */
  public java.util.List<Metric> getMetrics() {
    return metrics;
  }

  /**
   * The pivot metrics. Pivot metrics are part of the restriction on total number of metrics allowed
   * in the request.
   * @param metrics metrics or {@code null} for none
   */
  public Pivot setMetrics(java.util.List<Metric> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * If k metrics were requested, then the response will contain some data-dependent multiple of k
   * columns in the report.  E.g., if you pivoted on the dimension `ga:browser` then you'd get k
   * columns for "Firefox", k columns for "IE", k columns for "Chrome", etc. The ordering of the
   * groups of columns is determined by descending order of "total" for the first of the k values.
   * Ties are broken by lexicographic ordering of the first pivot dimension, then lexicographic
   * ordering of the second pivot dimension, and so on.  E.g., if the totals for the first value for
   * Firefox, IE, and Chrome were 8, 2, 8, respectively, the order of columns would be Chrome,
   * Firefox, IE.
   *
   * The following let you choose which of the groups of k columns are included in the response.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartGroup() {
    return startGroup;
  }

  /**
   * If k metrics were requested, then the response will contain some data-dependent multiple of k
   * columns in the report.  E.g., if you pivoted on the dimension `ga:browser` then you'd get k
   * columns for "Firefox", k columns for "IE", k columns for "Chrome", etc. The ordering of the
   * groups of columns is determined by descending order of "total" for the first of the k values.
   * Ties are broken by lexicographic ordering of the first pivot dimension, then lexicographic
   * ordering of the second pivot dimension, and so on.  E.g., if the totals for the first value for
   * Firefox, IE, and Chrome were 8, 2, 8, respectively, the order of columns would be Chrome,
   * Firefox, IE.
   *
   * The following let you choose which of the groups of k columns are included in the response.
   * @param startGroup startGroup or {@code null} for none
   */
  public Pivot setStartGroup(java.lang.Integer startGroup) {
    this.startGroup = startGroup;
    return this;
  }

  @Override
  public Pivot set(String fieldName, Object value) {
    return (Pivot) super.set(fieldName, value);
  }

  @Override
  public Pivot clone() {
    return (Pivot) super.clone();
  }

}
