/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-06-18 at 00:39:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * The batch request containing multiple report request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetReportsRequest extends com.google.api.client.json.GenericJson {

  /**
   * Requests, each request will have a separate response. There can be a maximum of 5 requests. All
   * requests should have the same `dateRanges`, `viewId`, `segments`, `samplingLevel`, and
   * `cohortGroup`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ReportRequest> reportRequests;

  static {
    // hack to force ProGuard to consider ReportRequest used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ReportRequest.class);
  }

  /**
   * Enables [resource based quotas](/analytics/devguides/reporting/core/v4/limits-
   * quotas#analytics_reporting_api_v4), (defaults to `False`). If this field is set to `True` the
   * per view (profile) quotas are governed by the computational cost of the request. Note that
   * using cost based quotas will higher enable sampling rates. (10 Million for `SMALL`, 100M for
   * `LARGE`. See the [limits and quotas documentation](/analytics/devguides/reporting/core/v4
   * /limits-quotas#analytics_reporting_api_v4) for details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useResourceQuotas;

  /**
   * Requests, each request will have a separate response. There can be a maximum of 5 requests. All
   * requests should have the same `dateRanges`, `viewId`, `segments`, `samplingLevel`, and
   * `cohortGroup`.
   * @return value or {@code null} for none
   */
  public java.util.List<ReportRequest> getReportRequests() {
    return reportRequests;
  }

  /**
   * Requests, each request will have a separate response. There can be a maximum of 5 requests. All
   * requests should have the same `dateRanges`, `viewId`, `segments`, `samplingLevel`, and
   * `cohortGroup`.
   * @param reportRequests reportRequests or {@code null} for none
   */
  public GetReportsRequest setReportRequests(java.util.List<ReportRequest> reportRequests) {
    this.reportRequests = reportRequests;
    return this;
  }

  /**
   * Enables [resource based quotas](/analytics/devguides/reporting/core/v4/limits-
   * quotas#analytics_reporting_api_v4), (defaults to `False`). If this field is set to `True` the
   * per view (profile) quotas are governed by the computational cost of the request. Note that
   * using cost based quotas will higher enable sampling rates. (10 Million for `SMALL`, 100M for
   * `LARGE`. See the [limits and quotas documentation](/analytics/devguides/reporting/core/v4
   * /limits-quotas#analytics_reporting_api_v4) for details.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseResourceQuotas() {
    return useResourceQuotas;
  }

  /**
   * Enables [resource based quotas](/analytics/devguides/reporting/core/v4/limits-
   * quotas#analytics_reporting_api_v4), (defaults to `False`). If this field is set to `True` the
   * per view (profile) quotas are governed by the computational cost of the request. Note that
   * using cost based quotas will higher enable sampling rates. (10 Million for `SMALL`, 100M for
   * `LARGE`. See the [limits and quotas documentation](/analytics/devguides/reporting/core/v4
   * /limits-quotas#analytics_reporting_api_v4) for details.
   * @param useResourceQuotas useResourceQuotas or {@code null} for none
   */
  public GetReportsRequest setUseResourceQuotas(java.lang.Boolean useResourceQuotas) {
    this.useResourceQuotas = useResourceQuotas;
    return this;
  }

  @Override
  public GetReportsRequest set(String fieldName, Object value) {
    return (GetReportsRequest) super.set(fieldName, value);
  }

  @Override
  public GetReportsRequest clone() {
    return (GetReportsRequest) super.clone();
  }

}
