/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-06-09 16:41:44 UTC)
 * on 2014-06-18 at 00:10:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * Analytics data for a given view (profile).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GaData extends com.google.api.client.json.GenericJson {

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ColumnHeaders> columnHeaders;

  static {
    // hack to force ProGuard to consider ColumnHeaders used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ColumnHeaders.class);
  }

  /**
   * Determines if Analytics data contains samples.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean containsSampledData;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataTable dataTable;

  /**
   * Unique ID for this data response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The maximum number of rows the response can contain, regardless of the actual number of rows
   * returned. Its value ranges from 1 to 10,000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer itemsPerPage;

  /**
   * Resource type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Link to next page for this Analytics data query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextLink;

  /**
   * Link to previous page for this Analytics data query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String previousLink;

  /**
   * Information for the view (profile), for which the Analytics data was requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProfileInfo profileInfo;

  /**
   * Analytics data request query parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Query query;

  /**
   * Analytics data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.util.List<java.lang.String>> rows;

  /**
   * The number of samples used to calculate the result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long sampleSize;

  /**
   * Total size of the sample space from which the samples were selected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long sampleSpace;

  /**
   * Link to this page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalResults;

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> totalsForAllResults;

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * @return value or {@code null} for none
   */
  public java.util.List<ColumnHeaders> getColumnHeaders() {
    return columnHeaders;
  }

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * @param columnHeaders columnHeaders or {@code null} for none
   */
  public GaData setColumnHeaders(java.util.List<ColumnHeaders> columnHeaders) {
    this.columnHeaders = columnHeaders;
    return this;
  }

  /**
   * Determines if Analytics data contains samples.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getContainsSampledData() {
    return containsSampledData;
  }

  /**
   * Determines if Analytics data contains samples.
   * @param containsSampledData containsSampledData or {@code null} for none
   */
  public GaData setContainsSampledData(java.lang.Boolean containsSampledData) {
    this.containsSampledData = containsSampledData;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public DataTable getDataTable() {
    return dataTable;
  }

  /**
   * @param dataTable dataTable or {@code null} for none
   */
  public GaData setDataTable(DataTable dataTable) {
    this.dataTable = dataTable;
    return this;
  }

  /**
   * Unique ID for this data response.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Unique ID for this data response.
   * @param id id or {@code null} for none
   */
  public GaData setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The maximum number of rows the response can contain, regardless of the actual number of rows
   * returned. Its value ranges from 1 to 10,000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The maximum number of rows the response can contain, regardless of the actual number of rows
   * returned. Its value ranges from 1 to 10,000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * @param itemsPerPage itemsPerPage or {@code null} for none
   */
  public GaData setItemsPerPage(java.lang.Integer itemsPerPage) {
    this.itemsPerPage = itemsPerPage;
    return this;
  }

  /**
   * Resource type.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type.
   * @param kind kind or {@code null} for none
   */
  public GaData setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to next page for this Analytics data query.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextLink() {
    return nextLink;
  }

  /**
   * Link to next page for this Analytics data query.
   * @param nextLink nextLink or {@code null} for none
   */
  public GaData setNextLink(java.lang.String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * Link to previous page for this Analytics data query.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreviousLink() {
    return previousLink;
  }

  /**
   * Link to previous page for this Analytics data query.
   * @param previousLink previousLink or {@code null} for none
   */
  public GaData setPreviousLink(java.lang.String previousLink) {
    this.previousLink = previousLink;
    return this;
  }

  /**
   * Information for the view (profile), for which the Analytics data was requested.
   * @return value or {@code null} for none
   */
  public ProfileInfo getProfileInfo() {
    return profileInfo;
  }

  /**
   * Information for the view (profile), for which the Analytics data was requested.
   * @param profileInfo profileInfo or {@code null} for none
   */
  public GaData setProfileInfo(ProfileInfo profileInfo) {
    this.profileInfo = profileInfo;
    return this;
  }

  /**
   * Analytics data request query parameters.
   * @return value or {@code null} for none
   */
  public Query getQuery() {
    return query;
  }

  /**
   * Analytics data request query parameters.
   * @param query query or {@code null} for none
   */
  public GaData setQuery(Query query) {
    this.query = query;
    return this;
  }

  /**
   * Analytics data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * @return value or {@code null} for none
   */
  public java.util.List<java.util.List<java.lang.String>> getRows() {
    return rows;
  }

  /**
   * Analytics data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * @param rows rows or {@code null} for none
   */
  public GaData setRows(java.util.List<java.util.List<java.lang.String>> rows) {
    this.rows = rows;
    return this;
  }

  /**
   * The number of samples used to calculate the result.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSampleSize() {
    return sampleSize;
  }

  /**
   * The number of samples used to calculate the result.
   * @param sampleSize sampleSize or {@code null} for none
   */
  public GaData setSampleSize(java.lang.Long sampleSize) {
    this.sampleSize = sampleSize;
    return this;
  }

  /**
   * Total size of the sample space from which the samples were selected.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSampleSpace() {
    return sampleSpace;
  }

  /**
   * Total size of the sample space from which the samples were selected.
   * @param sampleSpace sampleSpace or {@code null} for none
   */
  public GaData setSampleSpace(java.lang.Long sampleSpace) {
    this.sampleSpace = sampleSpace;
    return this;
  }

  /**
   * Link to this page.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link to this page.
   * @param selfLink selfLink or {@code null} for none
   */
  public GaData setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * @param totalResults totalResults or {@code null} for none
   */
  public GaData setTotalResults(java.lang.Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getTotalsForAllResults() {
    return totalsForAllResults;
  }

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * @param totalsForAllResults totalsForAllResults or {@code null} for none
   */
  public GaData setTotalsForAllResults(java.util.Map<String, java.lang.String> totalsForAllResults) {
    this.totalsForAllResults = totalsForAllResults;
    return this;
  }

  @Override
  public GaData set(String fieldName, Object value) {
    return (GaData) super.set(fieldName, value);
  }

  @Override
  public GaData clone() {
    return (GaData) super.clone();
  }

  /**
   * Model definition for GaDataColumnHeaders.
   */
  public static final class ColumnHeaders extends com.google.api.client.json.GenericJson {

    /**
     * Column Type. Either DIMENSION or METRIC.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String columnType;

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String dataType;

    /**
     * Column name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * Column Type. Either DIMENSION or METRIC.
     * @return value or {@code null} for none
     */
    public java.lang.String getColumnType() {
      return columnType;
    }

    /**
     * Column Type. Either DIMENSION or METRIC.
     * @param columnType columnType or {@code null} for none
     */
    public ColumnHeaders setColumnType(java.lang.String columnType) {
      this.columnType = columnType;
      return this;
    }

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * @return value or {@code null} for none
     */
    public java.lang.String getDataType() {
      return dataType;
    }

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * @param dataType dataType or {@code null} for none
     */
    public ColumnHeaders setDataType(java.lang.String dataType) {
      this.dataType = dataType;
      return this;
    }

    /**
     * Column name.
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * Column name.
     * @param name name or {@code null} for none
     */
    public ColumnHeaders setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    @Override
    public ColumnHeaders set(String fieldName, Object value) {
      return (ColumnHeaders) super.set(fieldName, value);
    }

    @Override
    public ColumnHeaders clone() {
      return (ColumnHeaders) super.clone();
    }

  }

  /**
   * Model definition for GaDataDataTable.
   */
  public static final class DataTable extends com.google.api.client.json.GenericJson {

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Cols> cols;

    static {
      // hack to force ProGuard to consider Cols used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Cols.class);
    }

    /**
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Rows> rows;

    static {
      // hack to force ProGuard to consider Rows used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Rows.class);
    }

    /**
     * @return value or {@code null} for none
     */
    public java.util.List<Cols> getCols() {
      return cols;
    }

    /**
     * @param cols cols or {@code null} for none
     */
    public DataTable setCols(java.util.List<Cols> cols) {
      this.cols = cols;
      return this;
    }

    /**
     * @return value or {@code null} for none
     */
    public java.util.List<Rows> getRows() {
      return rows;
    }

    /**
     * @param rows rows or {@code null} for none
     */
    public DataTable setRows(java.util.List<Rows> rows) {
      this.rows = rows;
      return this;
    }

    @Override
    public DataTable set(String fieldName, Object value) {
      return (DataTable) super.set(fieldName, value);
    }

    @Override
    public DataTable clone() {
      return (DataTable) super.clone();
    }

    /**
     * Model definition for GaDataDataTableCols.
     */
    public static final class Cols extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String id;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String label;

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String type;

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getId() {
        return id;
      }

      /**
       * @param id id or {@code null} for none
       */
      public Cols setId(java.lang.String id) {
        this.id = id;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getLabel() {
        return label;
      }

      /**
       * @param label label or {@code null} for none
       */
      public Cols setLabel(java.lang.String label) {
        this.label = label;
        return this;
      }

      /**
       * @return value or {@code null} for none
       */
      public java.lang.String getType() {
        return type;
      }

      /**
       * @param type type or {@code null} for none
       */
      public Cols setType(java.lang.String type) {
        this.type = type;
        return this;
      }

      @Override
      public Cols set(String fieldName, Object value) {
        return (Cols) super.set(fieldName, value);
      }

      @Override
      public Cols clone() {
        return (Cols) super.clone();
      }

    }
    /**
     * Model definition for GaDataDataTableRows.
     */
    public static final class Rows extends com.google.api.client.json.GenericJson {

      /**
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.util.List<C> c;

      static {
        // hack to force ProGuard to consider C used, since otherwise it would be stripped out
        // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
        com.google.api.client.util.Data.nullOf(C.class);
      }

      /**
       * @return value or {@code null} for none
       */
      public java.util.List<C> getC() {
        return c;
      }

      /**
       * @param c c or {@code null} for none
       */
      public Rows setC(java.util.List<C> c) {
        this.c = c;
        return this;
      }

      @Override
      public Rows set(String fieldName, Object value) {
        return (Rows) super.set(fieldName, value);
      }

      @Override
      public Rows clone() {
        return (Rows) super.clone();
      }

      /**
       * Model definition for GaDataDataTableRowsC.
       */
      public static final class C extends com.google.api.client.json.GenericJson {

        /**
         * The value may be {@code null}.
         */
        @com.google.api.client.util.Key
        private java.lang.String v;

        /**
         * @return value or {@code null} for none
         */
        public java.lang.String getV() {
          return v;
        }

        /**
         * @param v v or {@code null} for none
         */
        public C setV(java.lang.String v) {
          this.v = v;
          return this;
        }

        @Override
        public C set(String fieldName, Object value) {
          return (C) super.set(fieldName, value);
        }

        @Override
        public C clone() {
          return (C) super.clone();
        }

      }
    }
  }

  /**
   * Information for the view (profile), for which the Analytics data was requested.
   */
  public static final class ProfileInfo extends com.google.api.client.json.GenericJson {

    /**
     * Account ID to which this view (profile) belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String accountId;

    /**
     * Internal ID for the web property to which this view (profile) belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String internalWebPropertyId;

    /**
     * View (Profile) ID.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String profileId;

    /**
     * View (Profile) name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String profileName;

    /**
     * Table ID for view (profile).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String tableId;

    /**
     * Web Property ID to which this view (profile) belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String webPropertyId;

    /**
     * Account ID to which this view (profile) belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getAccountId() {
      return accountId;
    }

    /**
     * Account ID to which this view (profile) belongs.
     * @param accountId accountId or {@code null} for none
     */
    public ProfileInfo setAccountId(java.lang.String accountId) {
      this.accountId = accountId;
      return this;
    }

    /**
     * Internal ID for the web property to which this view (profile) belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getInternalWebPropertyId() {
      return internalWebPropertyId;
    }

    /**
     * Internal ID for the web property to which this view (profile) belongs.
     * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
     */
    public ProfileInfo setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
      this.internalWebPropertyId = internalWebPropertyId;
      return this;
    }

    /**
     * View (Profile) ID.
     * @return value or {@code null} for none
     */
    public java.lang.String getProfileId() {
      return profileId;
    }

    /**
     * View (Profile) ID.
     * @param profileId profileId or {@code null} for none
     */
    public ProfileInfo setProfileId(java.lang.String profileId) {
      this.profileId = profileId;
      return this;
    }

    /**
     * View (Profile) name.
     * @return value or {@code null} for none
     */
    public java.lang.String getProfileName() {
      return profileName;
    }

    /**
     * View (Profile) name.
     * @param profileName profileName or {@code null} for none
     */
    public ProfileInfo setProfileName(java.lang.String profileName) {
      this.profileName = profileName;
      return this;
    }

    /**
     * Table ID for view (profile).
     * @return value or {@code null} for none
     */
    public java.lang.String getTableId() {
      return tableId;
    }

    /**
     * Table ID for view (profile).
     * @param tableId tableId or {@code null} for none
     */
    public ProfileInfo setTableId(java.lang.String tableId) {
      this.tableId = tableId;
      return this;
    }

    /**
     * Web Property ID to which this view (profile) belongs.
     * @return value or {@code null} for none
     */
    public java.lang.String getWebPropertyId() {
      return webPropertyId;
    }

    /**
     * Web Property ID to which this view (profile) belongs.
     * @param webPropertyId webPropertyId or {@code null} for none
     */
    public ProfileInfo setWebPropertyId(java.lang.String webPropertyId) {
      this.webPropertyId = webPropertyId;
      return this;
    }

    @Override
    public ProfileInfo set(String fieldName, Object value) {
      return (ProfileInfo) super.set(fieldName, value);
    }

    @Override
    public ProfileInfo clone() {
      return (ProfileInfo) super.clone();
    }

  }

  /**
   * Analytics data request query parameters.
   */
  public static final class Query extends com.google.api.client.json.GenericJson {

    /**
     * List of analytics dimensions.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String dimensions;

    /**
     * End date.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("end-date")
    private java.lang.String endDate;

    /**
     * Comma-separated list of dimension or metric filters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String filters;

    /**
     * Unique table ID.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String ids;

    /**
     * Maximum results per page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("max-results")
    private java.lang.Integer maxResults;

    /**
     * List of analytics metrics.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> metrics;

    /**
     * Desired sampling level
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String samplingLevel;

    /**
     * Analytics advanced segment.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String segment;

    /**
     * List of dimensions or metrics based on which Analytics data is sorted.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> sort;

    /**
     * Start date.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("start-date")
    private java.lang.String startDate;

    /**
     * Start index.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("start-index")
    private java.lang.Integer startIndex;

    /**
     * List of analytics dimensions.
     * @return value or {@code null} for none
     */
    public java.lang.String getDimensions() {
      return dimensions;
    }

    /**
     * List of analytics dimensions.
     * @param dimensions dimensions or {@code null} for none
     */
    public Query setDimensions(java.lang.String dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * End date.
     * @return value or {@code null} for none
     */
    public java.lang.String getEndDate() {
      return endDate;
    }

    /**
     * End date.
     * @param endDate endDate or {@code null} for none
     */
    public Query setEndDate(java.lang.String endDate) {
      this.endDate = endDate;
      return this;
    }

    /**
     * Comma-separated list of dimension or metric filters.
     * @return value or {@code null} for none
     */
    public java.lang.String getFilters() {
      return filters;
    }

    /**
     * Comma-separated list of dimension or metric filters.
     * @param filters filters or {@code null} for none
     */
    public Query setFilters(java.lang.String filters) {
      this.filters = filters;
      return this;
    }

    /**
     * Unique table ID.
     * @return value or {@code null} for none
     */
    public java.lang.String getIds() {
      return ids;
    }

    /**
     * Unique table ID.
     * @param ids ids or {@code null} for none
     */
    public Query setIds(java.lang.String ids) {
      this.ids = ids;
      return this;
    }

    /**
     * Maximum results per page.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getMaxResults() {
      return maxResults;
    }

    /**
     * Maximum results per page.
     * @param maxResults maxResults or {@code null} for none
     */
    public Query setMaxResults(java.lang.Integer maxResults) {
      this.maxResults = maxResults;
      return this;
    }

    /**
     * List of analytics metrics.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getMetrics() {
      return metrics;
    }

    /**
     * List of analytics metrics.
     * @param metrics metrics or {@code null} for none
     */
    public Query setMetrics(java.util.List<java.lang.String> metrics) {
      this.metrics = metrics;
      return this;
    }

    /**
     * Desired sampling level
     * @return value or {@code null} for none
     */
    public java.lang.String getSamplingLevel() {
      return samplingLevel;
    }

    /**
     * Desired sampling level
     * @param samplingLevel samplingLevel or {@code null} for none
     */
    public Query setSamplingLevel(java.lang.String samplingLevel) {
      this.samplingLevel = samplingLevel;
      return this;
    }

    /**
     * Analytics advanced segment.
     * @return value or {@code null} for none
     */
    public java.lang.String getSegment() {
      return segment;
    }

    /**
     * Analytics advanced segment.
     * @param segment segment or {@code null} for none
     */
    public Query setSegment(java.lang.String segment) {
      this.segment = segment;
      return this;
    }

    /**
     * List of dimensions or metrics based on which Analytics data is sorted.
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getSort() {
      return sort;
    }

    /**
     * List of dimensions or metrics based on which Analytics data is sorted.
     * @param sort sort or {@code null} for none
     */
    public Query setSort(java.util.List<java.lang.String> sort) {
      this.sort = sort;
      return this;
    }

    /**
     * Start date.
     * @return value or {@code null} for none
     */
    public java.lang.String getStartDate() {
      return startDate;
    }

    /**
     * Start date.
     * @param startDate startDate or {@code null} for none
     */
    public Query setStartDate(java.lang.String startDate) {
      this.startDate = startDate;
      return this;
    }

    /**
     * Start index.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getStartIndex() {
      return startIndex;
    }

    /**
     * Start index.
     * @param startIndex startIndex or {@code null} for none
     */
    public Query setStartIndex(java.lang.Integer startIndex) {
      this.startIndex = startIndex;
      return this;
    }

    @Override
    public Query set(String fieldName, Object value) {
      return (Query) super.set(fieldName, value);
    }

    @Override
    public Query clone() {
      return (Query) super.clone();
    }

  }

}
