/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-06-09 16:41:44 UTC)
 * on 2014-06-18 at 00:10:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for Analytics experiment resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Experiment extends com.google.api.client.json.GenericJson {

  /**
   * Account ID to which this experiment belongs. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountId;

  /**
   * Time the experiment was created. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * Notes about this experiment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * If true, the end user will be able to edit the experiment via the Google Analytics user
   * interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean editableInGaUi;

  /**
   * The ending time of the experiment (the time the status changed from RUNNING to ENDED). This
   * field is present only if the experiment has ended. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime endTime;

  /**
   * Boolean specifying whether to distribute traffic evenly across all variations. If the value is
   * False, content experiments follows the default behavior of adjusting traffic dynamically based
   * on variation performance. Optional -- defaults to False. This field may not be changed for an
   * experiment whose status is ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean equalWeighting;

  /**
   * Experiment ID. Required for patch and update. Disallowed for create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Internal ID for the web property to which this experiment belongs. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalWebPropertyId;

  /**
   * Resource type for an Analytics experiment. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * An integer number in [3, 90]. Specifies the minimum length of the experiment. Can be changed
   * for a running experiment. This field may not be changed for an experiments whose status is
   * ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minimumExperimentLengthInDays;

  /**
   * Experiment name. This field may not be changed for an experiment whose status is ENDED. This
   * field is required when creating an experiment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The metric that the experiment is optimizing. Valid values: "ga:goal(n)Completions",
   * "ga:adsenseAdsClicks", "ga:adsenseAdsViewed", "ga:adsenseRevenue", "ga:bounces",
   * "ga:pageviews", "ga:sessionDuration", "ga:transactions", "ga:transactionRevenue". This field is
   * required if status is "RUNNING" and servingFramework is one of "REDIRECT" or "API".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectiveMetric;

  /**
   * Whether the objectiveMetric should be minimized or maximized. Possible values: "MAXIMUM",
   * "MINIMUM". Optional--defaults to "MAXIMUM". Cannot be specified without objectiveMetric. Cannot
   * be modified when status is "RUNNING" or "ENDED".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String optimizationType;

  /**
   * Parent link for an experiment. Points to the view (profile) to which this experiment belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * View (Profile) ID to which this experiment belongs. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profileId;

  /**
   * Why the experiment ended. Possible values: "STOPPED_BY_USER", "WINNER_FOUND",
   * "EXPERIMENT_EXPIRED", "ENDED_WITH_NO_WINNER", "GOAL_OBJECTIVE_CHANGED". "ENDED_WITH_NO_WINNER"
   * means that the experiment didn't expire but no winner was projected to be found. If the
   * experiment status is changed via the API to ENDED this field is set to STOPPED_BY_USER. This
   * field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonExperimentEnded;

  /**
   * Boolean specifying whether variations URLS are rewritten to match those of the original. This
   * field may not be changed for an experiments whose status is ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean rewriteVariationUrlsAsOriginal;

  /**
   * Link for this experiment. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The framework used to serve the experiment variations and evaluate the results. One of: -
   * REDIRECT: Google Analytics redirects traffic to different variation pages, reports the chosen
   * variation and evaluates the results. - API: Google Analytics chooses and reports the variation
   * to serve and evaluates the results; the caller is responsible for serving the selected
   * variation. - EXTERNAL: The variations will be served externally and the chosen variation
   * reported to Google Analytics. The caller is responsible for serving the selected variation and
   * evaluating the results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String servingFramework;

  /**
   * The snippet of code to include on the control page(s). This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String snippet;

  /**
   * The starting time of the experiment (the time the status changed from READY_TO_RUN to RUNNING).
   * This field is present only if the experiment has started. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime startTime;

  /**
   * Experiment status. Possible values: "DRAFT", "READY_TO_RUN", "RUNNING", "ENDED". Experiments
   * can be created in the "DRAFT", "READY_TO_RUN" or "RUNNING" state. This field is required when
   * creating an experiment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * A floating-point number between 0 and 1. Specifies the fraction of the traffic that
   * participates in the experiment. Can be changed for a running experiment. This field may not be
   * changed for an experiments whose status is ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double trafficCoverage;

  /**
   * Time the experiment was last modified. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Array of variations. The first variation in the array is the original. The number of variations
   * may not change once an experiment is in the RUNNING state. At least two variations are required
   * before status can be set to RUNNING.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Variations> variations;

  static {
    // hack to force ProGuard to consider Variations used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Variations.class);
  }

  /**
   * Web property ID to which this experiment belongs. The web property ID is of the form UA-XXXXX-
   * YY. This field is read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webPropertyId;

  /**
   * A floating-point number between 0 and 1. Specifies the necessary confidence level to choose a
   * winner. This field may not be changed for an experiments whose status is ENDED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double winnerConfidenceLevel;

  /**
   * Boolean specifying whether a winner has been found for this experiment. This field is read-
   * only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean winnerFound;

  /**
   * Account ID to which this experiment belongs. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this experiment belongs. This field is read-only.
   * @param accountId accountId or {@code null} for none
   */
  public Experiment setAccountId(java.lang.String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Time the experiment was created. This field is read-only.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Time the experiment was created. This field is read-only.
   * @param created created or {@code null} for none
   */
  public Experiment setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Notes about this experiment.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Notes about this experiment.
   * @param description description or {@code null} for none
   */
  public Experiment setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * If true, the end user will be able to edit the experiment via the Google Analytics user
   * interface.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEditableInGaUi() {
    return editableInGaUi;
  }

  /**
   * If true, the end user will be able to edit the experiment via the Google Analytics user
   * interface.
   * @param editableInGaUi editableInGaUi or {@code null} for none
   */
  public Experiment setEditableInGaUi(java.lang.Boolean editableInGaUi) {
    this.editableInGaUi = editableInGaUi;
    return this;
  }

  /**
   * The ending time of the experiment (the time the status changed from RUNNING to ENDED). This
   * field is present only if the experiment has ended. This field is read-only.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getEndTime() {
    return endTime;
  }

  /**
   * The ending time of the experiment (the time the status changed from RUNNING to ENDED). This
   * field is present only if the experiment has ended. This field is read-only.
   * @param endTime endTime or {@code null} for none
   */
  public Experiment setEndTime(com.google.api.client.util.DateTime endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Boolean specifying whether to distribute traffic evenly across all variations. If the value is
   * False, content experiments follows the default behavior of adjusting traffic dynamically based
   * on variation performance. Optional -- defaults to False. This field may not be changed for an
   * experiment whose status is ENDED.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEqualWeighting() {
    return equalWeighting;
  }

  /**
   * Boolean specifying whether to distribute traffic evenly across all variations. If the value is
   * False, content experiments follows the default behavior of adjusting traffic dynamically based
   * on variation performance. Optional -- defaults to False. This field may not be changed for an
   * experiment whose status is ENDED.
   * @param equalWeighting equalWeighting or {@code null} for none
   */
  public Experiment setEqualWeighting(java.lang.Boolean equalWeighting) {
    this.equalWeighting = equalWeighting;
    return this;
  }

  /**
   * Experiment ID. Required for patch and update. Disallowed for create.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Experiment ID. Required for patch and update. Disallowed for create.
   * @param id id or {@code null} for none
   */
  public Experiment setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this experiment belongs. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this experiment belongs. This field is read-only.
   * @param internalWebPropertyId internalWebPropertyId or {@code null} for none
   */
  public Experiment setInternalWebPropertyId(java.lang.String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for an Analytics experiment. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for an Analytics experiment. This field is read-only.
   * @param kind kind or {@code null} for none
   */
  public Experiment setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * An integer number in [3, 90]. Specifies the minimum length of the experiment. Can be changed
   * for a running experiment. This field may not be changed for an experiments whose status is
   * ENDED.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinimumExperimentLengthInDays() {
    return minimumExperimentLengthInDays;
  }

  /**
   * An integer number in [3, 90]. Specifies the minimum length of the experiment. Can be changed
   * for a running experiment. This field may not be changed for an experiments whose status is
   * ENDED.
   * @param minimumExperimentLengthInDays minimumExperimentLengthInDays or {@code null} for none
   */
  public Experiment setMinimumExperimentLengthInDays(java.lang.Integer minimumExperimentLengthInDays) {
    this.minimumExperimentLengthInDays = minimumExperimentLengthInDays;
    return this;
  }

  /**
   * Experiment name. This field may not be changed for an experiment whose status is ENDED. This
   * field is required when creating an experiment.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Experiment name. This field may not be changed for an experiment whose status is ENDED. This
   * field is required when creating an experiment.
   * @param name name or {@code null} for none
   */
  public Experiment setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The metric that the experiment is optimizing. Valid values: "ga:goal(n)Completions",
   * "ga:adsenseAdsClicks", "ga:adsenseAdsViewed", "ga:adsenseRevenue", "ga:bounces",
   * "ga:pageviews", "ga:sessionDuration", "ga:transactions", "ga:transactionRevenue". This field is
   * required if status is "RUNNING" and servingFramework is one of "REDIRECT" or "API".
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectiveMetric() {
    return objectiveMetric;
  }

  /**
   * The metric that the experiment is optimizing. Valid values: "ga:goal(n)Completions",
   * "ga:adsenseAdsClicks", "ga:adsenseAdsViewed", "ga:adsenseRevenue", "ga:bounces",
   * "ga:pageviews", "ga:sessionDuration", "ga:transactions", "ga:transactionRevenue". This field is
   * required if status is "RUNNING" and servingFramework is one of "REDIRECT" or "API".
   * @param objectiveMetric objectiveMetric or {@code null} for none
   */
  public Experiment setObjectiveMetric(java.lang.String objectiveMetric) {
    this.objectiveMetric = objectiveMetric;
    return this;
  }

  /**
   * Whether the objectiveMetric should be minimized or maximized. Possible values: "MAXIMUM",
   * "MINIMUM". Optional--defaults to "MAXIMUM". Cannot be specified without objectiveMetric. Cannot
   * be modified when status is "RUNNING" or "ENDED".
   * @return value or {@code null} for none
   */
  public java.lang.String getOptimizationType() {
    return optimizationType;
  }

  /**
   * Whether the objectiveMetric should be minimized or maximized. Possible values: "MAXIMUM",
   * "MINIMUM". Optional--defaults to "MAXIMUM". Cannot be specified without objectiveMetric. Cannot
   * be modified when status is "RUNNING" or "ENDED".
   * @param optimizationType optimizationType or {@code null} for none
   */
  public Experiment setOptimizationType(java.lang.String optimizationType) {
    this.optimizationType = optimizationType;
    return this;
  }

  /**
   * Parent link for an experiment. Points to the view (profile) to which this experiment belongs.
   * @return value or {@code null} for none
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for an experiment. Points to the view (profile) to which this experiment belongs.
   * @param parentLink parentLink or {@code null} for none
   */
  public Experiment setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * View (Profile) ID to which this experiment belongs. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfileId() {
    return profileId;
  }

  /**
   * View (Profile) ID to which this experiment belongs. This field is read-only.
   * @param profileId profileId or {@code null} for none
   */
  public Experiment setProfileId(java.lang.String profileId) {
    this.profileId = profileId;
    return this;
  }

  /**
   * Why the experiment ended. Possible values: "STOPPED_BY_USER", "WINNER_FOUND",
   * "EXPERIMENT_EXPIRED", "ENDED_WITH_NO_WINNER", "GOAL_OBJECTIVE_CHANGED". "ENDED_WITH_NO_WINNER"
   * means that the experiment didn't expire but no winner was projected to be found. If the
   * experiment status is changed via the API to ENDED this field is set to STOPPED_BY_USER. This
   * field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonExperimentEnded() {
    return reasonExperimentEnded;
  }

  /**
   * Why the experiment ended. Possible values: "STOPPED_BY_USER", "WINNER_FOUND",
   * "EXPERIMENT_EXPIRED", "ENDED_WITH_NO_WINNER", "GOAL_OBJECTIVE_CHANGED". "ENDED_WITH_NO_WINNER"
   * means that the experiment didn't expire but no winner was projected to be found. If the
   * experiment status is changed via the API to ENDED this field is set to STOPPED_BY_USER. This
   * field is read-only.
   * @param reasonExperimentEnded reasonExperimentEnded or {@code null} for none
   */
  public Experiment setReasonExperimentEnded(java.lang.String reasonExperimentEnded) {
    this.reasonExperimentEnded = reasonExperimentEnded;
    return this;
  }

  /**
   * Boolean specifying whether variations URLS are rewritten to match those of the original. This
   * field may not be changed for an experiments whose status is ENDED.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRewriteVariationUrlsAsOriginal() {
    return rewriteVariationUrlsAsOriginal;
  }

  /**
   * Boolean specifying whether variations URLS are rewritten to match those of the original. This
   * field may not be changed for an experiments whose status is ENDED.
   * @param rewriteVariationUrlsAsOriginal rewriteVariationUrlsAsOriginal or {@code null} for none
   */
  public Experiment setRewriteVariationUrlsAsOriginal(java.lang.Boolean rewriteVariationUrlsAsOriginal) {
    this.rewriteVariationUrlsAsOriginal = rewriteVariationUrlsAsOriginal;
    return this;
  }

  /**
   * Link for this experiment. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this experiment. This field is read-only.
   * @param selfLink selfLink or {@code null} for none
   */
  public Experiment setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The framework used to serve the experiment variations and evaluate the results. One of: -
   * REDIRECT: Google Analytics redirects traffic to different variation pages, reports the chosen
   * variation and evaluates the results. - API: Google Analytics chooses and reports the variation
   * to serve and evaluates the results; the caller is responsible for serving the selected
   * variation. - EXTERNAL: The variations will be served externally and the chosen variation
   * reported to Google Analytics. The caller is responsible for serving the selected variation and
   * evaluating the results.
   * @return value or {@code null} for none
   */
  public java.lang.String getServingFramework() {
    return servingFramework;
  }

  /**
   * The framework used to serve the experiment variations and evaluate the results. One of: -
   * REDIRECT: Google Analytics redirects traffic to different variation pages, reports the chosen
   * variation and evaluates the results. - API: Google Analytics chooses and reports the variation
   * to serve and evaluates the results; the caller is responsible for serving the selected
   * variation. - EXTERNAL: The variations will be served externally and the chosen variation
   * reported to Google Analytics. The caller is responsible for serving the selected variation and
   * evaluating the results.
   * @param servingFramework servingFramework or {@code null} for none
   */
  public Experiment setServingFramework(java.lang.String servingFramework) {
    this.servingFramework = servingFramework;
    return this;
  }

  /**
   * The snippet of code to include on the control page(s). This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getSnippet() {
    return snippet;
  }

  /**
   * The snippet of code to include on the control page(s). This field is read-only.
   * @param snippet snippet or {@code null} for none
   */
  public Experiment setSnippet(java.lang.String snippet) {
    this.snippet = snippet;
    return this;
  }

  /**
   * The starting time of the experiment (the time the status changed from READY_TO_RUN to RUNNING).
   * This field is present only if the experiment has started. This field is read-only.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getStartTime() {
    return startTime;
  }

  /**
   * The starting time of the experiment (the time the status changed from READY_TO_RUN to RUNNING).
   * This field is present only if the experiment has started. This field is read-only.
   * @param startTime startTime or {@code null} for none
   */
  public Experiment setStartTime(com.google.api.client.util.DateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Experiment status. Possible values: "DRAFT", "READY_TO_RUN", "RUNNING", "ENDED". Experiments
   * can be created in the "DRAFT", "READY_TO_RUN" or "RUNNING" state. This field is required when
   * creating an experiment.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Experiment status. Possible values: "DRAFT", "READY_TO_RUN", "RUNNING", "ENDED". Experiments
   * can be created in the "DRAFT", "READY_TO_RUN" or "RUNNING" state. This field is required when
   * creating an experiment.
   * @param status status or {@code null} for none
   */
  public Experiment setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * A floating-point number between 0 and 1. Specifies the fraction of the traffic that
   * participates in the experiment. Can be changed for a running experiment. This field may not be
   * changed for an experiments whose status is ENDED.
   * @return value or {@code null} for none
   */
  public java.lang.Double getTrafficCoverage() {
    return trafficCoverage;
  }

  /**
   * A floating-point number between 0 and 1. Specifies the fraction of the traffic that
   * participates in the experiment. Can be changed for a running experiment. This field may not be
   * changed for an experiments whose status is ENDED.
   * @param trafficCoverage trafficCoverage or {@code null} for none
   */
  public Experiment setTrafficCoverage(java.lang.Double trafficCoverage) {
    this.trafficCoverage = trafficCoverage;
    return this;
  }

  /**
   * Time the experiment was last modified. This field is read-only.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Time the experiment was last modified. This field is read-only.
   * @param updated updated or {@code null} for none
   */
  public Experiment setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Array of variations. The first variation in the array is the original. The number of variations
   * may not change once an experiment is in the RUNNING state. At least two variations are required
   * before status can be set to RUNNING.
   * @return value or {@code null} for none
   */
  public java.util.List<Variations> getVariations() {
    return variations;
  }

  /**
   * Array of variations. The first variation in the array is the original. The number of variations
   * may not change once an experiment is in the RUNNING state. At least two variations are required
   * before status can be set to RUNNING.
   * @param variations variations or {@code null} for none
   */
  public Experiment setVariations(java.util.List<Variations> variations) {
    this.variations = variations;
    return this;
  }

  /**
   * Web property ID to which this experiment belongs. The web property ID is of the form UA-XXXXX-
   * YY. This field is read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID to which this experiment belongs. The web property ID is of the form UA-XXXXX-
   * YY. This field is read-only.
   * @param webPropertyId webPropertyId or {@code null} for none
   */
  public Experiment setWebPropertyId(java.lang.String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  /**
   * A floating-point number between 0 and 1. Specifies the necessary confidence level to choose a
   * winner. This field may not be changed for an experiments whose status is ENDED.
   * @return value or {@code null} for none
   */
  public java.lang.Double getWinnerConfidenceLevel() {
    return winnerConfidenceLevel;
  }

  /**
   * A floating-point number between 0 and 1. Specifies the necessary confidence level to choose a
   * winner. This field may not be changed for an experiments whose status is ENDED.
   * @param winnerConfidenceLevel winnerConfidenceLevel or {@code null} for none
   */
  public Experiment setWinnerConfidenceLevel(java.lang.Double winnerConfidenceLevel) {
    this.winnerConfidenceLevel = winnerConfidenceLevel;
    return this;
  }

  /**
   * Boolean specifying whether a winner has been found for this experiment. This field is read-
   * only.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWinnerFound() {
    return winnerFound;
  }

  /**
   * Boolean specifying whether a winner has been found for this experiment. This field is read-
   * only.
   * @param winnerFound winnerFound or {@code null} for none
   */
  public Experiment setWinnerFound(java.lang.Boolean winnerFound) {
    this.winnerFound = winnerFound;
    return this;
  }

  @Override
  public Experiment set(String fieldName, Object value) {
    return (Experiment) super.set(fieldName, value);
  }

  @Override
  public Experiment clone() {
    return (Experiment) super.clone();
  }

  /**
   * Parent link for an experiment. Points to the view (profile) to which this experiment belongs.
   */
  public static final class ParentLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the view (profile) to which this experiment belongs. This field is read-only.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Value is "analytics#profile". This field is read-only.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the view (profile) to which this experiment belongs. This field is read-only.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the view (profile) to which this experiment belongs. This field is read-only.
     * @param href href or {@code null} for none
     */
    public ParentLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#profile". This field is read-only.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Value is "analytics#profile". This field is read-only.
     * @param type type or {@code null} for none
     */
    public ParentLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ParentLink set(String fieldName, Object value) {
      return (ParentLink) super.set(fieldName, value);
    }

    @Override
    public ParentLink clone() {
      return (ParentLink) super.clone();
    }

  }

  /**
   * Model definition for ExperimentVariations.
   */
  public static final class Variations extends com.google.api.client.json.GenericJson {

    /**
     * The name of the variation. This field is required when creating an experiment. This field may
     * not be changed for an experiment whose status is ENDED.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String name;

    /**
     * Status of the variation. Possible values: "ACTIVE", "INACTIVE". INACTIVE variations are not
     * served. This field may not be changed for an experiment whose status is ENDED.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String status;

    /**
     * The URL of the variation. This field may not be changed for an experiment whose status is
     * RUNNING or ENDED.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String url;

    /**
     * Weight that this variation should receive. Only present if the experiment is running. This
     * field is read-only.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Double weight;

    /**
     * True if the experiment has ended and this variation performed (statistically) significantly
     * better than the original. This field is read-only.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean won;

    /**
     * The name of the variation. This field is required when creating an experiment. This field may
     * not be changed for an experiment whose status is ENDED.
     * @return value or {@code null} for none
     */
    public java.lang.String getName() {
      return name;
    }

    /**
     * The name of the variation. This field is required when creating an experiment. This field may
     * not be changed for an experiment whose status is ENDED.
     * @param name name or {@code null} for none
     */
    public Variations setName(java.lang.String name) {
      this.name = name;
      return this;
    }

    /**
     * Status of the variation. Possible values: "ACTIVE", "INACTIVE". INACTIVE variations are not
     * served. This field may not be changed for an experiment whose status is ENDED.
     * @return value or {@code null} for none
     */
    public java.lang.String getStatus() {
      return status;
    }

    /**
     * Status of the variation. Possible values: "ACTIVE", "INACTIVE". INACTIVE variations are not
     * served. This field may not be changed for an experiment whose status is ENDED.
     * @param status status or {@code null} for none
     */
    public Variations setStatus(java.lang.String status) {
      this.status = status;
      return this;
    }

    /**
     * The URL of the variation. This field may not be changed for an experiment whose status is
     * RUNNING or ENDED.
     * @return value or {@code null} for none
     */
    public java.lang.String getUrl() {
      return url;
    }

    /**
     * The URL of the variation. This field may not be changed for an experiment whose status is
     * RUNNING or ENDED.
     * @param url url or {@code null} for none
     */
    public Variations setUrl(java.lang.String url) {
      this.url = url;
      return this;
    }

    /**
     * Weight that this variation should receive. Only present if the experiment is running. This
     * field is read-only.
     * @return value or {@code null} for none
     */
    public java.lang.Double getWeight() {
      return weight;
    }

    /**
     * Weight that this variation should receive. Only present if the experiment is running. This
     * field is read-only.
     * @param weight weight or {@code null} for none
     */
    public Variations setWeight(java.lang.Double weight) {
      this.weight = weight;
      return this;
    }

    /**
     * True if the experiment has ended and this variation performed (statistically) significantly
     * better than the original. This field is read-only.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getWon() {
      return won;
    }

    /**
     * True if the experiment has ended and this variation performed (statistically) significantly
     * better than the original. This field is read-only.
     * @param won won or {@code null} for none
     */
    public Variations setWon(java.lang.Boolean won) {
      this.won = won;
      return this;
    }

    @Override
    public Variations set(String fieldName, Object value) {
      return (Variations) super.set(fieldName, value);
    }

    @Override
    public Variations clone() {
      return (Variations) super.clone();
    }

  }

}
