/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * JSON template for an Analytics web property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Webproperty extends GenericJson {

  /**
   * Account ID to which this web property belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String accountId;

  /**
   * Child link for this web property. Points to the list of profiles for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChildLink childLink;

  /**
   * Time this web property was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime created;

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * The industry vertical/category selected for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String industryVertical;

  /**
   * Internal ID for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String internalWebPropertyId;

  /**
   * Resource type for Analytics WebProperty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String level;

  /**
   * Name of this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Parent link for this web property. Points to the account to which this web property belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * Profile count for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer profileCount;

  /**
   * Link for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Time this web property was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * Website url for this web property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String websiteUrl;

  /**
   * Account ID to which this web property belongs.
   * The value returned may be {@code null}.
   */
  public String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this web property belongs.
   * The value set may be {@code null}.
   */
  public Webproperty setAccountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Child link for this web property. Points to the list of profiles for this web property.
   * The value returned may be {@code null}.
   */
  public ChildLink getChildLink() {
    return childLink;
  }

  /**
   * Child link for this web property. Points to the list of profiles for this web property.
   * The value set may be {@code null}.
   */
  public Webproperty setChildLink(ChildLink childLink) {
    this.childLink = childLink;
    return this;
  }

  /**
   * Time this web property was created.
   * The value returned may be {@code null}.
   */
  public DateTime getCreated() {
    return created;
  }

  /**
   * Time this web property was created.
   * The value set may be {@code null}.
   */
  public Webproperty setCreated(DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY.
   * The value set may be {@code null}.
   */
  public Webproperty setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The industry vertical/category selected for this web property.
   * The value returned may be {@code null}.
   */
  public String getIndustryVertical() {
    return industryVertical;
  }

  /**
   * The industry vertical/category selected for this web property.
   * The value set may be {@code null}.
   */
  public Webproperty setIndustryVertical(String industryVertical) {
    this.industryVertical = industryVertical;
    return this;
  }

  /**
   * Internal ID for this web property.
   * The value returned may be {@code null}.
   */
  public String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for this web property.
   * The value set may be {@code null}.
   */
  public Webproperty setInternalWebPropertyId(String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for Analytics WebProperty.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics WebProperty.
   * The value set may be {@code null}.
   */
  public Webproperty setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * The value returned may be {@code null}.
   */
  public String getLevel() {
    return level;
  }

  /**
   * Level for this web property. Possible values are STANDARD or PREMIUM.
   * The value set may be {@code null}.
   */
  public Webproperty setLevel(String level) {
    this.level = level;
    return this;
  }

  /**
   * Name of this web property.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of this web property.
   * The value set may be {@code null}.
   */
  public Webproperty setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Parent link for this web property. Points to the account to which this web property belongs.
   * The value returned may be {@code null}.
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for this web property. Points to the account to which this web property belongs.
   * The value set may be {@code null}.
   */
  public Webproperty setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * Profile count for this web property.
   * The value returned may be {@code null}.
   */
  public Integer getProfileCount() {
    return profileCount;
  }

  /**
   * Profile count for this web property.
   * The value set may be {@code null}.
   */
  public Webproperty setProfileCount(Integer profileCount) {
    this.profileCount = profileCount;
    return this;
  }

  /**
   * Link for this web property.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this web property.
   * The value set may be {@code null}.
   */
  public Webproperty setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Time this web property was last modified.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this web property was last modified.
   * The value set may be {@code null}.
   */
  public Webproperty setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Website url for this web property.
   * The value returned may be {@code null}.
   */
  public String getWebsiteUrl() {
    return websiteUrl;
  }

  /**
   * Website url for this web property.
   * The value set may be {@code null}.
   */
  public Webproperty setWebsiteUrl(String websiteUrl) {
    this.websiteUrl = websiteUrl;
    return this;
  }

  /**
   * Child link for this web property. Points to the list of profiles for this web property.
   */
  public static final class ChildLink extends GenericJson {

    /**
     * Link to the list of profiles for this web property.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Type of the parent link. Its value is "analytics#profiles".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the list of profiles for this web property.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the list of profiles for this web property.
     * The value set may be {@code null}.
     */
    public ChildLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Type of the parent link. Its value is "analytics#profiles".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Type of the parent link. Its value is "analytics#profiles".
     * The value set may be {@code null}.
     */
    public ChildLink setType(String type) {
      this.type = type;
      return this;
    }

  }

  /**
   * Parent link for this web property. Points to the account to which this web property belongs.
   */
  public static final class ParentLink extends GenericJson {

    /**
     * Link to the account for this web property.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Type of the parent link. Its value is "analytics#account".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the account for this web property.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the account for this web property.
     * The value set may be {@code null}.
     */
    public ParentLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Type of the parent link. Its value is "analytics#account".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Type of the parent link. Its value is "analytics#account".
     * The value set may be {@code null}.
     */
    public ParentLink setType(String type) {
      this.type = type;
      return this;
    }

  }

}
