/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.DateTime;

/**
 * JSON template for an Analytics profile.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Profile extends GenericJson {

  /**
   * Account ID to which this profile belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String accountId;

  /**
   * Child link for this profile. Points to the list of goals for this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChildLink childLink;

  /**
   * Time this profile was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime created;

  /**
   * The currency type associated with this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String currency;

  /**
   * Default page for this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String defaultPage;

  /**
   * Indicates whether ecommerce tracking is enabled for this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean eCommerceTracking;

  /**
   * The query parameters that are excluded from this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String excludeQueryParameters;

  /**
   * Profile ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Internal ID for the web property to which this profile belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String internalWebPropertyId;

  /**
   * Resource type for Analytics profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Parent link for this profile. Points to the web property to which this profile belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ParentLink parentLink;

  /**
   * Link for this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Site search category parameters for this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String siteSearchCategoryParameters;

  /**
   * The site search query parameters for this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String siteSearchQueryParameters;

  /**
   * Time zone for which this profile has been configured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timezone;

  /**
   * Profile type. Supported types: WEB or APP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * Time this profile was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime updated;

  /**
   * Web property ID of the form UA-XXXXX-YY to which this profile belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String webPropertyId;

  /**
   * Website URL for this profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String websiteUrl;

  /**
   * Account ID to which this profile belongs.
   * The value returned may be {@code null}.
   */
  public String getAccountId() {
    return accountId;
  }

  /**
   * Account ID to which this profile belongs.
   * The value set may be {@code null}.
   */
  public Profile setAccountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Child link for this profile. Points to the list of goals for this profile.
   * The value returned may be {@code null}.
   */
  public ChildLink getChildLink() {
    return childLink;
  }

  /**
   * Child link for this profile. Points to the list of goals for this profile.
   * The value set may be {@code null}.
   */
  public Profile setChildLink(ChildLink childLink) {
    this.childLink = childLink;
    return this;
  }

  /**
   * Time this profile was created.
   * The value returned may be {@code null}.
   */
  public DateTime getCreated() {
    return created;
  }

  /**
   * Time this profile was created.
   * The value set may be {@code null}.
   */
  public Profile setCreated(DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * The currency type associated with this profile.
   * The value returned may be {@code null}.
   */
  public String getCurrency() {
    return currency;
  }

  /**
   * The currency type associated with this profile.
   * The value set may be {@code null}.
   */
  public Profile setCurrency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Default page for this profile.
   * The value returned may be {@code null}.
   */
  public String getDefaultPage() {
    return defaultPage;
  }

  /**
   * Default page for this profile.
   * The value set may be {@code null}.
   */
  public Profile setDefaultPage(String defaultPage) {
    this.defaultPage = defaultPage;
    return this;
  }

  /**
   * Indicates whether ecommerce tracking is enabled for this profile.
   * The value returned may be {@code null}.
   */
  public Boolean getECommerceTracking() {
    return eCommerceTracking;
  }

  /**
   * Indicates whether ecommerce tracking is enabled for this profile.
   * The value set may be {@code null}.
   */
  public Profile setECommerceTracking(Boolean eCommerceTracking) {
    this.eCommerceTracking = eCommerceTracking;
    return this;
  }

  /**
   * The query parameters that are excluded from this profile.
   * The value returned may be {@code null}.
   */
  public String getExcludeQueryParameters() {
    return excludeQueryParameters;
  }

  /**
   * The query parameters that are excluded from this profile.
   * The value set may be {@code null}.
   */
  public Profile setExcludeQueryParameters(String excludeQueryParameters) {
    this.excludeQueryParameters = excludeQueryParameters;
    return this;
  }

  /**
   * Profile ID.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Profile ID.
   * The value set may be {@code null}.
   */
  public Profile setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Internal ID for the web property to which this profile belongs.
   * The value returned may be {@code null}.
   */
  public String getInternalWebPropertyId() {
    return internalWebPropertyId;
  }

  /**
   * Internal ID for the web property to which this profile belongs.
   * The value set may be {@code null}.
   */
  public Profile setInternalWebPropertyId(String internalWebPropertyId) {
    this.internalWebPropertyId = internalWebPropertyId;
    return this;
  }

  /**
   * Resource type for Analytics profile.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics profile.
   * The value set may be {@code null}.
   */
  public Profile setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this profile.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of this profile.
   * The value set may be {@code null}.
   */
  public Profile setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Parent link for this profile. Points to the web property to which this profile belongs.
   * The value returned may be {@code null}.
   */
  public ParentLink getParentLink() {
    return parentLink;
  }

  /**
   * Parent link for this profile. Points to the web property to which this profile belongs.
   * The value set may be {@code null}.
   */
  public Profile setParentLink(ParentLink parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * Link for this profile.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this profile.
   * The value set may be {@code null}.
   */
  public Profile setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Site search category parameters for this profile.
   * The value returned may be {@code null}.
   */
  public String getSiteSearchCategoryParameters() {
    return siteSearchCategoryParameters;
  }

  /**
   * Site search category parameters for this profile.
   * The value set may be {@code null}.
   */
  public Profile setSiteSearchCategoryParameters(String siteSearchCategoryParameters) {
    this.siteSearchCategoryParameters = siteSearchCategoryParameters;
    return this;
  }

  /**
   * The site search query parameters for this profile.
   * The value returned may be {@code null}.
   */
  public String getSiteSearchQueryParameters() {
    return siteSearchQueryParameters;
  }

  /**
   * The site search query parameters for this profile.
   * The value set may be {@code null}.
   */
  public Profile setSiteSearchQueryParameters(String siteSearchQueryParameters) {
    this.siteSearchQueryParameters = siteSearchQueryParameters;
    return this;
  }

  /**
   * Time zone for which this profile has been configured.
   * The value returned may be {@code null}.
   */
  public String getTimezone() {
    return timezone;
  }

  /**
   * Time zone for which this profile has been configured.
   * The value set may be {@code null}.
   */
  public Profile setTimezone(String timezone) {
    this.timezone = timezone;
    return this;
  }

  /**
   * Profile type. Supported types: WEB or APP.
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * Profile type. Supported types: WEB or APP.
   * The value set may be {@code null}.
   */
  public Profile setType(String type) {
    this.type = type;
    return this;
  }

  /**
   * Time this profile was last modified.
   * The value returned may be {@code null}.
   */
  public DateTime getUpdated() {
    return updated;
  }

  /**
   * Time this profile was last modified.
   * The value set may be {@code null}.
   */
  public Profile setUpdated(DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this profile belongs.
   * The value returned may be {@code null}.
   */
  public String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property ID of the form UA-XXXXX-YY to which this profile belongs.
   * The value set may be {@code null}.
   */
  public Profile setWebPropertyId(String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

  /**
   * Website URL for this profile.
   * The value returned may be {@code null}.
   */
  public String getWebsiteUrl() {
    return websiteUrl;
  }

  /**
   * Website URL for this profile.
   * The value set may be {@code null}.
   */
  public Profile setWebsiteUrl(String websiteUrl) {
    this.websiteUrl = websiteUrl;
    return this;
  }

  /**
   * Child link for this profile. Points to the list of goals for this profile.
   */
  public static final class ChildLink extends GenericJson {

    /**
     * Link to the list of goals for this profile.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Value is "analytics#goals".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the list of goals for this profile.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the list of goals for this profile.
     * The value set may be {@code null}.
     */
    public ChildLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#goals".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Value is "analytics#goals".
     * The value set may be {@code null}.
     */
    public ChildLink setType(String type) {
      this.type = type;
      return this;
    }

  }

  /**
   * Parent link for this profile. Points to the web property to which this profile belongs.
   */
  public static final class ParentLink extends GenericJson {

    /**
     * Link to the web property to which this profile belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String href;

    /**
     * Value is "analytics#webproperty".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String type;

    /**
     * Link to the web property to which this profile belongs.
     * The value returned may be {@code null}.
     */
    public String getHref() {
      return href;
    }

    /**
     * Link to the web property to which this profile belongs.
     * The value set may be {@code null}.
     */
    public ParentLink setHref(String href) {
      this.href = href;
      return this;
    }

    /**
     * Value is "analytics#webproperty".
     * The value returned may be {@code null}.
     */
    public String getType() {
      return type;
    }

    /**
     * Value is "analytics#webproperty".
     * The value set may be {@code null}.
     */
    public ParentLink setType(String type) {
      this.type = type;
      return this;
    }

  }

}
