/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;

/**
 * Analytics data for a given profile.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GaData extends GenericJson {

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ColumnHeaders> columnHeaders;

  static {
    // hack to force ProGuard to consider ColumnHeaders used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ColumnHeaders.class);
  }

  /**
   * Determines if Analytics data contains samples.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean containsSampledData;

  /**
   * Unique ID for this data response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * The maximum number of rows the response can contain, regardless of the actual number of rows
   * returned. Its value ranges from 1 to 10,000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer itemsPerPage;

  /**
   * Resource type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Link to next page for this Analytics data query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextLink;

  /**
   * Link to previous page for this Analytics data query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String previousLink;

  /**
   * Information for the profile, for which the Analytics data was requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProfileInfo profileInfo;

  /**
   * Analytics data request query parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Query query;

  /**
   * Analytics data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.util.List<String>> rows;

  /**
   * Link to this page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer totalResults;

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, String> totalsForAllResults;

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * The value returned may be {@code null}.
   */
  public java.util.List<ColumnHeaders> getColumnHeaders() {
    return columnHeaders;
  }

  /**
   * Column headers that list dimension names followed by the metric names. The order of dimensions
   * and metrics is same as specified in the request.
   * The value set may be {@code null}.
   */
  public GaData setColumnHeaders(java.util.List<ColumnHeaders> columnHeaders) {
    this.columnHeaders = columnHeaders;
    return this;
  }

  /**
   * Determines if Analytics data contains samples.
   * The value returned may be {@code null}.
   */
  public Boolean getContainsSampledData() {
    return containsSampledData;
  }

  /**
   * Determines if Analytics data contains samples.
   * The value set may be {@code null}.
   */
  public GaData setContainsSampledData(Boolean containsSampledData) {
    this.containsSampledData = containsSampledData;
    return this;
  }

  /**
   * Unique ID for this data response.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Unique ID for this data response.
   * The value set may be {@code null}.
   */
  public GaData setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The maximum number of rows the response can contain, regardless of the actual number of rows
   * returned. Its value ranges from 1 to 10,000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * The value returned may be {@code null}.
   */
  public Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The maximum number of rows the response can contain, regardless of the actual number of rows
   * returned. Its value ranges from 1 to 10,000 with a value of 1000 by default, or otherwise
   * specified by the max-results query parameter.
   * The value set may be {@code null}.
   */
  public GaData setItemsPerPage(Integer itemsPerPage) {
    this.itemsPerPage = itemsPerPage;
    return this;
  }

  /**
   * Resource type.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type.
   * The value set may be {@code null}.
   */
  public GaData setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to next page for this Analytics data query.
   * The value returned may be {@code null}.
   */
  public String getNextLink() {
    return nextLink;
  }

  /**
   * Link to next page for this Analytics data query.
   * The value set may be {@code null}.
   */
  public GaData setNextLink(String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * Link to previous page for this Analytics data query.
   * The value returned may be {@code null}.
   */
  public String getPreviousLink() {
    return previousLink;
  }

  /**
   * Link to previous page for this Analytics data query.
   * The value set may be {@code null}.
   */
  public GaData setPreviousLink(String previousLink) {
    this.previousLink = previousLink;
    return this;
  }

  /**
   * Information for the profile, for which the Analytics data was requested.
   * The value returned may be {@code null}.
   */
  public ProfileInfo getProfileInfo() {
    return profileInfo;
  }

  /**
   * Information for the profile, for which the Analytics data was requested.
   * The value set may be {@code null}.
   */
  public GaData setProfileInfo(ProfileInfo profileInfo) {
    this.profileInfo = profileInfo;
    return this;
  }

  /**
   * Analytics data request query parameters.
   * The value returned may be {@code null}.
   */
  public Query getQuery() {
    return query;
  }

  /**
   * Analytics data request query parameters.
   * The value set may be {@code null}.
   */
  public GaData setQuery(Query query) {
    this.query = query;
    return this;
  }

  /**
   * Analytics data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * The value returned may be {@code null}.
   */
  public java.util.List<java.util.List<String>> getRows() {
    return rows;
  }

  /**
   * Analytics data rows, where each row contains a list of dimension values followed by the metric
   * values. The order of dimensions and metrics is same as specified in the request.
   * The value set may be {@code null}.
   */
  public GaData setRows(java.util.List<java.util.List<String>> rows) {
    this.rows = rows;
    return this;
  }

  /**
   * Link to this page.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Link to this page.
   * The value set may be {@code null}.
   */
  public GaData setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * The value returned may be {@code null}.
   */
  public Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of rows for the query, regardless of the number of rows in the response.
   * The value set may be {@code null}.
   */
  public GaData setTotalResults(Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * The value returned may be {@code null}.
   */
  public java.util.Map<String, String> getTotalsForAllResults() {
    return totalsForAllResults;
  }

  /**
   * Total values for the requested metrics over all the results, not just the results returned in
   * this response. The order of the metric totals is same as the metric order specified in the
   * request.
   * The value set may be {@code null}.
   */
  public GaData setTotalsForAllResults(java.util.Map<String, String> totalsForAllResults) {
    this.totalsForAllResults = totalsForAllResults;
    return this;
  }

  /**
   * Model definition for GaDataColumnHeaders.
   */
  public static final class ColumnHeaders extends GenericJson {

    /**
     * Column Type. Either DIMENSION or METRIC.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String columnType;

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String dataType;

    /**
     * Column name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String name;

    /**
     * Column Type. Either DIMENSION or METRIC.
     * The value returned may be {@code null}.
     */
    public String getColumnType() {
      return columnType;
    }

    /**
     * Column Type. Either DIMENSION or METRIC.
     * The value set may be {@code null}.
     */
    public ColumnHeaders setColumnType(String columnType) {
      this.columnType = columnType;
      return this;
    }

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * The value returned may be {@code null}.
     */
    public String getDataType() {
      return dataType;
    }

    /**
     * Data type. Dimension column headers have only STRING as the data type. Metric column headers
     * have data types for metric values such as INTEGER, DOUBLE, CURRENCY etc.
     * The value set may be {@code null}.
     */
    public ColumnHeaders setDataType(String dataType) {
      this.dataType = dataType;
      return this;
    }

    /**
     * Column name.
     * The value returned may be {@code null}.
     */
    public String getName() {
      return name;
    }

    /**
     * Column name.
     * The value set may be {@code null}.
     */
    public ColumnHeaders setName(String name) {
      this.name = name;
      return this;
    }

  }

  /**
   * Information for the profile, for which the Analytics data was requested.
   */
  public static final class ProfileInfo extends GenericJson {

    /**
     * Account ID to which this profile belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String accountId;

    /**
     * Internal ID for the web property to which this profile belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String internalWebPropertyId;

    /**
     * Profile ID.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String profileId;

    /**
     * Profile name.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String profileName;

    /**
     * Table ID for profile.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String tableId;

    /**
     * Web Property ID to which this profile belongs.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String webPropertyId;

    /**
     * Account ID to which this profile belongs.
     * The value returned may be {@code null}.
     */
    public String getAccountId() {
      return accountId;
    }

    /**
     * Account ID to which this profile belongs.
     * The value set may be {@code null}.
     */
    public ProfileInfo setAccountId(String accountId) {
      this.accountId = accountId;
      return this;
    }

    /**
     * Internal ID for the web property to which this profile belongs.
     * The value returned may be {@code null}.
     */
    public String getInternalWebPropertyId() {
      return internalWebPropertyId;
    }

    /**
     * Internal ID for the web property to which this profile belongs.
     * The value set may be {@code null}.
     */
    public ProfileInfo setInternalWebPropertyId(String internalWebPropertyId) {
      this.internalWebPropertyId = internalWebPropertyId;
      return this;
    }

    /**
     * Profile ID.
     * The value returned may be {@code null}.
     */
    public String getProfileId() {
      return profileId;
    }

    /**
     * Profile ID.
     * The value set may be {@code null}.
     */
    public ProfileInfo setProfileId(String profileId) {
      this.profileId = profileId;
      return this;
    }

    /**
     * Profile name.
     * The value returned may be {@code null}.
     */
    public String getProfileName() {
      return profileName;
    }

    /**
     * Profile name.
     * The value set may be {@code null}.
     */
    public ProfileInfo setProfileName(String profileName) {
      this.profileName = profileName;
      return this;
    }

    /**
     * Table ID for profile.
     * The value returned may be {@code null}.
     */
    public String getTableId() {
      return tableId;
    }

    /**
     * Table ID for profile.
     * The value set may be {@code null}.
     */
    public ProfileInfo setTableId(String tableId) {
      this.tableId = tableId;
      return this;
    }

    /**
     * Web Property ID to which this profile belongs.
     * The value returned may be {@code null}.
     */
    public String getWebPropertyId() {
      return webPropertyId;
    }

    /**
     * Web Property ID to which this profile belongs.
     * The value set may be {@code null}.
     */
    public ProfileInfo setWebPropertyId(String webPropertyId) {
      this.webPropertyId = webPropertyId;
      return this;
    }

  }

  /**
   * Analytics data request query parameters.
   */
  public static final class Query extends GenericJson {

    /**
     * List of analytics dimensions.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String dimensions;

    /**
     * End date.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("end-date")
    private String endDate;

    /**
     * Comma-separated list of dimension or metric filters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String filters;

    /**
     * Unique table ID.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String ids;

    /**
     * Maximum results per page.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("max-results")
    private Integer maxResults;

    /**
     * List of analytics metrics.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<String> metrics;

    /**
     * Analytics advanced segment.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String segment;

    /**
     * List of dimensions or metrics based on which Analytics data is sorted.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<String> sort;

    /**
     * Start date.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("start-date")
    private String startDate;

    /**
     * Start index.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("start-index")
    private Integer startIndex;

    /**
     * List of analytics dimensions.
     * The value returned may be {@code null}.
     */
    public String getDimensions() {
      return dimensions;
    }

    /**
     * List of analytics dimensions.
     * The value set may be {@code null}.
     */
    public Query setDimensions(String dimensions) {
      this.dimensions = dimensions;
      return this;
    }

    /**
     * End date.
     * The value returned may be {@code null}.
     */
    public String getEndDate() {
      return endDate;
    }

    /**
     * End date.
     * The value set may be {@code null}.
     */
    public Query setEndDate(String endDate) {
      this.endDate = endDate;
      return this;
    }

    /**
     * Comma-separated list of dimension or metric filters.
     * The value returned may be {@code null}.
     */
    public String getFilters() {
      return filters;
    }

    /**
     * Comma-separated list of dimension or metric filters.
     * The value set may be {@code null}.
     */
    public Query setFilters(String filters) {
      this.filters = filters;
      return this;
    }

    /**
     * Unique table ID.
     * The value returned may be {@code null}.
     */
    public String getIds() {
      return ids;
    }

    /**
     * Unique table ID.
     * The value set may be {@code null}.
     */
    public Query setIds(String ids) {
      this.ids = ids;
      return this;
    }

    /**
     * Maximum results per page.
     * The value returned may be {@code null}.
     */
    public Integer getMaxResults() {
      return maxResults;
    }

    /**
     * Maximum results per page.
     * The value set may be {@code null}.
     */
    public Query setMaxResults(Integer maxResults) {
      this.maxResults = maxResults;
      return this;
    }

    /**
     * List of analytics metrics.
     * The value returned may be {@code null}.
     */
    public java.util.List<String> getMetrics() {
      return metrics;
    }

    /**
     * List of analytics metrics.
     * The value set may be {@code null}.
     */
    public Query setMetrics(java.util.List<String> metrics) {
      this.metrics = metrics;
      return this;
    }

    /**
     * Analytics advanced segment.
     * The value returned may be {@code null}.
     */
    public String getSegment() {
      return segment;
    }

    /**
     * Analytics advanced segment.
     * The value set may be {@code null}.
     */
    public Query setSegment(String segment) {
      this.segment = segment;
      return this;
    }

    /**
     * List of dimensions or metrics based on which Analytics data is sorted.
     * The value returned may be {@code null}.
     */
    public java.util.List<String> getSort() {
      return sort;
    }

    /**
     * List of dimensions or metrics based on which Analytics data is sorted.
     * The value set may be {@code null}.
     */
    public Query setSort(java.util.List<String> sort) {
      this.sort = sort;
      return this;
    }

    /**
     * Start date.
     * The value returned may be {@code null}.
     */
    public String getStartDate() {
      return startDate;
    }

    /**
     * Start date.
     * The value set may be {@code null}.
     */
    public Query setStartDate(String startDate) {
      this.startDate = startDate;
      return this;
    }

    /**
     * Start index.
     * The value returned may be {@code null}.
     */
    public Integer getStartIndex() {
      return startIndex;
    }

    /**
     * Start index.
     * The value set may be {@code null}.
     */
    public Query setStartIndex(Integer startIndex) {
      this.startIndex = startIndex;
      return this;
    }

  }

}
