/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;

/**
 * Metadata returned for a successful append operation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DailyUploadAppend extends GenericJson {

  /**
   * Account Id to which this daily upload append belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String accountId;

  /**
   * Append number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer appendNumber;

  /**
   * Custom data source Id to which this daily upload append belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String customDataSourceId;

  /**
   * Date associated with daily upload append.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String date;

  /**
   * Resource type for Analytics daily upload append.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextAppendLink;

  /**
   * Web property Id of the form UA-XXXXX-YY to which this daily upload append belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String webPropertyId;

  /**
   * Account Id to which this daily upload append belongs.
   * The value returned may be {@code null}.
   */
  public String getAccountId() {
    return accountId;
  }

  /**
   * Account Id to which this daily upload append belongs.
   * The value set may be {@code null}.
   */
  public DailyUploadAppend setAccountId(String accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * Append number.
   * The value returned may be {@code null}.
   */
  public Integer getAppendNumber() {
    return appendNumber;
  }

  /**
   * Append number.
   * The value set may be {@code null}.
   */
  public DailyUploadAppend setAppendNumber(Integer appendNumber) {
    this.appendNumber = appendNumber;
    return this;
  }

  /**
   * Custom data source Id to which this daily upload append belongs.
   * The value returned may be {@code null}.
   */
  public String getCustomDataSourceId() {
    return customDataSourceId;
  }

  /**
   * Custom data source Id to which this daily upload append belongs.
   * The value set may be {@code null}.
   */
  public DailyUploadAppend setCustomDataSourceId(String customDataSourceId) {
    this.customDataSourceId = customDataSourceId;
    return this;
  }

  /**
   * Date associated with daily upload append.
   * The value returned may be {@code null}.
   */
  public String getDate() {
    return date;
  }

  /**
   * Date associated with daily upload append.
   * The value set may be {@code null}.
   */
  public DailyUploadAppend setDate(String date) {
    this.date = date;
    return this;
  }

  /**
   * Resource type for Analytics daily upload append.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics daily upload append.
   * The value set may be {@code null}.
   */
  public DailyUploadAppend setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**

   * The value returned may be {@code null}.
   */
  public String getNextAppendLink() {
    return nextAppendLink;
  }

  /**

   * The value set may be {@code null}.
   */
  public DailyUploadAppend setNextAppendLink(String nextAppendLink) {
    this.nextAppendLink = nextAppendLink;
    return this;
  }

  /**
   * Web property Id of the form UA-XXXXX-YY to which this daily upload append belongs.
   * The value returned may be {@code null}.
   */
  public String getWebPropertyId() {
    return webPropertyId;
  }

  /**
   * Web property Id of the form UA-XXXXX-YY to which this daily upload append belongs.
   * The value set may be {@code null}.
   */
  public DailyUploadAppend setWebPropertyId(String webPropertyId) {
    this.webPropertyId = webPropertyId;
    return this;
  }

}
