/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.analytics.model;

import com.google.api.client.json.GenericJson;

/**
 * Lists Analytics custom data sources to which the user has access. Each resource in the collection
 * corresponds to a single Analytics custom data source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomDataSources extends GenericJson {

  /**
   * Collection of custom data sources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomDataSource> items;

  static {
    // hack to force ProGuard to consider CustomDataSource used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(CustomDataSource.class);
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer itemsPerPage;

  /**
   * Collection type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Link to next page for this custom data source collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextLink;

  /**
   * Link to previous page for this custom data source collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String previousLink;

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer startIndex;

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer totalResults;

  /**
   * Email ID of the authenticated user
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String username;

  /**
   * Collection of custom data sources.
   * The value returned may be {@code null}.
   */
  public java.util.List<CustomDataSource> getItems() {
    return items;
  }

  /**
   * Collection of custom data sources.
   * The value set may be {@code null}.
   */
  public CustomDataSources setItems(java.util.List<CustomDataSource> items) {
    this.items = items;
    return this;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value returned may be {@code null}.
   */
  public Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value set may be {@code null}.
   */
  public CustomDataSources setItemsPerPage(Integer itemsPerPage) {
    this.itemsPerPage = itemsPerPage;
    return this;
  }

  /**
   * Collection type.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Collection type.
   * The value set may be {@code null}.
   */
  public CustomDataSources setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to next page for this custom data source collection.
   * The value returned may be {@code null}.
   */
  public String getNextLink() {
    return nextLink;
  }

  /**
   * Link to next page for this custom data source collection.
   * The value set may be {@code null}.
   */
  public CustomDataSources setNextLink(String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * Link to previous page for this custom data source collection.
   * The value returned may be {@code null}.
   */
  public String getPreviousLink() {
    return previousLink;
  }

  /**
   * Link to previous page for this custom data source collection.
   * The value set may be {@code null}.
   */
  public CustomDataSources setPreviousLink(String previousLink) {
    this.previousLink = previousLink;
    return this;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value returned may be {@code null}.
   */
  public Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value set may be {@code null}.
   */
  public CustomDataSources setStartIndex(Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value returned may be {@code null}.
   */
  public Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of results for the query, regardless of the number of results in the response.
   * The value set may be {@code null}.
   */
  public CustomDataSources setTotalResults(Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Email ID of the authenticated user
   * The value returned may be {@code null}.
   */
  public String getUsername() {
    return username;
  }

  /**
   * Email ID of the authenticated user
   * The value set may be {@code null}.
   */
  public CustomDataSources setUsername(String username) {
    this.username = username;
    return this;
  }

}
