/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.analytics;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.analytics.AnalyticsRequest;
import com.google.api.services.analytics.AnalyticsRequestInitializer;
import com.google.api.services.analytics.model.Accounts;
import com.google.api.services.analytics.model.CustomDataSources;
import com.google.api.services.analytics.model.DailyUploadAppend;
import com.google.api.services.analytics.model.DailyUploads;
import com.google.api.services.analytics.model.Experiment;
import com.google.api.services.analytics.model.Experiments;
import com.google.api.services.analytics.model.GaData;
import com.google.api.services.analytics.model.Goals;
import com.google.api.services.analytics.model.McfData;
import com.google.api.services.analytics.model.Profiles;
import com.google.api.services.analytics.model.Segments;
import com.google.api.services.analytics.model.Webproperties;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analytics
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "analytics/v3/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/analytics/v3/";

    public Analytics(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Analytics(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Data data() {
        return new Data();
    }

    public Management management() {
        return new Management();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION == 14 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need version 1.14 of google-api-client to run version 1.14.2-beta of the Google Analytics API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Analytics.DEFAULT_ROOT_URL, Analytics.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Analytics build() {
            return new Analytics(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setAnalyticsRequestInitializer(AnalyticsRequestInitializer analyticsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)analyticsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Management {
        public Accounts accounts() {
            return new Accounts();
        }

        public CustomDataSources customDataSources() {
            return new CustomDataSources();
        }

        public DailyUploads dailyUploads() {
            return new DailyUploads();
        }

        public Experiments experiments() {
            return new Experiments();
        }

        public Goals goals() {
            return new Goals();
        }

        public Profiles profiles() {
            return new Profiles();
        }

        public Segments segments() {
            return new Segments();
        }

        public Webproperties webproperties() {
            return new Webproperties();
        }

        public class Webproperties {
            public List list(String string) throws IOException {
                List list = new List(string);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperties> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties";
                @Key
                private String accountId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Webproperties.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Segments {
            public List list() throws IOException {
                List list = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Segments> {
                private static final String REST_PATH = "management/segments";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Segments.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Profiles {
            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Profiles> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Profiles.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Goals {
            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Goals> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Goals.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Experiments {
            public Delete delete(String string, String string2, String string3, String string4) throws IOException {
                Delete delete = new Delete(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, String string3, Experiment experiment) throws IOException {
                Insert insert = new Insert(string, string2, string3, experiment);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, String string4, Experiment experiment) throws IOException {
                Patch patch = new Patch(string, string2, string3, string4, experiment);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, String string4, Experiment experiment) throws IOException {
                Update update = new Update(string, string2, string3, string4, experiment);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Update(String string, String string2, String string3, String string4, Experiment experiment) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)experiment, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter experimentId must be specified.");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getId(), "Experiment.getId()");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getName(), "Experiment.getName()");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getStatus(), "Experiment.getStatus()");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Update setExperimentId(String string) {
                    this.experimentId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Patch(String string, String string2, String string3, String string4, Experiment experiment) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)experiment, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter experimentId must be specified.");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getId(), "Experiment.getId()");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Patch setExperimentId(String string) {
                    this.experimentId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Experiments> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";
                private final Pattern ACCOUNTID_PATTERN;
                private final Pattern WEBPROPERTYID_PATTERN;
                private final Pattern PROFILEID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiments.class);
                    this.ACCOUNTID_PATTERN = Pattern.compile("\\d+");
                    this.WEBPROPERTYID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILEID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILEID_PATTERN.matcher(string3).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILEID_PATTERN.matcher(string).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String string, String string2, String string3, Experiment experiment) {
                    super(Analytics.this, "POST", REST_PATH, (Object)experiment, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getName(), "Experiment.getName()");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getStatus(), "Experiment.getStatus()");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter experimentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Get setExperimentId(String string) {
                    this.experimentId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Delete(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter experimentId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Delete setExperimentId(String string) {
                    this.experimentId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class DailyUploads {
            public Delete delete(String string, String string2, String string3, String string4, String string5) throws IOException {
                Delete delete = new Delete(string, string2, string3, string4, string5);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public List list(String string, String string2, String string3, String string4, String string5) throws IOException {
                List list = new List(string, string2, string3, string4, string5);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Upload upload(String string, String string2, String string3, String string4, Integer n, String string5) throws IOException {
                Upload upload = new Upload(string, string2, string3, string4, n, string5);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            public Upload upload(String string, String string2, String string3, String string4, Integer n, String string5, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                Upload upload = new Upload(string, string2, string3, string4, n, string5, abstractInputStreamContent);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)upload);
                return upload;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Upload
            extends AnalyticsRequest<DailyUploadAppend> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads/{date}/uploads";
                private final Pattern ACCOUNTID_PATTERN;
                private final Pattern WEBPROPERTYID_PATTERN;
                private final Pattern DATE_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;
                @Key
                private String date;
                @Key
                private Integer appendNumber;
                @Key
                private String type;
                @Key
                private Boolean reset;

                protected Upload(String string, String string2, String string3, String string4, Integer n, String string5) {
                    super(Analytics.this, "POST", REST_PATH, null, DailyUploadAppend.class);
                    this.ACCOUNTID_PATTERN = Pattern.compile("\\d+");
                    this.WEBPROPERTYID_PATTERN = Pattern.compile("UA-\\d+-\\d+");
                    this.DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-\\d+-\\d+");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                    this.date = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter date must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DATE_PATTERN.matcher(string4).matches(), (Object)"Parameter date must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.appendNumber = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter appendNumber must be specified.");
                    this.type = (String)Preconditions.checkNotNull((Object)string5, (Object)"Required parameter type must be specified.");
                }

                protected Upload(String string, String string2, String string3, String string4, Integer n, String string5, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Analytics.this, "POST", "/upload/" + Analytics.this.getServicePath() + REST_PATH, null, DailyUploadAppend.class);
                    this.ACCOUNTID_PATTERN = Pattern.compile("\\d+");
                    this.WEBPROPERTYID_PATTERN = Pattern.compile("UA-\\d+-\\d+");
                    this.DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                    this.date = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter date must be specified.");
                    this.appendNumber = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter appendNumber must be specified.");
                    this.type = (String)Preconditions.checkNotNull((Object)string5, (Object)"Required parameter type must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public Upload setAlt(String string) {
                    return (Upload)super.setAlt(string);
                }

                public Upload setFields(String string) {
                    return (Upload)super.setFields(string);
                }

                public Upload setKey(String string) {
                    return (Upload)super.setKey(string);
                }

                public Upload setOauthToken(String string) {
                    return (Upload)super.setOauthToken(string);
                }

                public Upload setPrettyPrint(Boolean bl) {
                    return (Upload)super.setPrettyPrint(bl);
                }

                public Upload setQuotaUser(String string) {
                    return (Upload)super.setQuotaUser(string);
                }

                public Upload setUserIp(String string) {
                    return (Upload)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Upload setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Upload setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-\\d+-\\d+");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public Upload setCustomDataSourceId(String string) {
                    this.customDataSourceId = string;
                    return this;
                }

                public String getDate() {
                    return this.date;
                }

                public Upload setDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DATE_PATTERN.matcher(string).matches(), (Object)"Parameter date must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.date = string;
                    return this;
                }

                public Integer getAppendNumber() {
                    return this.appendNumber;
                }

                public Upload setAppendNumber(Integer n) {
                    this.appendNumber = n;
                    return this;
                }

                public String getType() {
                    return this.type;
                }

                public Upload setType(String string) {
                    this.type = string;
                    return this;
                }

                public Boolean getReset() {
                    return this.reset;
                }

                public Upload setReset(Boolean bl) {
                    this.reset = bl;
                    return this;
                }

                public boolean isReset() {
                    if (this.reset == null || this.reset == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.reset;
                }

                @Override
                public Upload set(String string, Object object) {
                    return (Upload)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.DailyUploads> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads";
                private final Pattern ACCOUNTID_PATTERN;
                private final Pattern WEBPROPERTYID_PATTERN;
                private final Pattern CUSTOMDATASOURCEID_PATTERN;
                private final Pattern STARTDATE_PATTERN;
                private final Pattern ENDDATE_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;
                @Key(value="start-date")
                private String startDate;
                @Key(value="end-date")
                private String endDate;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3, String string4, String string5) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.DailyUploads.class);
                    this.ACCOUNTID_PATTERN = Pattern.compile("\\d+");
                    this.WEBPROPERTYID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.CUSTOMDATASOURCEID_PATTERN = Pattern.compile(".{22}");
                    this.STARTDATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.ENDDATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOMDATASOURCEID_PATTERN.matcher(string3).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.startDate = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter startDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.STARTDATE_PATTERN.matcher(string4).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.endDate = (String)Preconditions.checkNotNull((Object)string5, (Object)"Required parameter endDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ENDDATE_PATTERN.matcher(string5).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public List setCustomDataSourceId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOMDATASOURCEID_PATTERN.matcher(string).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.customDataSourceId = string;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public List setStartDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.STARTDATE_PATTERN.matcher(string).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.startDate = string;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public List setEndDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ENDDATE_PATTERN.matcher(string).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.endDate = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/dailyUploads/{date}";
                private final Pattern ACCOUNTID_PATTERN;
                private final Pattern WEBPROPERTYID_PATTERN;
                private final Pattern DATE_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;
                @Key
                private String date;
                @Key
                private String type;

                protected Delete(String string, String string2, String string3, String string4, String string5) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.ACCOUNTID_PATTERN = Pattern.compile("[0-9]+");
                    this.WEBPROPERTYID_PATTERN = Pattern.compile("UA-[0-9]+-[0-9]+");
                    this.DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                    this.date = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter date must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DATE_PATTERN.matcher(string4).matches(), (Object)"Parameter date must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.type = (String)Preconditions.checkNotNull((Object)string5, (Object)"Required parameter type must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public Delete setCustomDataSourceId(String string) {
                    this.customDataSourceId = string;
                    return this;
                }

                public String getDate() {
                    return this.date;
                }

                public Delete setDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DATE_PATTERN.matcher(string).matches(), (Object)"Parameter date must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.date = string;
                    return this;
                }

                public String getType() {
                    return this.type;
                }

                public Delete setType(String string) {
                    this.type = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class CustomDataSources {
            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDataSources> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources";
                private final Pattern ACCOUNTID_PATTERN;
                private final Pattern WEBPROPERTYID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDataSources.class);
                    this.ACCOUNTID_PATTERN = Pattern.compile("\\d+");
                    this.WEBPROPERTYID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNTID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEBPROPERTYID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Accounts {
            public List list() throws IOException {
                List list = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Accounts> {
                private static final String REST_PATH = "management/accounts";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Accounts.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }
    }

    public class Data {
        public Ga ga() {
            return new Ga();
        }

        public Mcf mcf() {
            return new Mcf();
        }

        public class Mcf {
            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<McfData> {
                private static final String REST_PATH = "data/mcf";
                private final Pattern IDS_PATTERN;
                private final Pattern STARTDATE_PATTERN;
                private final Pattern ENDDATE_PATTERN;
                private final Pattern METRICS_PATTERN;
                private final Pattern SORT_PATTERN;
                private final Pattern DIMENSIONS_PATTERN;
                private final Pattern FILTERS_PATTERN;
                @Key
                private String ids;
                @Key(value="start-date")
                private String startDate;
                @Key(value="end-date")
                private String endDate;
                @Key
                private String metrics;
                @Key(value="max-results")
                private Integer maxResults;
                @Key
                private String sort;
                @Key
                private String dimensions;
                @Key(value="start-index")
                private Integer startIndex;
                @Key
                private String filters;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, McfData.class);
                    this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                    this.STARTDATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.ENDDATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.METRICS_PATTERN = Pattern.compile("mcf:.+");
                    this.SORT_PATTERN = Pattern.compile("(-)?mcf:.+");
                    this.DIMENSIONS_PATTERN = Pattern.compile("(mcf:.+)?");
                    this.FILTERS_PATTERN = Pattern.compile("mcf:.+");
                    this.ids = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter ids must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.startDate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter startDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.STARTDATE_PATTERN.matcher(string2).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.endDate = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter endDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ENDDATE_PATTERN.matcher(string3).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.metrics = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter metrics must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string4).matches(), (Object)"Parameter metrics must conform to the pattern mcf:.+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getIds() {
                    return this.ids;
                }

                public Get setIds(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.ids = string;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public Get setStartDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.STARTDATE_PATTERN.matcher(string).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.startDate = string;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public Get setEndDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ENDDATE_PATTERN.matcher(string).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.endDate = string;
                    return this;
                }

                public String getMetrics() {
                    return this.metrics;
                }

                public Get setMetrics(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string).matches(), (Object)"Parameter metrics must conform to the pattern mcf:.+");
                    }
                    this.metrics = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public Get setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getSort() {
                    return this.sort;
                }

                public Get setSort(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(string).matches(), (Object)"Parameter sort must conform to the pattern (-)?mcf:.+");
                    }
                    this.sort = string;
                    return this;
                }

                public String getDimensions() {
                    return this.dimensions;
                }

                public Get setDimensions(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(string).matches(), (Object)"Parameter dimensions must conform to the pattern (mcf:.+)?");
                    }
                    this.dimensions = string;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public Get setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                public String getFilters() {
                    return this.filters;
                }

                public Get setFilters(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern mcf:.+");
                    }
                    this.filters = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Ga {
            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<GaData> {
                private static final String REST_PATH = "data/ga";
                private final Pattern IDS_PATTERN;
                private final Pattern STARTDATE_PATTERN;
                private final Pattern ENDDATE_PATTERN;
                private final Pattern METRICS_PATTERN;
                private final Pattern SORT_PATTERN;
                private final Pattern DIMENSIONS_PATTERN;
                private final Pattern FILTERS_PATTERN;
                @Key
                private String ids;
                @Key(value="start-date")
                private String startDate;
                @Key(value="end-date")
                private String endDate;
                @Key
                private String metrics;
                @Key(value="max-results")
                private Integer maxResults;
                @Key
                private String sort;
                @Key
                private String dimensions;
                @Key(value="start-index")
                private Integer startIndex;
                @Key
                private String segment;
                @Key
                private String filters;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, GaData.class);
                    this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                    this.STARTDATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.ENDDATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                    this.METRICS_PATTERN = Pattern.compile("ga:.+");
                    this.SORT_PATTERN = Pattern.compile("(-)?ga:.+");
                    this.DIMENSIONS_PATTERN = Pattern.compile("(ga:.+)?");
                    this.FILTERS_PATTERN = Pattern.compile("ga:.+");
                    this.ids = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter ids must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.startDate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter startDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.STARTDATE_PATTERN.matcher(string2).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.endDate = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter endDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ENDDATE_PATTERN.matcher(string3).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.metrics = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter metrics must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string4).matches(), (Object)"Parameter metrics must conform to the pattern ga:.+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getIds() {
                    return this.ids;
                }

                public Get setIds(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.ids = string;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public Get setStartDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.STARTDATE_PATTERN.matcher(string).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.startDate = string;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public Get setEndDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ENDDATE_PATTERN.matcher(string).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                    }
                    this.endDate = string;
                    return this;
                }

                public String getMetrics() {
                    return this.metrics;
                }

                public Get setMetrics(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string).matches(), (Object)"Parameter metrics must conform to the pattern ga:.+");
                    }
                    this.metrics = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public Get setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getSort() {
                    return this.sort;
                }

                public Get setSort(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(string).matches(), (Object)"Parameter sort must conform to the pattern (-)?ga:.+");
                    }
                    this.sort = string;
                    return this;
                }

                public String getDimensions() {
                    return this.dimensions;
                }

                public Get setDimensions(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(string).matches(), (Object)"Parameter dimensions must conform to the pattern (ga:.+)?");
                    }
                    this.dimensions = string;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public Get setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                public String getSegment() {
                    return this.segment;
                }

                public Get setSegment(String string) {
                    this.segment = string;
                    return this;
                }

                public String getFilters() {
                    return this.filters;
                }

                public Get setFilters(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern ga:.+");
                    }
                    this.filters = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }
    }
}

