/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.analytics;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.analytics.AnalyticsRequest;
import com.google.api.services.analytics.AnalyticsRequestInitializer;
import com.google.api.services.analytics.model.AccountSummaries;
import com.google.api.services.analytics.model.AccountTicket;
import com.google.api.services.analytics.model.Accounts;
import com.google.api.services.analytics.model.AnalyticsDataimportDeleteUploadDataRequest;
import com.google.api.services.analytics.model.Columns;
import com.google.api.services.analytics.model.CustomDataSources;
import com.google.api.services.analytics.model.CustomDimension;
import com.google.api.services.analytics.model.CustomDimensions;
import com.google.api.services.analytics.model.CustomMetric;
import com.google.api.services.analytics.model.CustomMetrics;
import com.google.api.services.analytics.model.EntityAdWordsLink;
import com.google.api.services.analytics.model.EntityAdWordsLinks;
import com.google.api.services.analytics.model.EntityUserLink;
import com.google.api.services.analytics.model.EntityUserLinks;
import com.google.api.services.analytics.model.Experiment;
import com.google.api.services.analytics.model.Experiments;
import com.google.api.services.analytics.model.Filter;
import com.google.api.services.analytics.model.Filters;
import com.google.api.services.analytics.model.GaData;
import com.google.api.services.analytics.model.Goal;
import com.google.api.services.analytics.model.Goals;
import com.google.api.services.analytics.model.McfData;
import com.google.api.services.analytics.model.Profile;
import com.google.api.services.analytics.model.ProfileFilterLink;
import com.google.api.services.analytics.model.ProfileFilterLinks;
import com.google.api.services.analytics.model.Profiles;
import com.google.api.services.analytics.model.RealtimeData;
import com.google.api.services.analytics.model.RemarketingAudience;
import com.google.api.services.analytics.model.RemarketingAudiences;
import com.google.api.services.analytics.model.Segments;
import com.google.api.services.analytics.model.UnsampledReport;
import com.google.api.services.analytics.model.UnsampledReports;
import com.google.api.services.analytics.model.Upload;
import com.google.api.services.analytics.model.Uploads;
import com.google.api.services.analytics.model.Webproperties;
import com.google.api.services.analytics.model.Webproperty;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analytics
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "analytics/v3/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/analytics/v3/";

    public Analytics(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Analytics(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Data data() {
        return new Data();
    }

    public Management management() {
        return new Management();
    }

    public Metadata metadata() {
        return new Metadata();
    }

    public Provisioning provisioning() {
        return new Provisioning();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Google Analytics API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Analytics.DEFAULT_ROOT_URL, Analytics.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Analytics build() {
            return new Analytics(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setAnalyticsRequestInitializer(AnalyticsRequestInitializer analyticsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)analyticsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Provisioning {
        public CreateAccountTicket createAccountTicket(AccountTicket accountTicket) throws IOException {
            CreateAccountTicket createAccountTicket = new CreateAccountTicket(accountTicket);
            Analytics.this.initialize((AbstractGoogleClientRequest<?>)createAccountTicket);
            return createAccountTicket;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CreateAccountTicket
        extends AnalyticsRequest<AccountTicket> {
            private static final String REST_PATH = "provisioning/createAccountTicket";

            protected CreateAccountTicket(AccountTicket accountTicket) {
                super(Analytics.this, "POST", REST_PATH, (Object)accountTicket, AccountTicket.class);
            }

            public CreateAccountTicket setAlt(String string) {
                return (CreateAccountTicket)super.setAlt(string);
            }

            public CreateAccountTicket setFields(String string) {
                return (CreateAccountTicket)super.setFields(string);
            }

            public CreateAccountTicket setKey(String string) {
                return (CreateAccountTicket)super.setKey(string);
            }

            public CreateAccountTicket setOauthToken(String string) {
                return (CreateAccountTicket)super.setOauthToken(string);
            }

            public CreateAccountTicket setPrettyPrint(Boolean bl) {
                return (CreateAccountTicket)super.setPrettyPrint(bl);
            }

            public CreateAccountTicket setQuotaUser(String string) {
                return (CreateAccountTicket)super.setQuotaUser(string);
            }

            public CreateAccountTicket setUserIp(String string) {
                return (CreateAccountTicket)super.setUserIp(string);
            }

            @Override
            public CreateAccountTicket set(String string, Object object) {
                return (CreateAccountTicket)super.set(string, object);
            }
        }
    }

    public class Metadata {
        public Columns columns() {
            return new Columns();
        }

        public class Columns {
            public List list(String string) throws IOException {
                List list = new List(string);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Columns> {
                private static final String REST_PATH = "metadata/{reportType}/columns";
                private final Pattern REPORT_TYPE_PATTERN;
                @Key
                private String reportType;

                protected List(String string) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Columns.class);
                    this.REPORT_TYPE_PATTERN = Pattern.compile("ga");
                    this.reportType = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter reportType must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.REPORT_TYPE_PATTERN.matcher(string).matches(), (Object)"Parameter reportType must conform to the pattern ga");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getReportType() {
                    return this.reportType;
                }

                public List setReportType(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.REPORT_TYPE_PATTERN.matcher(string).matches(), (Object)"Parameter reportType must conform to the pattern ga");
                    }
                    this.reportType = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }
    }

    public class Management {
        public AccountSummaries accountSummaries() {
            return new AccountSummaries();
        }

        public AccountUserLinks accountUserLinks() {
            return new AccountUserLinks();
        }

        public Accounts accounts() {
            return new Accounts();
        }

        public CustomDataSources customDataSources() {
            return new CustomDataSources();
        }

        public CustomDimensions customDimensions() {
            return new CustomDimensions();
        }

        public CustomMetrics customMetrics() {
            return new CustomMetrics();
        }

        public Experiments experiments() {
            return new Experiments();
        }

        public Filters filters() {
            return new Filters();
        }

        public Goals goals() {
            return new Goals();
        }

        public ProfileFilterLinks profileFilterLinks() {
            return new ProfileFilterLinks();
        }

        public ProfileUserLinks profileUserLinks() {
            return new ProfileUserLinks();
        }

        public Profiles profiles() {
            return new Profiles();
        }

        public RemarketingAudience remarketingAudience() {
            return new RemarketingAudience();
        }

        public Segments segments() {
            return new Segments();
        }

        public UnsampledReports unsampledReports() {
            return new UnsampledReports();
        }

        public Uploads uploads() {
            return new Uploads();
        }

        public WebPropertyAdWordsLinks webPropertyAdWordsLinks() {
            return new WebPropertyAdWordsLinks();
        }

        public Webproperties webproperties() {
            return new Webproperties();
        }

        public WebpropertyUserLinks webpropertyUserLinks() {
            return new WebpropertyUserLinks();
        }

        public class WebpropertyUserLinks {
            public Delete delete(String string, String string2, String string3) throws IOException {
                Delete delete = new Delete(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Insert insert(String string, String string2, EntityUserLink entityUserLink) throws IOException {
                Insert insert = new Insert(string, string2, entityUserLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, String string2, String string3, EntityUserLink entityUserLink) throws IOException {
                Update update = new Update(string, string2, string3, entityUserLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String linkId;

                protected Update(String string, String string2, String string3, EntityUserLink entityUserLink) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)entityUserLink, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter linkId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Update setLinkId(String string) {
                    this.linkId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<EntityUserLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityUserLinks.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String string, String string2, EntityUserLink entityUserLink) {
                    super(Analytics.this, "POST", REST_PATH, (Object)entityUserLink, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String linkId;

                protected Delete(String string, String string2, String string3) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter linkId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Delete setLinkId(String string) {
                    this.linkId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Webproperties {
            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, Webproperty webproperty) throws IOException {
                Insert insert = new Insert(string, webproperty);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, Webproperty webproperty) throws IOException {
                Patch patch = new Patch(string, string2, webproperty);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, Webproperty webproperty) throws IOException {
                Update update = new Update(string, string2, webproperty);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<Webproperty> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Update(String string, String string2, Webproperty webproperty) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)webproperty, Webproperty.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<Webproperty> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Patch(String string, String string2, Webproperty webproperty) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)webproperty, Webproperty.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperties> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties";
                @Key
                private String accountId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Webproperties.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<Webproperty> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties";
                @Key
                private String accountId;

                protected Insert(String string, Webproperty webproperty) {
                    super(Analytics.this, "POST", REST_PATH, (Object)webproperty, Webproperty.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<Webproperty> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Get(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, Webproperty.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("[0-9]+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-[0-9]+-[0-9]+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class WebPropertyAdWordsLinks {
            public Delete delete(String string, String string2, String string3) throws IOException {
                Delete delete = new Delete(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, EntityAdWordsLink entityAdWordsLink) throws IOException {
                Insert insert = new Insert(string, string2, entityAdWordsLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, EntityAdWordsLink entityAdWordsLink) throws IOException {
                Patch patch = new Patch(string, string2, string3, entityAdWordsLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, EntityAdWordsLink entityAdWordsLink) throws IOException {
                Update update = new Update(string, string2, string3, entityAdWordsLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<EntityAdWordsLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String webPropertyAdWordsLinkId;

                protected Update(String string, String string2, String string3, EntityAdWordsLink entityAdWordsLink) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)entityAdWordsLink, EntityAdWordsLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.webPropertyAdWordsLinkId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter webPropertyAdWordsLinkId must be specified.");
                    this.checkRequiredParameter((Object)entityAdWordsLink, "content");
                    this.checkRequiredParameter(entityAdWordsLink.getName(), "EntityAdWordsLink.getName()");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getWebPropertyAdWordsLinkId() {
                    return this.webPropertyAdWordsLinkId;
                }

                public Update setWebPropertyAdWordsLinkId(String string) {
                    this.webPropertyAdWordsLinkId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<EntityAdWordsLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String webPropertyAdWordsLinkId;

                protected Patch(String string, String string2, String string3, EntityAdWordsLink entityAdWordsLink) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)entityAdWordsLink, EntityAdWordsLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.webPropertyAdWordsLinkId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter webPropertyAdWordsLinkId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getWebPropertyAdWordsLinkId() {
                    return this.webPropertyAdWordsLinkId;
                }

                public Patch setWebPropertyAdWordsLinkId(String string) {
                    this.webPropertyAdWordsLinkId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<EntityAdWordsLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks";
                private final Pattern ACCOUNT_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityAdWordsLinks.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<EntityAdWordsLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String string, String string2, EntityAdWordsLink entityAdWordsLink) {
                    super(Analytics.this, "POST", REST_PATH, (Object)entityAdWordsLink, EntityAdWordsLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.checkRequiredParameter((Object)entityAdWordsLink, "content");
                    this.checkRequiredParameter(entityAdWordsLink.getName(), "EntityAdWordsLink.getName()");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<EntityAdWordsLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String webPropertyAdWordsLinkId;

                protected Get(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityAdWordsLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.webPropertyAdWordsLinkId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter webPropertyAdWordsLinkId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getWebPropertyAdWordsLinkId() {
                    return this.webPropertyAdWordsLinkId;
                }

                public Get setWebPropertyAdWordsLinkId(String string) {
                    this.webPropertyAdWordsLinkId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String webPropertyAdWordsLinkId;

                protected Delete(String string, String string2, String string3) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.webPropertyAdWordsLinkId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter webPropertyAdWordsLinkId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getWebPropertyAdWordsLinkId() {
                    return this.webPropertyAdWordsLinkId;
                }

                public Delete setWebPropertyAdWordsLinkId(String string) {
                    this.webPropertyAdWordsLinkId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Uploads {
            public DeleteUploadData deleteUploadData(String string, String string2, String string3, AnalyticsDataimportDeleteUploadDataRequest analyticsDataimportDeleteUploadDataRequest) throws IOException {
                DeleteUploadData deleteUploadData = new DeleteUploadData(string, string2, string3, analyticsDataimportDeleteUploadDataRequest);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)deleteUploadData);
                return deleteUploadData;
            }

            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public UploadData uploadData(String string, String string2, String string3) throws IOException {
                UploadData uploadData = new UploadData(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)uploadData);
                return uploadData;
            }

            public UploadData uploadData(String string, String string2, String string3, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
                UploadData uploadData = new UploadData(string, string2, string3, abstractInputStreamContent);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)uploadData);
                return uploadData;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class UploadData
            extends AnalyticsRequest<Upload> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;

                protected UploadData(String string, String string2, String string3) {
                    super(Analytics.this, "POST", REST_PATH, null, Upload.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-\\d+-\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-\\d+-\\d+");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                }

                protected UploadData(String string, String string2, String string3, AbstractInputStreamContent abstractInputStreamContent) {
                    super(Analytics.this, "POST", "/upload/" + Analytics.this.getServicePath() + REST_PATH, null, Upload.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-\\d+-\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                    this.initializeMediaUpload(abstractInputStreamContent);
                }

                public UploadData setAlt(String string) {
                    return (UploadData)super.setAlt(string);
                }

                public UploadData setFields(String string) {
                    return (UploadData)super.setFields(string);
                }

                public UploadData setKey(String string) {
                    return (UploadData)super.setKey(string);
                }

                public UploadData setOauthToken(String string) {
                    return (UploadData)super.setOauthToken(string);
                }

                public UploadData setPrettyPrint(Boolean bl) {
                    return (UploadData)super.setPrettyPrint(bl);
                }

                public UploadData setQuotaUser(String string) {
                    return (UploadData)super.setQuotaUser(string);
                }

                public UploadData setUserIp(String string) {
                    return (UploadData)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public UploadData setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public UploadData setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-\\d+-\\d+");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public UploadData setCustomDataSourceId(String string) {
                    this.customDataSourceId = string;
                    return this;
                }

                @Override
                public UploadData set(String string, Object object) {
                    return (UploadData)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Uploads> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern CUSTOM_DATA_SOURCE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Uploads.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.CUSTOM_DATA_SOURCE_ID_PATTERN = Pattern.compile(".{22}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public List setCustomDataSourceId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.customDataSourceId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<Upload> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads/{uploadId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern CUSTOM_DATA_SOURCE_ID_PATTERN;
                private final Pattern UPLOAD_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;
                @Key
                private String uploadId;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, Upload.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.CUSTOM_DATA_SOURCE_ID_PATTERN = Pattern.compile(".{22}");
                    this.UPLOAD_ID_PATTERN = Pattern.compile(".{22}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.uploadId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter uploadId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.UPLOAD_ID_PATTERN.matcher(string4).matches(), (Object)"Parameter uploadId must conform to the pattern .{22}");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public Get setCustomDataSourceId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.customDataSourceId = string;
                    return this;
                }

                public String getUploadId() {
                    return this.uploadId;
                }

                public Get setUploadId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.UPLOAD_ID_PATTERN.matcher(string).matches(), (Object)"Parameter uploadId must conform to the pattern .{22}");
                    }
                    this.uploadId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class DeleteUploadData
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/deleteUploadData";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern CUSTOM_DATA_SOURCE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;

                protected DeleteUploadData(String string, String string2, String string3, AnalyticsDataimportDeleteUploadDataRequest analyticsDataimportDeleteUploadDataRequest) {
                    super(Analytics.this, "POST", REST_PATH, (Object)analyticsDataimportDeleteUploadDataRequest, Void.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.CUSTOM_DATA_SOURCE_ID_PATTERN = Pattern.compile(".{22}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDataSourceId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                }

                public DeleteUploadData setAlt(String string) {
                    return (DeleteUploadData)super.setAlt(string);
                }

                public DeleteUploadData setFields(String string) {
                    return (DeleteUploadData)super.setFields(string);
                }

                public DeleteUploadData setKey(String string) {
                    return (DeleteUploadData)super.setKey(string);
                }

                public DeleteUploadData setOauthToken(String string) {
                    return (DeleteUploadData)super.setOauthToken(string);
                }

                public DeleteUploadData setPrettyPrint(Boolean bl) {
                    return (DeleteUploadData)super.setPrettyPrint(bl);
                }

                public DeleteUploadData setQuotaUser(String string) {
                    return (DeleteUploadData)super.setQuotaUser(string);
                }

                public DeleteUploadData setUserIp(String string) {
                    return (DeleteUploadData)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public DeleteUploadData setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public DeleteUploadData setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public DeleteUploadData setCustomDataSourceId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.customDataSourceId = string;
                    return this;
                }

                @Override
                public DeleteUploadData set(String string, Object object) {
                    return (DeleteUploadData)super.set(string, object);
                }
            }
        }

        public class UnsampledReports {
            public Delete delete(String string, String string2, String string3, String string4) throws IOException {
                Delete delete = new Delete(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, String string3, UnsampledReport unsampledReport) throws IOException {
                Insert insert = new Insert(string, string2, string3, unsampledReport);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.UnsampledReports> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.UnsampledReports.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<UnsampledReport> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String string, String string2, String string3, UnsampledReport unsampledReport) {
                    super(Analytics.this, "POST", REST_PATH, (Object)unsampledReport, UnsampledReport.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.checkRequiredParameter((Object)unsampledReport, "content");
                    this.checkRequiredParameter(unsampledReport.getEndDate(), "UnsampledReport.getEndDate()");
                    this.checkRequiredParameter((Object)unsampledReport, "content");
                    this.checkRequiredParameter(unsampledReport.getMetrics(), "UnsampledReport.getMetrics()");
                    this.checkRequiredParameter((Object)unsampledReport, "content");
                    this.checkRequiredParameter(unsampledReport.getStartDate(), "UnsampledReport.getStartDate()");
                    this.checkRequiredParameter((Object)unsampledReport, "content");
                    this.checkRequiredParameter(unsampledReport.getTitle(), "UnsampledReport.getTitle()");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<UnsampledReport> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports/{unsampledReportId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String unsampledReportId;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, UnsampledReport.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.unsampledReportId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter unsampledReportId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getUnsampledReportId() {
                    return this.unsampledReportId;
                }

                public Get setUnsampledReportId(String string) {
                    this.unsampledReportId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports/{unsampledReportId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String unsampledReportId;

                protected Delete(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.unsampledReportId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter unsampledReportId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getUnsampledReportId() {
                    return this.unsampledReportId;
                }

                public Delete setUnsampledReportId(String string) {
                    this.unsampledReportId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Segments {
            public List list() throws IOException {
                List list = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Segments> {
                private static final String REST_PATH = "management/segments";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Segments.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class RemarketingAudience {
            public Delete delete(String string, String string2, String string3) throws IOException {
                Delete delete = new Delete(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, com.google.api.services.analytics.model.RemarketingAudience remarketingAudience) throws IOException {
                Insert insert = new Insert(string, string2, remarketingAudience);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, com.google.api.services.analytics.model.RemarketingAudience remarketingAudience) throws IOException {
                Patch patch = new Patch(string, string2, string3, remarketingAudience);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, com.google.api.services.analytics.model.RemarketingAudience remarketingAudience) throws IOException {
                Update update = new Update(string, string2, string3, remarketingAudience);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<com.google.api.services.analytics.model.RemarketingAudience> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String remarketingAudienceId;

                protected Update(String string, String string2, String string3, com.google.api.services.analytics.model.RemarketingAudience remarketingAudience2) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)remarketingAudience2, com.google.api.services.analytics.model.RemarketingAudience.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.remarketingAudienceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter remarketingAudienceId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getRemarketingAudienceId() {
                    return this.remarketingAudienceId;
                }

                public Update setRemarketingAudienceId(String string) {
                    this.remarketingAudienceId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<com.google.api.services.analytics.model.RemarketingAudience> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String remarketingAudienceId;

                protected Patch(String string, String string2, String string3, com.google.api.services.analytics.model.RemarketingAudience remarketingAudience2) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)remarketingAudience2, com.google.api.services.analytics.model.RemarketingAudience.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.remarketingAudienceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter remarketingAudienceId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getRemarketingAudienceId() {
                    return this.remarketingAudienceId;
                }

                public Patch setRemarketingAudienceId(String string) {
                    this.remarketingAudienceId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<RemarketingAudiences> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;
                @Key
                private String type;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, RemarketingAudiences.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                public String getType() {
                    return this.type;
                }

                public List setType(String string) {
                    this.type = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<com.google.api.services.analytics.model.RemarketingAudience> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String string, String string2, com.google.api.services.analytics.model.RemarketingAudience remarketingAudience2) {
                    super(Analytics.this, "POST", REST_PATH, (Object)remarketingAudience2, com.google.api.services.analytics.model.RemarketingAudience.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<com.google.api.services.analytics.model.RemarketingAudience> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String remarketingAudienceId;

                protected Get(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.RemarketingAudience.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.remarketingAudienceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter remarketingAudienceId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getRemarketingAudienceId() {
                    return this.remarketingAudienceId;
                }

                public Get setRemarketingAudienceId(String string) {
                    this.remarketingAudienceId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String remarketingAudienceId;

                protected Delete(String string, String string2, String string3) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.remarketingAudienceId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter remarketingAudienceId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getRemarketingAudienceId() {
                    return this.remarketingAudienceId;
                }

                public Delete setRemarketingAudienceId(String string) {
                    this.remarketingAudienceId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Profiles {
            public Delete delete(String string, String string2, String string3) throws IOException {
                Delete delete = new Delete(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, Profile profile) throws IOException {
                Insert insert = new Insert(string, string2, profile);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, Profile profile) throws IOException {
                Patch patch = new Patch(string, string2, string3, profile);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, Profile profile) throws IOException {
                Update update = new Update(string, string2, string3, profile);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<Profile> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Update(String string, String string2, String string3, Profile profile) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)profile, Profile.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<Profile> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Patch(String string, String string2, String string3, Profile profile) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)profile, Profile.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Profiles> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Profiles.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<Profile> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String string, String string2, Profile profile) {
                    super(Analytics.this, "POST", REST_PATH, (Object)profile, Profile.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<Profile> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Get(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, Profile.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("[0-9]+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-[0-9]+-[0-9]+");
                    this.PROFILE_ID_PATTERN = Pattern.compile("[0-9]+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter profileId must conform to the pattern [0-9]+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter profileId must conform to the pattern [0-9]+");
                    }
                    this.profileId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Delete(String string, String string2, String string3) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class ProfileUserLinks {
            public Delete delete(String string, String string2, String string3, String string4) throws IOException {
                Delete delete = new Delete(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Insert insert(String string, String string2, String string3, EntityUserLink entityUserLink) throws IOException {
                Insert insert = new Insert(string, string2, string3, entityUserLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, String string2, String string3, String string4, EntityUserLink entityUserLink) throws IOException {
                Update update = new Update(string, string2, string3, string4, entityUserLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Update(String string, String string2, String string3, String string4, EntityUserLink entityUserLink) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)entityUserLink, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter linkId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Update setLinkId(String string) {
                    this.linkId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<EntityUserLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityUserLinks.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String string, String string2, String string3, EntityUserLink entityUserLink) {
                    super(Analytics.this, "POST", REST_PATH, (Object)entityUserLink, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Delete(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter linkId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Delete setLinkId(String string) {
                    this.linkId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class ProfileFilterLinks {
            public Delete delete(String string, String string2, String string3, String string4) throws IOException {
                Delete delete = new Delete(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, String string3, ProfileFilterLink profileFilterLink) throws IOException {
                Insert insert = new Insert(string, string2, string3, profileFilterLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, String string4, ProfileFilterLink profileFilterLink) throws IOException {
                Patch patch = new Patch(string, string2, string3, string4, profileFilterLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, String string4, ProfileFilterLink profileFilterLink) throws IOException {
                Update update = new Update(string, string2, string3, string4, profileFilterLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<ProfileFilterLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                private final Pattern LINK_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Update(String string, String string2, String string3, String string4, ProfileFilterLink profileFilterLink) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)profileFilterLink, ProfileFilterLink.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.LINK_ID_PATTERN = Pattern.compile("\\d+:\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.linkId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter linkId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(string4).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Update setLinkId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(string).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                    this.linkId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<ProfileFilterLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                private final Pattern LINK_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Patch(String string, String string2, String string3, String string4, ProfileFilterLink profileFilterLink) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)profileFilterLink, ProfileFilterLink.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.LINK_ID_PATTERN = Pattern.compile("\\d+:\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.linkId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter linkId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(string4).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Patch setLinkId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(string).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                    this.linkId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.ProfileFilterLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks";
                private final Pattern ACCOUNT_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.ProfileFilterLinks.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<ProfileFilterLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String string, String string2, String string3, ProfileFilterLink profileFilterLink) {
                    super(Analytics.this, "POST", REST_PATH, (Object)profileFilterLink, ProfileFilterLink.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<ProfileFilterLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                private final Pattern LINK_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, ProfileFilterLink.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.LINK_ID_PATTERN = Pattern.compile("\\d+:\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.linkId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter linkId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(string4).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Get setLinkId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(string).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                    this.linkId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                private final Pattern LINK_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Delete(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.LINK_ID_PATTERN = Pattern.compile("\\d+:\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.linkId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter linkId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(string4).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Delete setLinkId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(string).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                    this.linkId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Goals {
            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, String string3, Goal goal) throws IOException {
                Insert insert = new Insert(string, string2, string3, goal);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, String string4, Goal goal) throws IOException {
                Patch patch = new Patch(string, string2, string3, string4, goal);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, String string4, Goal goal) throws IOException {
                Update update = new Update(string, string2, string3, string4, goal);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<Goal> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String goalId;

                protected Update(String string, String string2, String string3, String string4, Goal goal) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)goal, Goal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.goalId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter goalId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getGoalId() {
                    return this.goalId;
                }

                public Update setGoalId(String string) {
                    this.goalId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<Goal> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String goalId;

                protected Patch(String string, String string2, String string3, String string4, Goal goal) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)goal, Goal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.goalId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter goalId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getGoalId() {
                    return this.goalId;
                }

                public Patch setGoalId(String string) {
                    this.goalId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Goals> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Goals.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<Goal> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String string, String string2, String string3, Goal goal) {
                    super(Analytics.this, "POST", REST_PATH, (Object)goal, Goal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<Goal> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String goalId;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, Goal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.goalId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter goalId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getGoalId() {
                    return this.goalId;
                }

                public Get setGoalId(String string) {
                    this.goalId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Filters {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, Filter filter) throws IOException {
                Insert insert = new Insert(string, filter);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, Filter filter) throws IOException {
                Patch patch = new Patch(string, string2, filter);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, Filter filter) throws IOException {
                Update update = new Update(string, string2, filter);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";
                @Key
                private String accountId;
                @Key
                private String filterId;

                protected Update(String string, String string2, Filter filter) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)filter, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.filterId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filterId must be specified.");
                    this.checkRequiredParameter((Object)filter, "content");
                    this.checkRequiredParameter(filter.getName(), "Filter.getName()");
                    this.checkRequiredParameter((Object)filter, "content");
                    this.checkRequiredParameter(filter.getType(), "Filter.getType()");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getFilterId() {
                    return this.filterId;
                }

                public Update setFilterId(String string) {
                    this.filterId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";
                @Key
                private String accountId;
                @Key
                private String filterId;

                protected Patch(String string, String string2, Filter filter) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)filter, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.filterId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filterId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getFilterId() {
                    return this.filterId;
                }

                public Patch setFilterId(String string) {
                    this.filterId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Filters> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters";
                private final Pattern ACCOUNT_ID_PATTERN;
                @Key
                private String accountId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Filters.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters";
                @Key
                private String accountId;

                protected Insert(String string, Filter filter) {
                    super(Analytics.this, "POST", REST_PATH, (Object)filter, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.checkRequiredParameter((Object)filter, "content");
                    this.checkRequiredParameter(filter.getName(), "Filter.getName()");
                    this.checkRequiredParameter((Object)filter, "content");
                    this.checkRequiredParameter(filter.getType(), "Filter.getType()");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";
                @Key
                private String accountId;
                @Key
                private String filterId;

                protected Get(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.filterId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filterId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getFilterId() {
                    return this.filterId;
                }

                public Get setFilterId(String string) {
                    this.filterId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";
                @Key
                private String accountId;
                @Key
                private String filterId;

                protected Delete(String string, String string2) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.filterId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter filterId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getFilterId() {
                    return this.filterId;
                }

                public Delete setFilterId(String string) {
                    this.filterId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Experiments {
            public Delete delete(String string, String string2, String string3, String string4) throws IOException {
                Delete delete = new Delete(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, String string3, Experiment experiment) throws IOException {
                Insert insert = new Insert(string, string2, string3, experiment);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, String string4, Experiment experiment) throws IOException {
                Patch patch = new Patch(string, string2, string3, string4, experiment);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, String string4, Experiment experiment) throws IOException {
                Update update = new Update(string, string2, string3, string4, experiment);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Update(String string, String string2, String string3, String string4, Experiment experiment) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)experiment, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter experimentId must be specified.");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getId(), "Experiment.getId()");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getName(), "Experiment.getName()");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getStatus(), "Experiment.getStatus()");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Update setExperimentId(String string) {
                    this.experimentId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Patch(String string, String string2, String string3, String string4, Experiment experiment) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)experiment, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter experimentId must be specified.");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getId(), "Experiment.getId()");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Patch setExperimentId(String string) {
                    this.experimentId = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Experiments> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiments.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string3).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(string).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String string, String string2, String string3, Experiment experiment) {
                    super(Analytics.this, "POST", REST_PATH, (Object)experiment, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getName(), "Experiment.getName()");
                    this.checkRequiredParameter((Object)experiment, "content");
                    this.checkRequiredParameter(experiment.getStatus(), "Experiment.getStatus()");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter experimentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Get setExperimentId(String string) {
                    this.experimentId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Delete(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter experimentId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Delete setExperimentId(String string) {
                    this.experimentId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class CustomMetrics {
            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, CustomMetric customMetric) throws IOException {
                Insert insert = new Insert(string, string2, customMetric);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, CustomMetric customMetric) throws IOException {
                Patch patch = new Patch(string, string2, string3, customMetric);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, CustomMetric customMetric) throws IOException {
                Update update = new Update(string, string2, string3, customMetric);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<CustomMetric> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customMetricId;
                @Key
                private Boolean ignoreCustomDataSourceLinks;

                protected Update(String string, String string2, String string3, CustomMetric customMetric) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)customMetric, CustomMetric.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.customMetricId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customMetricId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomMetricId() {
                    return this.customMetricId;
                }

                public Update setCustomMetricId(String string) {
                    this.customMetricId = string;
                    return this;
                }

                public Boolean getIgnoreCustomDataSourceLinks() {
                    return this.ignoreCustomDataSourceLinks;
                }

                public Update setIgnoreCustomDataSourceLinks(Boolean bl) {
                    this.ignoreCustomDataSourceLinks = bl;
                    return this;
                }

                public boolean isIgnoreCustomDataSourceLinks() {
                    if (this.ignoreCustomDataSourceLinks == null || this.ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.ignoreCustomDataSourceLinks;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<CustomMetric> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customMetricId;
                @Key
                private Boolean ignoreCustomDataSourceLinks;

                protected Patch(String string, String string2, String string3, CustomMetric customMetric) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)customMetric, CustomMetric.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.customMetricId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customMetricId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomMetricId() {
                    return this.customMetricId;
                }

                public Patch setCustomMetricId(String string) {
                    this.customMetricId = string;
                    return this;
                }

                public Boolean getIgnoreCustomDataSourceLinks() {
                    return this.ignoreCustomDataSourceLinks;
                }

                public Patch setIgnoreCustomDataSourceLinks(Boolean bl) {
                    this.ignoreCustomDataSourceLinks = bl;
                    return this;
                }

                public boolean isIgnoreCustomDataSourceLinks() {
                    if (this.ignoreCustomDataSourceLinks == null || this.ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.ignoreCustomDataSourceLinks;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.CustomMetrics> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomMetrics.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<CustomMetric> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String string, String string2, CustomMetric customMetric) {
                    super(Analytics.this, "POST", REST_PATH, (Object)customMetric, CustomMetric.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<CustomMetric> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customMetricId;

                protected Get(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, CustomMetric.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.customMetricId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customMetricId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomMetricId() {
                    return this.customMetricId;
                }

                public Get setCustomMetricId(String string) {
                    this.customMetricId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class CustomDimensions {
            public Get get(String string, String string2, String string3) throws IOException {
                Get get = new Get(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Insert insert(String string, String string2, CustomDimension customDimension) throws IOException {
                Insert insert = new Insert(string, string2, customDimension);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, String string2, String string3, CustomDimension customDimension) throws IOException {
                Patch patch = new Patch(string, string2, string3, customDimension);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, String string2, String string3, CustomDimension customDimension) throws IOException {
                Update update = new Update(string, string2, string3, customDimension);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<CustomDimension> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDimensionId;
                @Key
                private Boolean ignoreCustomDataSourceLinks;

                protected Update(String string, String string2, String string3, CustomDimension customDimension) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)customDimension, CustomDimension.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDimensionId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDimensionId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDimensionId() {
                    return this.customDimensionId;
                }

                public Update setCustomDimensionId(String string) {
                    this.customDimensionId = string;
                    return this;
                }

                public Boolean getIgnoreCustomDataSourceLinks() {
                    return this.ignoreCustomDataSourceLinks;
                }

                public Update setIgnoreCustomDataSourceLinks(Boolean bl) {
                    this.ignoreCustomDataSourceLinks = bl;
                    return this;
                }

                public boolean isIgnoreCustomDataSourceLinks() {
                    if (this.ignoreCustomDataSourceLinks == null || this.ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.ignoreCustomDataSourceLinks;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends AnalyticsRequest<CustomDimension> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDimensionId;
                @Key
                private Boolean ignoreCustomDataSourceLinks;

                protected Patch(String string, String string2, String string3, CustomDimension customDimension) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)customDimension, CustomDimension.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDimensionId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDimensionId must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDimensionId() {
                    return this.customDimensionId;
                }

                public Patch setCustomDimensionId(String string) {
                    this.customDimensionId = string;
                    return this;
                }

                public Boolean getIgnoreCustomDataSourceLinks() {
                    return this.ignoreCustomDataSourceLinks;
                }

                public Patch setIgnoreCustomDataSourceLinks(Boolean bl) {
                    this.ignoreCustomDataSourceLinks = bl;
                    return this;
                }

                public boolean isIgnoreCustomDataSourceLinks() {
                    if (this.ignoreCustomDataSourceLinks == null || this.ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.ignoreCustomDataSourceLinks;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDimensions> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDimensions.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<CustomDimension> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String string, String string2, CustomDimension customDimension) {
                    super(Analytics.this, "POST", REST_PATH, (Object)customDimension, CustomDimension.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<CustomDimension> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDimensionId;

                protected Get(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, CustomDimension.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDimensionId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter customDimensionId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getCustomDimensionId() {
                    return this.customDimensionId;
                }

                public Get setCustomDimensionId(String string) {
                    this.customDimensionId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class CustomDataSources {
            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDataSources> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDataSources.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string2).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(string).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(string).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class Accounts {
            public List list() throws IOException {
                List list = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Accounts> {
                private static final String REST_PATH = "management/accounts";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Accounts.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        public class AccountUserLinks {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Insert insert(String string, EntityUserLink entityUserLink) throws IOException {
                Insert insert = new Insert(string, entityUserLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, String string2, EntityUserLink entityUserLink) throws IOException {
                Update update = new Update(string, string2, entityUserLink);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String linkId;

                protected Update(String string, String string2, EntityUserLink entityUserLink) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)entityUserLink, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter linkId must be specified.");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Update setLinkId(String string) {
                    this.linkId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<EntityUserLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks";
                @Key
                private String accountId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityUserLinks.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks";
                @Key
                private String accountId;

                protected Insert(String string, EntityUserLink entityUserLink) {
                    super(Analytics.this, "POST", REST_PATH, (Object)entityUserLink, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String linkId;

                protected Delete(String string, String string2) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter linkId must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Delete setLinkId(String string) {
                    this.linkId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class AccountSummaries {
            public List list() throws IOException {
                List list = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.AccountSummaries> {
                private static final String REST_PATH = "management/accountSummaries";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.AccountSummaries.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }
    }

    public class Data {
        public Ga ga() {
            return new Ga();
        }

        public Mcf mcf() {
            return new Mcf();
        }

        public Realtime realtime() {
            return new Realtime();
        }

        public class Realtime {
            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<RealtimeData> {
                private static final String REST_PATH = "data/realtime";
                private final Pattern IDS_PATTERN;
                private final Pattern METRICS_PATTERN;
                private final Pattern DIMENSIONS_PATTERN;
                private final Pattern FILTERS_PATTERN;
                private final Pattern SORT_PATTERN;
                @Key
                private String ids;
                @Key
                private String metrics;
                @Key
                private String dimensions;
                @Key
                private String filters;
                @Key(value="max-results")
                private Integer maxResults;
                @Key
                private String sort;

                protected Get(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, RealtimeData.class);
                    this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                    this.METRICS_PATTERN = Pattern.compile("(ga:.+)|(rt:.+)");
                    this.DIMENSIONS_PATTERN = Pattern.compile("(ga:.+)|(rt:.+)");
                    this.FILTERS_PATTERN = Pattern.compile("(ga:.+)|(rt:.+)");
                    this.SORT_PATTERN = Pattern.compile("(-)?((ga:.+)|(rt:.+))");
                    this.ids = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter ids must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.metrics = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter metrics must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string2).matches(), (Object)"Parameter metrics must conform to the pattern (ga:.+)|(rt:.+)");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getIds() {
                    return this.ids;
                }

                public Get setIds(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.ids = string;
                    return this;
                }

                public String getMetrics() {
                    return this.metrics;
                }

                public Get setMetrics(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string).matches(), (Object)"Parameter metrics must conform to the pattern (ga:.+)|(rt:.+)");
                    }
                    this.metrics = string;
                    return this;
                }

                public String getDimensions() {
                    return this.dimensions;
                }

                public Get setDimensions(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(string).matches(), (Object)"Parameter dimensions must conform to the pattern (ga:.+)|(rt:.+)");
                    }
                    this.dimensions = string;
                    return this;
                }

                public String getFilters() {
                    return this.filters;
                }

                public Get setFilters(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern (ga:.+)|(rt:.+)");
                    }
                    this.filters = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public Get setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getSort() {
                    return this.sort;
                }

                public Get setSort(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(string).matches(), (Object)"Parameter sort must conform to the pattern (-)?((ga:.+)|(rt:.+))");
                    }
                    this.sort = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Mcf {
            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<McfData> {
                private static final String REST_PATH = "data/mcf";
                private final Pattern IDS_PATTERN;
                private final Pattern START_DATE_PATTERN;
                private final Pattern END_DATE_PATTERN;
                private final Pattern METRICS_PATTERN;
                private final Pattern DIMENSIONS_PATTERN;
                private final Pattern FILTERS_PATTERN;
                private final Pattern SORT_PATTERN;
                @Key
                private String ids;
                @Key(value="start-date")
                private String startDate;
                @Key(value="end-date")
                private String endDate;
                @Key
                private String metrics;
                @Key
                private String dimensions;
                @Key
                private String filters;
                @Key(value="max-results")
                private Integer maxResults;
                @Key
                private String samplingLevel;
                @Key
                private String sort;
                @Key(value="start-index")
                private Integer startIndex;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, McfData.class);
                    this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                    this.START_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    this.END_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    this.METRICS_PATTERN = Pattern.compile("mcf:.+");
                    this.DIMENSIONS_PATTERN = Pattern.compile("(mcf:.+)?");
                    this.FILTERS_PATTERN = Pattern.compile("mcf:.+");
                    this.SORT_PATTERN = Pattern.compile("(-)?mcf:.+");
                    this.ids = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter ids must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.startDate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter startDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(string2).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.endDate = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter endDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(string3).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.metrics = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter metrics must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string4).matches(), (Object)"Parameter metrics must conform to the pattern mcf:.+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getIds() {
                    return this.ids;
                }

                public Get setIds(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.ids = string;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public Get setStartDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(string).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.startDate = string;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public Get setEndDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(string).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.endDate = string;
                    return this;
                }

                public String getMetrics() {
                    return this.metrics;
                }

                public Get setMetrics(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string).matches(), (Object)"Parameter metrics must conform to the pattern mcf:.+");
                    }
                    this.metrics = string;
                    return this;
                }

                public String getDimensions() {
                    return this.dimensions;
                }

                public Get setDimensions(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(string).matches(), (Object)"Parameter dimensions must conform to the pattern (mcf:.+)?");
                    }
                    this.dimensions = string;
                    return this;
                }

                public String getFilters() {
                    return this.filters;
                }

                public Get setFilters(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern mcf:.+");
                    }
                    this.filters = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public Get setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getSamplingLevel() {
                    return this.samplingLevel;
                }

                public Get setSamplingLevel(String string) {
                    this.samplingLevel = string;
                    return this;
                }

                public String getSort() {
                    return this.sort;
                }

                public Get setSort(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(string).matches(), (Object)"Parameter sort must conform to the pattern (-)?mcf:.+");
                    }
                    this.sort = string;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public Get setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Ga {
            public Get get(String string, String string2, String string3, String string4) throws IOException {
                Get get = new Get(string, string2, string3, string4);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends AnalyticsRequest<GaData> {
                private static final String REST_PATH = "data/ga";
                private final Pattern IDS_PATTERN;
                private final Pattern START_DATE_PATTERN;
                private final Pattern END_DATE_PATTERN;
                private final Pattern METRICS_PATTERN;
                private final Pattern DIMENSIONS_PATTERN;
                private final Pattern FILTERS_PATTERN;
                private final Pattern SORT_PATTERN;
                @Key
                private String ids;
                @Key(value="start-date")
                private String startDate;
                @Key(value="end-date")
                private String endDate;
                @Key
                private String metrics;
                @Key
                private String dimensions;
                @Key
                private String filters;
                @Key(value="include-empty-rows")
                private Boolean includeEmptyRows;
                @Key(value="max-results")
                private Integer maxResults;
                @Key
                private String output;
                @Key
                private String samplingLevel;
                @Key
                private String segment;
                @Key
                private String sort;
                @Key(value="start-index")
                private Integer startIndex;

                protected Get(String string, String string2, String string3, String string4) {
                    super(Analytics.this, "GET", REST_PATH, null, GaData.class);
                    this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                    this.START_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    this.END_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    this.METRICS_PATTERN = Pattern.compile("ga:.+");
                    this.DIMENSIONS_PATTERN = Pattern.compile("(ga:.+)?");
                    this.FILTERS_PATTERN = Pattern.compile("ga:.+");
                    this.SORT_PATTERN = Pattern.compile("(-)?ga:.+");
                    this.ids = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter ids must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.startDate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter startDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(string2).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.endDate = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter endDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(string3).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.metrics = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter metrics must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string4).matches(), (Object)"Parameter metrics must conform to the pattern ga:.+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getIds() {
                    return this.ids;
                }

                public Get setIds(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.ids = string;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public Get setStartDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(string).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.startDate = string;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public Get setEndDate(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(string).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.endDate = string;
                    return this;
                }

                public String getMetrics() {
                    return this.metrics;
                }

                public Get setMetrics(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string).matches(), (Object)"Parameter metrics must conform to the pattern ga:.+");
                    }
                    this.metrics = string;
                    return this;
                }

                public String getDimensions() {
                    return this.dimensions;
                }

                public Get setDimensions(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(string).matches(), (Object)"Parameter dimensions must conform to the pattern (ga:.+)?");
                    }
                    this.dimensions = string;
                    return this;
                }

                public String getFilters() {
                    return this.filters;
                }

                public Get setFilters(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern ga:.+");
                    }
                    this.filters = string;
                    return this;
                }

                public Boolean getIncludeEmptyRows() {
                    return this.includeEmptyRows;
                }

                public Get setIncludeEmptyRows(Boolean bl) {
                    this.includeEmptyRows = bl;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public Get setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public String getOutput() {
                    return this.output;
                }

                public Get setOutput(String string) {
                    this.output = string;
                    return this;
                }

                public String getSamplingLevel() {
                    return this.samplingLevel;
                }

                public Get setSamplingLevel(String string) {
                    this.samplingLevel = string;
                    return this;
                }

                public String getSegment() {
                    return this.segment;
                }

                public Get setSegment(String string) {
                    this.segment = string;
                    return this;
                }

                public String getSort() {
                    return this.sort;
                }

                public Get setSort(String string) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(string).matches(), (Object)"Parameter sort must conform to the pattern (-)?ga:.+");
                    }
                    this.sort = string;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public Get setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }
    }
}

