/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-05-05 at 19:05:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * An experiment collection lists Analytics experiments to which the user has access. Each view
 * (profile) can have a set of experiments. Each resource in the Experiment collection corresponds
 * to a single Analytics experiment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Experiments extends com.google.api.client.json.GenericJson {

  /**
   * A list of experiments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Experiment> items;

  static {
    // hack to force ProGuard to consider Experiment used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Experiment.class);
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer itemsPerPage;

  /**
   * Collection type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Link to next page for this experiment collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextLink;

  /**
   * Link to previous page for this experiment collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String previousLink;

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer startIndex;

  /**
   * The total number of results for the query, regardless of the number of resources in the result.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalResults;

  /**
   * Email ID of the authenticated user
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String username;

  /**
   * A list of experiments.
   * @return value or {@code null} for none
   */
  public java.util.List<Experiment> getItems() {
    return items;
  }

  /**
   * A list of experiments.
   * @param items items or {@code null} for none
   */
  public Experiments setItems(java.util.List<Experiment> items) {
    this.items = items;
    return this;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getItemsPerPage() {
    return itemsPerPage;
  }

  /**
   * The maximum number of resources the response can contain, regardless of the actual number of
   * resources returned. Its value ranges from 1 to 1000 with a value of 1000 by default, or
   * otherwise specified by the max-results query parameter.
   * @param itemsPerPage itemsPerPage or {@code null} for none
   */
  public Experiments setItemsPerPage(java.lang.Integer itemsPerPage) {
    this.itemsPerPage = itemsPerPage;
    return this;
  }

  /**
   * Collection type.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Collection type.
   * @param kind kind or {@code null} for none
   */
  public Experiments setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Link to next page for this experiment collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextLink() {
    return nextLink;
  }

  /**
   * Link to next page for this experiment collection.
   * @param nextLink nextLink or {@code null} for none
   */
  public Experiments setNextLink(java.lang.String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * Link to previous page for this experiment collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreviousLink() {
    return previousLink;
  }

  /**
   * Link to previous page for this experiment collection.
   * @param previousLink previousLink or {@code null} for none
   */
  public Experiments setPreviousLink(java.lang.String previousLink) {
    this.previousLink = previousLink;
    return this;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStartIndex() {
    return startIndex;
  }

  /**
   * The starting index of the resources, which is 1 by default or otherwise specified by the start-
   * index query parameter.
   * @param startIndex startIndex or {@code null} for none
   */
  public Experiments setStartIndex(java.lang.Integer startIndex) {
    this.startIndex = startIndex;
    return this;
  }

  /**
   * The total number of results for the query, regardless of the number of resources in the result.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalResults() {
    return totalResults;
  }

  /**
   * The total number of results for the query, regardless of the number of resources in the result.
   * @param totalResults totalResults or {@code null} for none
   */
  public Experiments setTotalResults(java.lang.Integer totalResults) {
    this.totalResults = totalResults;
    return this;
  }

  /**
   * Email ID of the authenticated user
   * @return value or {@code null} for none
   */
  public java.lang.String getUsername() {
    return username;
  }

  /**
   * Email ID of the authenticated user
   * @param username username or {@code null} for none
   */
  public Experiments setUsername(java.lang.String username) {
    this.username = username;
    return this;
  }

  @Override
  public Experiments set(String fieldName, Object value) {
    return (Experiments) super.set(fieldName, value);
  }

  @Override
  public Experiments clone() {
    return (Experiments) super.clone();
  }

}
