/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-05-05 at 19:05:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for Analytics account entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Account extends com.google.api.client.json.GenericJson {

  /**
   * Child link for an account entry. Points to the list of web properties for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChildLink childLink;

  /**
   * Time the account was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * Account ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Resource type for Analytics account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Account name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Permissions the user has for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Permissions permissions;

  /**
   * Link for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Time the account was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Child link for an account entry. Points to the list of web properties for this account.
   * @return value or {@code null} for none
   */
  public ChildLink getChildLink() {
    return childLink;
  }

  /**
   * Child link for an account entry. Points to the list of web properties for this account.
   * @param childLink childLink or {@code null} for none
   */
  public Account setChildLink(ChildLink childLink) {
    this.childLink = childLink;
    return this;
  }

  /**
   * Time the account was created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Time the account was created.
   * @param created created or {@code null} for none
   */
  public Account setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * Account ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Account ID.
   * @param id id or {@code null} for none
   */
  public Account setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type for Analytics account.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics account.
   * @param kind kind or {@code null} for none
   */
  public Account setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Account name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Account name.
   * @param name name or {@code null} for none
   */
  public Account setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Permissions the user has for this account.
   * @return value or {@code null} for none
   */
  public Permissions getPermissions() {
    return permissions;
  }

  /**
   * Permissions the user has for this account.
   * @param permissions permissions or {@code null} for none
   */
  public Account setPermissions(Permissions permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * Link for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Link for this account.
   * @param selfLink selfLink or {@code null} for none
   */
  public Account setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Time the account was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Time the account was last modified.
   * @param updated updated or {@code null} for none
   */
  public Account setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public Account set(String fieldName, Object value) {
    return (Account) super.set(fieldName, value);
  }

  @Override
  public Account clone() {
    return (Account) super.clone();
  }

  /**
   * Child link for an account entry. Points to the list of web properties for this account.
   */
  public static final class ChildLink extends com.google.api.client.json.GenericJson {

    /**
     * Link to the list of web properties for this account.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String href;

    /**
     * Type of the child link. Its value is "analytics#webproperties".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Link to the list of web properties for this account.
     * @return value or {@code null} for none
     */
    public java.lang.String getHref() {
      return href;
    }

    /**
     * Link to the list of web properties for this account.
     * @param href href or {@code null} for none
     */
    public ChildLink setHref(java.lang.String href) {
      this.href = href;
      return this;
    }

    /**
     * Type of the child link. Its value is "analytics#webproperties".
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * Type of the child link. Its value is "analytics#webproperties".
     * @param type type or {@code null} for none
     */
    public ChildLink setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    @Override
    public ChildLink set(String fieldName, Object value) {
      return (ChildLink) super.set(fieldName, value);
    }

    @Override
    public ChildLink clone() {
      return (ChildLink) super.clone();
    }

  }

  /**
   * Permissions the user has for this account.
   */
  public static final class Permissions extends com.google.api.client.json.GenericJson {

    /**
     * All the permissions that the user has for this account. These include any implied permissions
     * (e.g., EDIT implies VIEW).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<java.lang.String> effective;

    /**
     * All the permissions that the user has for this account. These include any implied permissions
     * (e.g., EDIT implies VIEW).
     * @return value or {@code null} for none
     */
    public java.util.List<java.lang.String> getEffective() {
      return effective;
    }

    /**
     * All the permissions that the user has for this account. These include any implied permissions
     * (e.g., EDIT implies VIEW).
     * @param effective effective or {@code null} for none
     */
    public Permissions setEffective(java.util.List<java.lang.String> effective) {
      this.effective = effective;
      return this;
    }

    @Override
    public Permissions set(String fieldName, Object value) {
      return (Permissions) super.set(fieldName, value);
    }

    @Override
    public Permissions clone() {
      return (Permissions) super.clone();
    }

  }

}
