/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-11-17 18:43:33 UTC)
 * on 2014-12-17 at 06:45:00 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics AccountSummary. An AccountSummary is a lightweight tree comprised
 * of properties/profiles.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountSummary extends com.google.api.client.json.GenericJson {

  /**
   * Account ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Resource type for Analytics AccountSummary.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Account name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * List of web properties under this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<WebPropertySummary> webProperties;

  static {
    // hack to force ProGuard to consider WebPropertySummary used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(WebPropertySummary.class);
  }

  /**
   * Account ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Account ID.
   * @param id id or {@code null} for none
   */
  public AccountSummary setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Resource type for Analytics AccountSummary.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Resource type for Analytics AccountSummary.
   * @param kind kind or {@code null} for none
   */
  public AccountSummary setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Account name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Account name.
   * @param name name or {@code null} for none
   */
  public AccountSummary setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * List of web properties under this account.
   * @return value or {@code null} for none
   */
  public java.util.List<WebPropertySummary> getWebProperties() {
    return webProperties;
  }

  /**
   * List of web properties under this account.
   * @param webProperties webProperties or {@code null} for none
   */
  public AccountSummary setWebProperties(java.util.List<WebPropertySummary> webProperties) {
    this.webProperties = webProperties;
    return this;
  }

  @Override
  public AccountSummary set(String fieldName, Object value) {
    return (AccountSummary) super.set(fieldName, value);
  }

  @Override
  public AccountSummary clone() {
    return (AccountSummary) super.clone();
  }

}
