/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-09 at 00:00:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.analytics.model;

/**
 * JSON template for an Analytics filter expression.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Analytics API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FilterExpression extends com.google.api.client.json.GenericJson {

  /**
   * Determines if the filter is case sensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean caseSensitive;

  /**
   * Filter expression value
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expressionValue;

  /**
   * Field to filter. Possible values: - Reserved   - UNUSED,    - Content and Traffic   -
   * PAGE_REQUEST_URI,  - PAGE_HOSTNAME,  - PAGE_TITLE,  - REFERRAL,  - COST_DATA_URI (Campaign
   * target URL),  - HIT_TYPE,  - INTERNAL_SEARCH_TERM,  - INTERNAL_SEARCH_TYPE,  -
   * SOURCE_PROPERTY_TRACKING_ID,    - Campaign or AdGroup   - CAMPAIGN_SOURCE,  - CAMPAIGN_MEDIUM,
   * - CAMPAIGN_NAME,  - CAMPAIGN_AD_GROUP,  - CAMPAIGN_TERM,  - CAMPAIGN_CONTENT,  - CAMPAIGN_CODE,
   * - CAMPAIGN_REFERRAL_PATH,    - E-Commerce   - TRANSACTION_COUNTRY,  - TRANSACTION_REGION,  -
   * TRANSACTION_CITY,  - TRANSACTION_AFFILIATION (Store or order location),  - ITEM_NAME,  -
   * ITEM_CODE,  - ITEM_VARIATION,  - TRANSACTION_ID,  - TRANSACTION_CURRENCY_CODE,  -
   * PRODUCT_ACTION_TYPE,    - Audience/Users   - BROWSER,  - BROWSER_VERSION,  - BROWSER_SIZE,  -
   * PLATFORM,  - PLATFORM_VERSION,  - LANGUAGE,  - SCREEN_RESOLUTION,  - SCREEN_COLORS,  -
   * JAVA_ENABLED,  - FLASH_VERSION,  - GEO_SPEED (Connection speed),  - VISITOR_TYPE,  -
   * GEO_ORGANIZATION (ISP organization),  - GEO_DOMAIN,  - GEO_IP_ADDRESS,  - GEO_IP_VERSION,    -
   * Location   - GEO_COUNTRY,  - GEO_REGION,  - GEO_CITY,    - Event   - EVENT_CATEGORY,  -
   * EVENT_ACTION,  - EVENT_LABEL,    - Other   - CUSTOM_FIELD_1,  - CUSTOM_FIELD_2,  -
   * USER_DEFINED_VALUE,    - Application   - APP_ID,  - APP_INSTALLER_ID,  - APP_NAME,  -
   * APP_VERSION,  - SCREEN,  - IS_APP,  - IS_FATAL_EXCEPTION,  - EXCEPTION_DESCRIPTION,    - Mobile
   * device   - IS_MOBILE,  - IS_TABLET,  - MOBILE_HAS_QWERTY_KEYBOARD,  - MOBILE_HAS_NFC_SUPPORT,
   * - MOBILE_HAS_CELLULAR_RADIO,  - MOBILE_HAS_WIFI_SUPPORT,  - MOBILE_BRAND_NAME,  -
   * MOBILE_MODEL_NAME,  - MOBILE_MARKETING_NAME,  - MOBILE_POINTING_METHOD,    - Social   -
   * SOCIAL_NETWORK,  - SOCIAL_ACTION,  - SOCIAL_ACTION_TARGET,
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String field;

  /**
   * Kind value for filter expression
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Match type for this filter. Possible values are BEGINS_WITH, EQUAL, ENDS_WITH, CONTAINS,
   * MATCHES. Include and Exclude filters can use any match type. Match type is not applicable to
   * Upper case and Lower case filters. Search and Replace expressions in the Search and Replace
   * filter and all filter expressions in the Advanced filter default to MATCHES. User should not
   * set match type for those filters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String matchType;

  /**
   * Determines if the filter is case sensitive.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCaseSensitive() {
    return caseSensitive;
  }

  /**
   * Determines if the filter is case sensitive.
   * @param caseSensitive caseSensitive or {@code null} for none
   */
  public FilterExpression setCaseSensitive(java.lang.Boolean caseSensitive) {
    this.caseSensitive = caseSensitive;
    return this;
  }

  /**
   * Filter expression value
   * @return value or {@code null} for none
   */
  public java.lang.String getExpressionValue() {
    return expressionValue;
  }

  /**
   * Filter expression value
   * @param expressionValue expressionValue or {@code null} for none
   */
  public FilterExpression setExpressionValue(java.lang.String expressionValue) {
    this.expressionValue = expressionValue;
    return this;
  }

  /**
   * Field to filter. Possible values: - Reserved   - UNUSED,    - Content and Traffic   -
   * PAGE_REQUEST_URI,  - PAGE_HOSTNAME,  - PAGE_TITLE,  - REFERRAL,  - COST_DATA_URI (Campaign
   * target URL),  - HIT_TYPE,  - INTERNAL_SEARCH_TERM,  - INTERNAL_SEARCH_TYPE,  -
   * SOURCE_PROPERTY_TRACKING_ID,    - Campaign or AdGroup   - CAMPAIGN_SOURCE,  - CAMPAIGN_MEDIUM,
   * - CAMPAIGN_NAME,  - CAMPAIGN_AD_GROUP,  - CAMPAIGN_TERM,  - CAMPAIGN_CONTENT,  - CAMPAIGN_CODE,
   * - CAMPAIGN_REFERRAL_PATH,    - E-Commerce   - TRANSACTION_COUNTRY,  - TRANSACTION_REGION,  -
   * TRANSACTION_CITY,  - TRANSACTION_AFFILIATION (Store or order location),  - ITEM_NAME,  -
   * ITEM_CODE,  - ITEM_VARIATION,  - TRANSACTION_ID,  - TRANSACTION_CURRENCY_CODE,  -
   * PRODUCT_ACTION_TYPE,    - Audience/Users   - BROWSER,  - BROWSER_VERSION,  - BROWSER_SIZE,  -
   * PLATFORM,  - PLATFORM_VERSION,  - LANGUAGE,  - SCREEN_RESOLUTION,  - SCREEN_COLORS,  -
   * JAVA_ENABLED,  - FLASH_VERSION,  - GEO_SPEED (Connection speed),  - VISITOR_TYPE,  -
   * GEO_ORGANIZATION (ISP organization),  - GEO_DOMAIN,  - GEO_IP_ADDRESS,  - GEO_IP_VERSION,    -
   * Location   - GEO_COUNTRY,  - GEO_REGION,  - GEO_CITY,    - Event   - EVENT_CATEGORY,  -
   * EVENT_ACTION,  - EVENT_LABEL,    - Other   - CUSTOM_FIELD_1,  - CUSTOM_FIELD_2,  -
   * USER_DEFINED_VALUE,    - Application   - APP_ID,  - APP_INSTALLER_ID,  - APP_NAME,  -
   * APP_VERSION,  - SCREEN,  - IS_APP,  - IS_FATAL_EXCEPTION,  - EXCEPTION_DESCRIPTION,    - Mobile
   * device   - IS_MOBILE,  - IS_TABLET,  - MOBILE_HAS_QWERTY_KEYBOARD,  - MOBILE_HAS_NFC_SUPPORT,
   * - MOBILE_HAS_CELLULAR_RADIO,  - MOBILE_HAS_WIFI_SUPPORT,  - MOBILE_BRAND_NAME,  -
   * MOBILE_MODEL_NAME,  - MOBILE_MARKETING_NAME,  - MOBILE_POINTING_METHOD,    - Social   -
   * SOCIAL_NETWORK,  - SOCIAL_ACTION,  - SOCIAL_ACTION_TARGET,
   * @return value or {@code null} for none
   */
  public java.lang.String getField() {
    return field;
  }

  /**
   * Field to filter. Possible values: - Reserved   - UNUSED,    - Content and Traffic   -
   * PAGE_REQUEST_URI,  - PAGE_HOSTNAME,  - PAGE_TITLE,  - REFERRAL,  - COST_DATA_URI (Campaign
   * target URL),  - HIT_TYPE,  - INTERNAL_SEARCH_TERM,  - INTERNAL_SEARCH_TYPE,  -
   * SOURCE_PROPERTY_TRACKING_ID,    - Campaign or AdGroup   - CAMPAIGN_SOURCE,  - CAMPAIGN_MEDIUM,
   * - CAMPAIGN_NAME,  - CAMPAIGN_AD_GROUP,  - CAMPAIGN_TERM,  - CAMPAIGN_CONTENT,  - CAMPAIGN_CODE,
   * - CAMPAIGN_REFERRAL_PATH,    - E-Commerce   - TRANSACTION_COUNTRY,  - TRANSACTION_REGION,  -
   * TRANSACTION_CITY,  - TRANSACTION_AFFILIATION (Store or order location),  - ITEM_NAME,  -
   * ITEM_CODE,  - ITEM_VARIATION,  - TRANSACTION_ID,  - TRANSACTION_CURRENCY_CODE,  -
   * PRODUCT_ACTION_TYPE,    - Audience/Users   - BROWSER,  - BROWSER_VERSION,  - BROWSER_SIZE,  -
   * PLATFORM,  - PLATFORM_VERSION,  - LANGUAGE,  - SCREEN_RESOLUTION,  - SCREEN_COLORS,  -
   * JAVA_ENABLED,  - FLASH_VERSION,  - GEO_SPEED (Connection speed),  - VISITOR_TYPE,  -
   * GEO_ORGANIZATION (ISP organization),  - GEO_DOMAIN,  - GEO_IP_ADDRESS,  - GEO_IP_VERSION,    -
   * Location   - GEO_COUNTRY,  - GEO_REGION,  - GEO_CITY,    - Event   - EVENT_CATEGORY,  -
   * EVENT_ACTION,  - EVENT_LABEL,    - Other   - CUSTOM_FIELD_1,  - CUSTOM_FIELD_2,  -
   * USER_DEFINED_VALUE,    - Application   - APP_ID,  - APP_INSTALLER_ID,  - APP_NAME,  -
   * APP_VERSION,  - SCREEN,  - IS_APP,  - IS_FATAL_EXCEPTION,  - EXCEPTION_DESCRIPTION,    - Mobile
   * device   - IS_MOBILE,  - IS_TABLET,  - MOBILE_HAS_QWERTY_KEYBOARD,  - MOBILE_HAS_NFC_SUPPORT,
   * - MOBILE_HAS_CELLULAR_RADIO,  - MOBILE_HAS_WIFI_SUPPORT,  - MOBILE_BRAND_NAME,  -
   * MOBILE_MODEL_NAME,  - MOBILE_MARKETING_NAME,  - MOBILE_POINTING_METHOD,    - Social   -
   * SOCIAL_NETWORK,  - SOCIAL_ACTION,  - SOCIAL_ACTION_TARGET,
   * @param field field or {@code null} for none
   */
  public FilterExpression setField(java.lang.String field) {
    this.field = field;
    return this;
  }

  /**
   * Kind value for filter expression
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Kind value for filter expression
   * @param kind kind or {@code null} for none
   */
  public FilterExpression setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Match type for this filter. Possible values are BEGINS_WITH, EQUAL, ENDS_WITH, CONTAINS,
   * MATCHES. Include and Exclude filters can use any match type. Match type is not applicable to
   * Upper case and Lower case filters. Search and Replace expressions in the Search and Replace
   * filter and all filter expressions in the Advanced filter default to MATCHES. User should not
   * set match type for those filters.
   * @return value or {@code null} for none
   */
  public java.lang.String getMatchType() {
    return matchType;
  }

  /**
   * Match type for this filter. Possible values are BEGINS_WITH, EQUAL, ENDS_WITH, CONTAINS,
   * MATCHES. Include and Exclude filters can use any match type. Match type is not applicable to
   * Upper case and Lower case filters. Search and Replace expressions in the Search and Replace
   * filter and all filter expressions in the Advanced filter default to MATCHES. User should not
   * set match type for those filters.
   * @param matchType matchType or {@code null} for none
   */
  public FilterExpression setMatchType(java.lang.String matchType) {
    this.matchType = matchType;
    return this;
  }

  @Override
  public FilterExpression set(String fieldName, Object value) {
    return (FilterExpression) super.set(fieldName, value);
  }

  @Override
  public FilterExpression clone() {
    return (FilterExpression) super.clone();
  }

}
