/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.analytics;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.Key;
import com.google.api.services.analytics.AnalyticsRequest;
import com.google.api.services.analytics.AnalyticsRequestInitializer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analytics
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "analytics/v2.4/";
    @Deprecated
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/analytics/v2.4/";

    public Analytics(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        super(httpTransport, jsonFactory, DEFAULT_ROOT_URL, DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
    }

    Analytics(HttpTransport httpTransport, HttpRequestInitializer httpRequestInitializer, String string, String string2, JsonObjectParser jsonObjectParser, GoogleClientRequestInitializer googleClientRequestInitializer, String string3, boolean bl) {
        super(httpTransport, httpRequestInitializer, string, string2, jsonObjectParser, googleClientRequestInitializer, string3, bl);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Data data() {
        return new Data();
    }

    public Management management() {
        return new Management();
    }

    static {
        Preconditions.checkState((boolean)"1.13.2-beta".equals("1.13.2-beta"), (String)"You are currently running with version %s of google-api-client. You need version 1.13.2-beta of google-api-client to run version 1.13.2-beta of the Google Analytics API library.", (Object[])new Object[]{"1.13.2-beta"});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Analytics.DEFAULT_ROOT_URL, Analytics.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Analytics build() {
            return new Analytics(this.getTransport(), this.getHttpRequestInitializer(), this.getRootUrl(), this.getServicePath(), this.getObjectParser(), this.getGoogleClientRequestInitializer(), this.getApplicationName(), this.getSuppressPatternChecks());
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setAnalyticsRequestInitializer(AnalyticsRequestInitializer analyticsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)analyticsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Management {
        public Accounts accounts() {
            return new Accounts();
        }

        public Goals goals() {
            return new Goals();
        }

        public Profiles profiles() {
            return new Profiles();
        }

        public Segments segments() {
            return new Segments();
        }

        public Webproperties webproperties() {
            return new Webproperties();
        }

        public class Webproperties {
            public List list(String string) throws IOException {
                List list = new List(string);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties";
                @Key
                private String accountId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string) {
                    super(Analytics.this, "GET", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.set("alt", "json");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }
            }
        }

        public class Segments {
            public List list() throws IOException {
                List list = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/segments";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, Void.class);
                    this.set("alt", "json");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }
            }
        }

        public class Profiles {
            public List list(String string, String string2) throws IOException {
                List list = new List(string, string2);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2) {
                    super(Analytics.this, "GET", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.set("alt", "json");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }
            }
        }

        public class Goals {
            public List list(String string, String string2, String string3) throws IOException {
                List list = new List(string, string2, string3);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String string, String string2, String string3) {
                    super(Analytics.this, "GET", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter profileId must be specified.");
                    this.set("alt", "json");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String string) {
                    this.accountId = string;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String string) {
                    this.webPropertyId = string;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String string) {
                    this.profileId = string;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }
            }
        }

        public class Accounts {
            public List list() throws IOException {
                List list = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, Void.class);
                    this.set("alt", "json");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer n) {
                    this.maxResults = n;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer n) {
                    this.startIndex = n;
                    return this;
                }
            }
        }
    }

    public class Data {
        public Get get(String string, String string2, String string3, String string4) throws IOException {
            Get get = new Get(string, string2, string3, string4);
            Analytics.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends AnalyticsRequest<Void> {
            private static final String REST_PATH = "data";
            private final Pattern IDS_PATTERN;
            private final Pattern STARTDATE_PATTERN;
            private final Pattern ENDDATE_PATTERN;
            private final Pattern METRICS_PATTERN;
            private final Pattern SORT_PATTERN;
            private final Pattern DIMENSIONS_PATTERN;
            private final Pattern FILTERS_PATTERN;
            @Key
            private String ids;
            @Key(value="start-date")
            private String startDate;
            @Key(value="end-date")
            private String endDate;
            @Key
            private String metrics;
            @Key(value="max-results")
            private Integer maxResults;
            @Key
            private String sort;
            @Key
            private String dimensions;
            @Key(value="start-index")
            private Integer startIndex;
            @Key
            private String segment;
            @Key
            private String filters;

            protected Get(String string, String string2, String string3, String string4) {
                super(Analytics.this, "GET", REST_PATH, null, Void.class);
                this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                this.STARTDATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                this.ENDDATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
                this.METRICS_PATTERN = Pattern.compile("ga:.+");
                this.SORT_PATTERN = Pattern.compile("(-)?ga:.+");
                this.DIMENSIONS_PATTERN = Pattern.compile("(ga:.+)?");
                this.FILTERS_PATTERN = Pattern.compile("ga:.+");
                this.ids = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter ids must be specified.");
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                }
                this.startDate = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter startDate must be specified.");
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.STARTDATE_PATTERN.matcher(string2).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                }
                this.endDate = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter endDate must be specified.");
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ENDDATE_PATTERN.matcher(string3).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                }
                this.metrics = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter metrics must be specified.");
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string4).matches(), (Object)"Parameter metrics must conform to the pattern ga:.+");
                }
                this.set("alt", "json");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getIds() {
                return this.ids;
            }

            public Get setIds(String string) {
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(string).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                }
                this.ids = string;
                return this;
            }

            public String getStartDate() {
                return this.startDate;
            }

            public Get setStartDate(String string) {
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.STARTDATE_PATTERN.matcher(string).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                }
                this.startDate = string;
                return this;
            }

            public String getEndDate() {
                return this.endDate;
            }

            public Get setEndDate(String string) {
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ENDDATE_PATTERN.matcher(string).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}");
                }
                this.endDate = string;
                return this;
            }

            public String getMetrics() {
                return this.metrics;
            }

            public Get setMetrics(String string) {
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(string).matches(), (Object)"Parameter metrics must conform to the pattern ga:.+");
                }
                this.metrics = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Get setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getSort() {
                return this.sort;
            }

            public Get setSort(String string) {
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(string).matches(), (Object)"Parameter sort must conform to the pattern (-)?ga:.+");
                }
                this.sort = string;
                return this;
            }

            public String getDimensions() {
                return this.dimensions;
            }

            public Get setDimensions(String string) {
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(string).matches(), (Object)"Parameter dimensions must conform to the pattern (ga:.+)?");
                }
                this.dimensions = string;
                return this;
            }

            public Integer getStartIndex() {
                return this.startIndex;
            }

            public Get setStartIndex(Integer n) {
                this.startIndex = n;
                return this;
            }

            public String getSegment() {
                return this.segment;
            }

            public Get setSegment(String string) {
                this.segment = string;
                return this;
            }

            public String getFilters() {
                return this.filters;
            }

            public Get setFilters(String string) {
                if (!Analytics.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern ga:.+");
                }
                this.filters = string;
                return this;
            }
        }
    }
}

