/*
 * Decompiled with CFR 0.152.
 */
package com.google.identity.accesscontextmanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServicePerimeterName
implements ResourceName {
    private static final PathTemplate ACCESS_POLICY_SERVICE_PERIMETER = PathTemplate.createWithoutUrlEncoding((String)"accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}");
    private volatile Map<String, String> fieldValuesMap;
    private final String accessPolicy;
    private final String servicePerimeter;

    @Deprecated
    protected ServicePerimeterName() {
        this.accessPolicy = null;
        this.servicePerimeter = null;
    }

    private ServicePerimeterName(Builder builder) {
        this.accessPolicy = (String)Preconditions.checkNotNull((Object)builder.getAccessPolicy());
        this.servicePerimeter = (String)Preconditions.checkNotNull((Object)builder.getServicePerimeter());
    }

    public String getAccessPolicy() {
        return this.accessPolicy;
    }

    public String getServicePerimeter() {
        return this.servicePerimeter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServicePerimeterName of(String accessPolicy, String servicePerimeter) {
        return ServicePerimeterName.newBuilder().setAccessPolicy(accessPolicy).setServicePerimeter(servicePerimeter).build();
    }

    public static String format(String accessPolicy, String servicePerimeter) {
        return ServicePerimeterName.newBuilder().setAccessPolicy(accessPolicy).setServicePerimeter(servicePerimeter).build().toString();
    }

    public static ServicePerimeterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCESS_POLICY_SERVICE_PERIMETER.validatedMatch(formattedString, "ServicePerimeterName.parse: formattedString not in valid format");
        return ServicePerimeterName.of((String)matchMap.get("access_policy"), (String)matchMap.get("service_perimeter"));
    }

    public static List<ServicePerimeterName> parseList(List<String> formattedStrings) {
        ArrayList<ServicePerimeterName> list = new ArrayList<ServicePerimeterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServicePerimeterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServicePerimeterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServicePerimeterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCESS_POLICY_SERVICE_PERIMETER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServicePerimeterName servicePerimeterName = this;
            synchronized (servicePerimeterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.accessPolicy != null) {
                        fieldMapBuilder.put((Object)"access_policy", (Object)this.accessPolicy);
                    }
                    if (this.servicePerimeter != null) {
                        fieldMapBuilder.put((Object)"service_perimeter", (Object)this.servicePerimeter);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCESS_POLICY_SERVICE_PERIMETER.instantiate(new String[]{"access_policy", this.accessPolicy, "service_perimeter", this.servicePerimeter});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ServicePerimeterName that = (ServicePerimeterName)o;
            return Objects.equals(this.accessPolicy, that.accessPolicy) && Objects.equals(this.servicePerimeter, that.servicePerimeter);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.accessPolicy);
        h *= 1000003;
        return h ^= Objects.hashCode(this.servicePerimeter);
    }

    public static class Builder {
        private String accessPolicy;
        private String servicePerimeter;

        protected Builder() {
        }

        public String getAccessPolicy() {
            return this.accessPolicy;
        }

        public String getServicePerimeter() {
            return this.servicePerimeter;
        }

        public Builder setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public Builder setServicePerimeter(String servicePerimeter) {
            this.servicePerimeter = servicePerimeter;
            return this;
        }

        private Builder(ServicePerimeterName servicePerimeterName) {
            this.accessPolicy = servicePerimeterName.accessPolicy;
            this.servicePerimeter = servicePerimeterName.servicePerimeter;
        }

        public ServicePerimeterName build() {
            return new ServicePerimeterName(this);
        }
    }
}

