/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PolicyName
implements ResourceName {
    private static final PathTemplate POLICY = PathTemplate.createWithoutUrlEncoding((String)"policies/{policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String policy;

    @Deprecated
    protected PolicyName() {
        this.policy = null;
    }

    private PolicyName(Builder builder) {
        this.policy = (String)Preconditions.checkNotNull((Object)builder.getPolicy());
    }

    public String getPolicy() {
        return this.policy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PolicyName of(String policy) {
        return PolicyName.newBuilder().setPolicy(policy).build();
    }

    public static String format(String policy) {
        return PolicyName.newBuilder().setPolicy(policy).build().toString();
    }

    public static PolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = POLICY.validatedMatch(formattedString, "PolicyName.parse: formattedString not in valid format");
        return PolicyName.of((String)matchMap.get("policy"));
    }

    public static List<PolicyName> parseList(List<String> formattedStrings) {
        ArrayList<PolicyName> list = new ArrayList<PolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PolicyName policyName = this;
            synchronized (policyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.policy != null) {
                        fieldMapBuilder.put((Object)"policy", (Object)this.policy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return POLICY.instantiate(new String[]{"policy", this.policy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PolicyName that = (PolicyName)o;
            return Objects.equals(this.policy, that.policy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.policy);
    }

    public static class Builder {
        private String policy;

        protected Builder() {
        }

        public String getPolicy() {
            return this.policy;
        }

        public Builder setPolicy(String policy) {
            this.policy = policy;
            return this;
        }

        private Builder(PolicyName policyName) {
            this.policy = policyName.policy;
        }

        public PolicyName build() {
            return new PolicyName(this);
        }
    }
}

