/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/rpc/context/audit_context.proto

// Protobuf Java Version: 3.25.8
package com.google.rpc.context;

/**
 *
 *
 * <pre>
 * `AuditContext` provides information that is needed for audit logging.
 * </pre>
 *
 * Protobuf type {@code google.rpc.context.AuditContext}
 */
public final class AuditContext extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.rpc.context.AuditContext)
    AuditContextOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AuditContext.newBuilder() to construct.
  private AuditContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AuditContext() {
    auditLog_ = com.google.protobuf.ByteString.EMPTY;
    targetResource_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AuditContext();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.rpc.context.AuditContextProto
        .internal_static_google_rpc_context_AuditContext_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.rpc.context.AuditContextProto
        .internal_static_google_rpc_context_AuditContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.rpc.context.AuditContext.class,
            com.google.rpc.context.AuditContext.Builder.class);
  }

  private int bitField0_;
  public static final int AUDIT_LOG_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString auditLog_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * Serialized audit log.
   * </pre>
   *
   * <code>bytes audit_log = 1;</code>
   *
   * @return The auditLog.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuditLog() {
    return auditLog_;
  }

  public static final int SCRUBBED_REQUEST_FIELD_NUMBER = 2;
  private com.google.protobuf.Struct scrubbedRequest_;

  /**
   *
   *
   * <pre>
   * An API request message that is scrubbed based on the method annotation.
   * This field should only be filled if audit_log field is present.
   * Service Control will use this to assemble a complete log for Cloud Audit
   * Logs and Google internal audit logs.
   * </pre>
   *
   * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
   *
   * @return Whether the scrubbedRequest field is set.
   */
  @java.lang.Override
  public boolean hasScrubbedRequest() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * An API request message that is scrubbed based on the method annotation.
   * This field should only be filled if audit_log field is present.
   * Service Control will use this to assemble a complete log for Cloud Audit
   * Logs and Google internal audit logs.
   * </pre>
   *
   * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
   *
   * @return The scrubbedRequest.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getScrubbedRequest() {
    return scrubbedRequest_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : scrubbedRequest_;
  }

  /**
   *
   *
   * <pre>
   * An API request message that is scrubbed based on the method annotation.
   * This field should only be filled if audit_log field is present.
   * Service Control will use this to assemble a complete log for Cloud Audit
   * Logs and Google internal audit logs.
   * </pre>
   *
   * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getScrubbedRequestOrBuilder() {
    return scrubbedRequest_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : scrubbedRequest_;
  }

  public static final int SCRUBBED_RESPONSE_FIELD_NUMBER = 3;
  private com.google.protobuf.Struct scrubbedResponse_;

  /**
   *
   *
   * <pre>
   * An API response message that is scrubbed based on the method annotation.
   * This field should only be filled if audit_log field is present.
   * Service Control will use this to assemble a complete log for Cloud Audit
   * Logs and Google internal audit logs.
   * </pre>
   *
   * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
   *
   * @return Whether the scrubbedResponse field is set.
   */
  @java.lang.Override
  public boolean hasScrubbedResponse() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An API response message that is scrubbed based on the method annotation.
   * This field should only be filled if audit_log field is present.
   * Service Control will use this to assemble a complete log for Cloud Audit
   * Logs and Google internal audit logs.
   * </pre>
   *
   * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
   *
   * @return The scrubbedResponse.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getScrubbedResponse() {
    return scrubbedResponse_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : scrubbedResponse_;
  }

  /**
   *
   *
   * <pre>
   * An API response message that is scrubbed based on the method annotation.
   * This field should only be filled if audit_log field is present.
   * Service Control will use this to assemble a complete log for Cloud Audit
   * Logs and Google internal audit logs.
   * </pre>
   *
   * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getScrubbedResponseOrBuilder() {
    return scrubbedResponse_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : scrubbedResponse_;
  }

  public static final int SCRUBBED_RESPONSE_ITEM_COUNT_FIELD_NUMBER = 4;
  private int scrubbedResponseItemCount_ = 0;

  /**
   *
   *
   * <pre>
   * Number of scrubbed response items.
   * </pre>
   *
   * <code>int32 scrubbed_response_item_count = 4;</code>
   *
   * @return The scrubbedResponseItemCount.
   */
  @java.lang.Override
  public int getScrubbedResponseItemCount() {
    return scrubbedResponseItemCount_;
  }

  public static final int TARGET_RESOURCE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetResource_ = "";

  /**
   *
   *
   * <pre>
   * Audit resource name which is scrubbed.
   * </pre>
   *
   * <code>string target_resource = 5;</code>
   *
   * @return The targetResource.
   */
  @java.lang.Override
  public java.lang.String getTargetResource() {
    java.lang.Object ref = targetResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetResource_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Audit resource name which is scrubbed.
   * </pre>
   *
   * <code>string target_resource = 5;</code>
   *
   * @return The bytes for targetResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetResourceBytes() {
    java.lang.Object ref = targetResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!auditLog_.isEmpty()) {
      output.writeBytes(1, auditLog_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getScrubbedRequest());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getScrubbedResponse());
    }
    if (scrubbedResponseItemCount_ != 0) {
      output.writeInt32(4, scrubbedResponseItemCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, targetResource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!auditLog_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, auditLog_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getScrubbedRequest());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getScrubbedResponse());
    }
    if (scrubbedResponseItemCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, scrubbedResponseItemCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetResource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, targetResource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.rpc.context.AuditContext)) {
      return super.equals(obj);
    }
    com.google.rpc.context.AuditContext other = (com.google.rpc.context.AuditContext) obj;

    if (!getAuditLog().equals(other.getAuditLog())) return false;
    if (hasScrubbedRequest() != other.hasScrubbedRequest()) return false;
    if (hasScrubbedRequest()) {
      if (!getScrubbedRequest().equals(other.getScrubbedRequest())) return false;
    }
    if (hasScrubbedResponse() != other.hasScrubbedResponse()) return false;
    if (hasScrubbedResponse()) {
      if (!getScrubbedResponse().equals(other.getScrubbedResponse())) return false;
    }
    if (getScrubbedResponseItemCount() != other.getScrubbedResponseItemCount()) return false;
    if (!getTargetResource().equals(other.getTargetResource())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AUDIT_LOG_FIELD_NUMBER;
    hash = (53 * hash) + getAuditLog().hashCode();
    if (hasScrubbedRequest()) {
      hash = (37 * hash) + SCRUBBED_REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getScrubbedRequest().hashCode();
    }
    if (hasScrubbedResponse()) {
      hash = (37 * hash) + SCRUBBED_RESPONSE_FIELD_NUMBER;
      hash = (53 * hash) + getScrubbedResponse().hashCode();
    }
    hash = (37 * hash) + SCRUBBED_RESPONSE_ITEM_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getScrubbedResponseItemCount();
    hash = (37 * hash) + TARGET_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getTargetResource().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.rpc.context.AuditContext parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.context.AuditContext parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.context.AuditContext parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.context.AuditContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.context.AuditContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.rpc.context.AuditContext parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.rpc.context.AuditContext parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.rpc.context.AuditContext parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.rpc.context.AuditContext parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.rpc.context.AuditContext parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.rpc.context.AuditContext parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.rpc.context.AuditContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.rpc.context.AuditContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * `AuditContext` provides information that is needed for audit logging.
   * </pre>
   *
   * Protobuf type {@code google.rpc.context.AuditContext}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.rpc.context.AuditContext)
      com.google.rpc.context.AuditContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.rpc.context.AuditContextProto
          .internal_static_google_rpc_context_AuditContext_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.rpc.context.AuditContextProto
          .internal_static_google_rpc_context_AuditContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.rpc.context.AuditContext.class,
              com.google.rpc.context.AuditContext.Builder.class);
    }

    // Construct using com.google.rpc.context.AuditContext.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getScrubbedRequestFieldBuilder();
        getScrubbedResponseFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      auditLog_ = com.google.protobuf.ByteString.EMPTY;
      scrubbedRequest_ = null;
      if (scrubbedRequestBuilder_ != null) {
        scrubbedRequestBuilder_.dispose();
        scrubbedRequestBuilder_ = null;
      }
      scrubbedResponse_ = null;
      if (scrubbedResponseBuilder_ != null) {
        scrubbedResponseBuilder_.dispose();
        scrubbedResponseBuilder_ = null;
      }
      scrubbedResponseItemCount_ = 0;
      targetResource_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.rpc.context.AuditContextProto
          .internal_static_google_rpc_context_AuditContext_descriptor;
    }

    @java.lang.Override
    public com.google.rpc.context.AuditContext getDefaultInstanceForType() {
      return com.google.rpc.context.AuditContext.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.rpc.context.AuditContext build() {
      com.google.rpc.context.AuditContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.rpc.context.AuditContext buildPartial() {
      com.google.rpc.context.AuditContext result = new com.google.rpc.context.AuditContext(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.rpc.context.AuditContext result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.auditLog_ = auditLog_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.scrubbedRequest_ =
            scrubbedRequestBuilder_ == null ? scrubbedRequest_ : scrubbedRequestBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.scrubbedResponse_ =
            scrubbedResponseBuilder_ == null ? scrubbedResponse_ : scrubbedResponseBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.scrubbedResponseItemCount_ = scrubbedResponseItemCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.targetResource_ = targetResource_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.rpc.context.AuditContext) {
        return mergeFrom((com.google.rpc.context.AuditContext) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.rpc.context.AuditContext other) {
      if (other == com.google.rpc.context.AuditContext.getDefaultInstance()) return this;
      if (other.getAuditLog() != com.google.protobuf.ByteString.EMPTY) {
        setAuditLog(other.getAuditLog());
      }
      if (other.hasScrubbedRequest()) {
        mergeScrubbedRequest(other.getScrubbedRequest());
      }
      if (other.hasScrubbedResponse()) {
        mergeScrubbedResponse(other.getScrubbedResponse());
      }
      if (other.getScrubbedResponseItemCount() != 0) {
        setScrubbedResponseItemCount(other.getScrubbedResponseItemCount());
      }
      if (!other.getTargetResource().isEmpty()) {
        targetResource_ = other.targetResource_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                auditLog_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getScrubbedRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getScrubbedResponseFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                scrubbedResponseItemCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                targetResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString auditLog_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Serialized audit log.
     * </pre>
     *
     * <code>bytes audit_log = 1;</code>
     *
     * @return The auditLog.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAuditLog() {
      return auditLog_;
    }

    /**
     *
     *
     * <pre>
     * Serialized audit log.
     * </pre>
     *
     * <code>bytes audit_log = 1;</code>
     *
     * @param value The auditLog to set.
     * @return This builder for chaining.
     */
    public Builder setAuditLog(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      auditLog_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Serialized audit log.
     * </pre>
     *
     * <code>bytes audit_log = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuditLog() {
      bitField0_ = (bitField0_ & ~0x00000001);
      auditLog_ = getDefaultInstance().getAuditLog();
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct scrubbedRequest_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        scrubbedRequestBuilder_;

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     *
     * @return Whether the scrubbedRequest field is set.
     */
    public boolean hasScrubbedRequest() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     *
     * @return The scrubbedRequest.
     */
    public com.google.protobuf.Struct getScrubbedRequest() {
      if (scrubbedRequestBuilder_ == null) {
        return scrubbedRequest_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : scrubbedRequest_;
      } else {
        return scrubbedRequestBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     */
    public Builder setScrubbedRequest(com.google.protobuf.Struct value) {
      if (scrubbedRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scrubbedRequest_ = value;
      } else {
        scrubbedRequestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     */
    public Builder setScrubbedRequest(com.google.protobuf.Struct.Builder builderForValue) {
      if (scrubbedRequestBuilder_ == null) {
        scrubbedRequest_ = builderForValue.build();
      } else {
        scrubbedRequestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     */
    public Builder mergeScrubbedRequest(com.google.protobuf.Struct value) {
      if (scrubbedRequestBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && scrubbedRequest_ != null
            && scrubbedRequest_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getScrubbedRequestBuilder().mergeFrom(value);
        } else {
          scrubbedRequest_ = value;
        }
      } else {
        scrubbedRequestBuilder_.mergeFrom(value);
      }
      if (scrubbedRequest_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     */
    public Builder clearScrubbedRequest() {
      bitField0_ = (bitField0_ & ~0x00000002);
      scrubbedRequest_ = null;
      if (scrubbedRequestBuilder_ != null) {
        scrubbedRequestBuilder_.dispose();
        scrubbedRequestBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     */
    public com.google.protobuf.Struct.Builder getScrubbedRequestBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getScrubbedRequestFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     */
    public com.google.protobuf.StructOrBuilder getScrubbedRequestOrBuilder() {
      if (scrubbedRequestBuilder_ != null) {
        return scrubbedRequestBuilder_.getMessageOrBuilder();
      } else {
        return scrubbedRequest_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : scrubbedRequest_;
      }
    }

    /**
     *
     *
     * <pre>
     * An API request message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_request = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getScrubbedRequestFieldBuilder() {
      if (scrubbedRequestBuilder_ == null) {
        scrubbedRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getScrubbedRequest(), getParentForChildren(), isClean());
        scrubbedRequest_ = null;
      }
      return scrubbedRequestBuilder_;
    }

    private com.google.protobuf.Struct scrubbedResponse_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        scrubbedResponseBuilder_;

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     *
     * @return Whether the scrubbedResponse field is set.
     */
    public boolean hasScrubbedResponse() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     *
     * @return The scrubbedResponse.
     */
    public com.google.protobuf.Struct getScrubbedResponse() {
      if (scrubbedResponseBuilder_ == null) {
        return scrubbedResponse_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : scrubbedResponse_;
      } else {
        return scrubbedResponseBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     */
    public Builder setScrubbedResponse(com.google.protobuf.Struct value) {
      if (scrubbedResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scrubbedResponse_ = value;
      } else {
        scrubbedResponseBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     */
    public Builder setScrubbedResponse(com.google.protobuf.Struct.Builder builderForValue) {
      if (scrubbedResponseBuilder_ == null) {
        scrubbedResponse_ = builderForValue.build();
      } else {
        scrubbedResponseBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     */
    public Builder mergeScrubbedResponse(com.google.protobuf.Struct value) {
      if (scrubbedResponseBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && scrubbedResponse_ != null
            && scrubbedResponse_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getScrubbedResponseBuilder().mergeFrom(value);
        } else {
          scrubbedResponse_ = value;
        }
      } else {
        scrubbedResponseBuilder_.mergeFrom(value);
      }
      if (scrubbedResponse_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     */
    public Builder clearScrubbedResponse() {
      bitField0_ = (bitField0_ & ~0x00000004);
      scrubbedResponse_ = null;
      if (scrubbedResponseBuilder_ != null) {
        scrubbedResponseBuilder_.dispose();
        scrubbedResponseBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     */
    public com.google.protobuf.Struct.Builder getScrubbedResponseBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getScrubbedResponseFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     */
    public com.google.protobuf.StructOrBuilder getScrubbedResponseOrBuilder() {
      if (scrubbedResponseBuilder_ != null) {
        return scrubbedResponseBuilder_.getMessageOrBuilder();
      } else {
        return scrubbedResponse_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : scrubbedResponse_;
      }
    }

    /**
     *
     *
     * <pre>
     * An API response message that is scrubbed based on the method annotation.
     * This field should only be filled if audit_log field is present.
     * Service Control will use this to assemble a complete log for Cloud Audit
     * Logs and Google internal audit logs.
     * </pre>
     *
     * <code>.google.protobuf.Struct scrubbed_response = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getScrubbedResponseFieldBuilder() {
      if (scrubbedResponseBuilder_ == null) {
        scrubbedResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getScrubbedResponse(), getParentForChildren(), isClean());
        scrubbedResponse_ = null;
      }
      return scrubbedResponseBuilder_;
    }

    private int scrubbedResponseItemCount_;

    /**
     *
     *
     * <pre>
     * Number of scrubbed response items.
     * </pre>
     *
     * <code>int32 scrubbed_response_item_count = 4;</code>
     *
     * @return The scrubbedResponseItemCount.
     */
    @java.lang.Override
    public int getScrubbedResponseItemCount() {
      return scrubbedResponseItemCount_;
    }

    /**
     *
     *
     * <pre>
     * Number of scrubbed response items.
     * </pre>
     *
     * <code>int32 scrubbed_response_item_count = 4;</code>
     *
     * @param value The scrubbedResponseItemCount to set.
     * @return This builder for chaining.
     */
    public Builder setScrubbedResponseItemCount(int value) {

      scrubbedResponseItemCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Number of scrubbed response items.
     * </pre>
     *
     * <code>int32 scrubbed_response_item_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScrubbedResponseItemCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      scrubbedResponseItemCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object targetResource_ = "";

    /**
     *
     *
     * <pre>
     * Audit resource name which is scrubbed.
     * </pre>
     *
     * <code>string target_resource = 5;</code>
     *
     * @return The targetResource.
     */
    public java.lang.String getTargetResource() {
      java.lang.Object ref = targetResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Audit resource name which is scrubbed.
     * </pre>
     *
     * <code>string target_resource = 5;</code>
     *
     * @return The bytes for targetResource.
     */
    public com.google.protobuf.ByteString getTargetResourceBytes() {
      java.lang.Object ref = targetResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Audit resource name which is scrubbed.
     * </pre>
     *
     * <code>string target_resource = 5;</code>
     *
     * @param value The targetResource to set.
     * @return This builder for chaining.
     */
    public Builder setTargetResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetResource_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audit resource name which is scrubbed.
     * </pre>
     *
     * <code>string target_resource = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetResource() {
      targetResource_ = getDefaultInstance().getTargetResource();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Audit resource name which is scrubbed.
     * </pre>
     *
     * <code>string target_resource = 5;</code>
     *
     * @param value The bytes for targetResource to set.
     * @return This builder for chaining.
     */
    public Builder setTargetResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetResource_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.rpc.context.AuditContext)
  }

  // @@protoc_insertion_point(class_scope:google.rpc.context.AuditContext)
  private static final com.google.rpc.context.AuditContext DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.rpc.context.AuditContext();
  }

  public static com.google.rpc.context.AuditContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuditContext> PARSER =
      new com.google.protobuf.AbstractParser<AuditContext>() {
        @java.lang.Override
        public AuditContext parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AuditContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuditContext> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.rpc.context.AuditContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
