/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.5
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * An image that is specified by a URL and can have an `onClick` action. For an
 * example, see [Add an
 * image](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_an_image).
 *
 * [Google Workspace Add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.Image}
 */
public final class Image extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.Image)
    ImageOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Image.newBuilder() to construct.
  private Image(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Image() {
    imageUrl_ = "";
    altText_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Image();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Image_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Image_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.Image.class, com.google.apps.card.v1.Image.Builder.class);
  }

  private int bitField0_;
  public static final int IMAGE_URL_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageUrl_ = "";

  /**
   *
   *
   * <pre>
   * The HTTPS URL that hosts the image.
   *
   * For example:
   *
   * ```
   * https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png
   * ```
   * </pre>
   *
   * <code>string image_url = 1;</code>
   *
   * @return The imageUrl.
   */
  @java.lang.Override
  public java.lang.String getImageUrl() {
    java.lang.Object ref = imageUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUrl_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The HTTPS URL that hosts the image.
   *
   * For example:
   *
   * ```
   * https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png
   * ```
   * </pre>
   *
   * <code>string image_url = 1;</code>
   *
   * @return The bytes for imageUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUrlBytes() {
    java.lang.Object ref = imageUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ON_CLICK_FIELD_NUMBER = 2;
  private com.google.apps.card.v1.OnClick onClick_;

  /**
   *
   *
   * <pre>
   * When a user clicks the image, the click triggers this action.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
   *
   * @return Whether the onClick field is set.
   */
  @java.lang.Override
  public boolean hasOnClick() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * When a user clicks the image, the click triggers this action.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
   *
   * @return The onClick.
   */
  @java.lang.Override
  public com.google.apps.card.v1.OnClick getOnClick() {
    return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
  }

  /**
   *
   *
   * <pre>
   * When a user clicks the image, the click triggers this action.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
    return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
  }

  public static final int ALT_TEXT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object altText_ = "";

  /**
   *
   *
   * <pre>
   * The alternative text of this image that's used for accessibility.
   * </pre>
   *
   * <code>string alt_text = 3;</code>
   *
   * @return The altText.
   */
  @java.lang.Override
  public java.lang.String getAltText() {
    java.lang.Object ref = altText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      altText_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The alternative text of this image that's used for accessibility.
   * </pre>
   *
   * <code>string alt_text = 3;</code>
   *
   * @return The bytes for altText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAltTextBytes() {
    java.lang.Object ref = altText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      altText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageUrl_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getOnClick());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(altText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, altText_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageUrl_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOnClick());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(altText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, altText_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.Image)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.Image other = (com.google.apps.card.v1.Image) obj;

    if (!getImageUrl().equals(other.getImageUrl())) return false;
    if (hasOnClick() != other.hasOnClick()) return false;
    if (hasOnClick()) {
      if (!getOnClick().equals(other.getOnClick())) return false;
    }
    if (!getAltText().equals(other.getAltText())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMAGE_URL_FIELD_NUMBER;
    hash = (53 * hash) + getImageUrl().hashCode();
    if (hasOnClick()) {
      hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
      hash = (53 * hash) + getOnClick().hashCode();
    }
    hash = (37 * hash) + ALT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getAltText().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.Image parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Image parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Image parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Image parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Image parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Image parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Image parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Image parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Image parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Image parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Image parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Image parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.Image prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An image that is specified by a URL and can have an `onClick` action. For an
   * example, see [Add an
   * image](https://developers.google.com/workspace/chat/add-text-image-card-dialog#add_an_image).
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Image}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Image)
      com.google.apps.card.v1.ImageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Image_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Image_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Image.class, com.google.apps.card.v1.Image.Builder.class);
    }

    // Construct using com.google.apps.card.v1.Image.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOnClickFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      imageUrl_ = "";
      onClick_ = null;
      if (onClickBuilder_ != null) {
        onClickBuilder_.dispose();
        onClickBuilder_ = null;
      }
      altText_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Image_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Image getDefaultInstanceForType() {
      return com.google.apps.card.v1.Image.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.Image build() {
      com.google.apps.card.v1.Image result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Image buildPartial() {
      com.google.apps.card.v1.Image result = new com.google.apps.card.v1.Image(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.card.v1.Image result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.imageUrl_ = imageUrl_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.altText_ = altText_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.Image) {
        return mergeFrom((com.google.apps.card.v1.Image) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.Image other) {
      if (other == com.google.apps.card.v1.Image.getDefaultInstance()) return this;
      if (!other.getImageUrl().isEmpty()) {
        imageUrl_ = other.imageUrl_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasOnClick()) {
        mergeOnClick(other.getOnClick());
      }
      if (!other.getAltText().isEmpty()) {
        altText_ = other.altText_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                imageUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOnClickFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                altText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object imageUrl_ = "";

    /**
     *
     *
     * <pre>
     * The HTTPS URL that hosts the image.
     *
     * For example:
     *
     * ```
     * https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png
     * ```
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @return The imageUrl.
     */
    public java.lang.String getImageUrl() {
      java.lang.Object ref = imageUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The HTTPS URL that hosts the image.
     *
     * For example:
     *
     * ```
     * https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png
     * ```
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @return The bytes for imageUrl.
     */
    public com.google.protobuf.ByteString getImageUrlBytes() {
      java.lang.Object ref = imageUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The HTTPS URL that hosts the image.
     *
     * For example:
     *
     * ```
     * https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png
     * ```
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @param value The imageUrl to set.
     * @return This builder for chaining.
     */
    public Builder setImageUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageUrl_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The HTTPS URL that hosts the image.
     *
     * For example:
     *
     * ```
     * https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png
     * ```
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUrl() {
      imageUrl_ = getDefaultInstance().getImageUrl();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The HTTPS URL that hosts the image.
     *
     * For example:
     *
     * ```
     * https://developers.google.com/workspace/chat/images/quickstart-app-avatar.png
     * ```
     * </pre>
     *
     * <code>string image_url = 1;</code>
     *
     * @param value The bytes for imageUrl to set.
     * @return This builder for chaining.
     */
    public Builder setImageUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageUrl_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.apps.card.v1.OnClick onClick_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.OnClick,
            com.google.apps.card.v1.OnClick.Builder,
            com.google.apps.card.v1.OnClickOrBuilder>
        onClickBuilder_;

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     *
     * @return Whether the onClick field is set.
     */
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     *
     * @return The onClick.
     */
    public com.google.apps.card.v1.OnClick getOnClick() {
      if (onClickBuilder_ == null) {
        return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
      } else {
        return onClickBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    public Builder setOnClick(com.google.apps.card.v1.OnClick value) {
      if (onClickBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        onClick_ = value;
      } else {
        onClickBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    public Builder setOnClick(com.google.apps.card.v1.OnClick.Builder builderForValue) {
      if (onClickBuilder_ == null) {
        onClick_ = builderForValue.build();
      } else {
        onClickBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    public Builder mergeOnClick(com.google.apps.card.v1.OnClick value) {
      if (onClickBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && onClick_ != null
            && onClick_ != com.google.apps.card.v1.OnClick.getDefaultInstance()) {
          getOnClickBuilder().mergeFrom(value);
        } else {
          onClick_ = value;
        }
      } else {
        onClickBuilder_.mergeFrom(value);
      }
      if (onClick_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    public Builder clearOnClick() {
      bitField0_ = (bitField0_ & ~0x00000002);
      onClick_ = null;
      if (onClickBuilder_ != null) {
        onClickBuilder_.dispose();
        onClickBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    public com.google.apps.card.v1.OnClick.Builder getOnClickBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getOnClickFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
      if (onClickBuilder_ != null) {
        return onClickBuilder_.getMessageOrBuilder();
      } else {
        return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
      }
    }

    /**
     *
     *
     * <pre>
     * When a user clicks the image, the click triggers this action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.OnClick,
            com.google.apps.card.v1.OnClick.Builder,
            com.google.apps.card.v1.OnClickOrBuilder>
        getOnClickFieldBuilder() {
      if (onClickBuilder_ == null) {
        onClickBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.OnClick,
                com.google.apps.card.v1.OnClick.Builder,
                com.google.apps.card.v1.OnClickOrBuilder>(
                getOnClick(), getParentForChildren(), isClean());
        onClick_ = null;
      }
      return onClickBuilder_;
    }

    private java.lang.Object altText_ = "";

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @return The altText.
     */
    public java.lang.String getAltText() {
      java.lang.Object ref = altText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        altText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @return The bytes for altText.
     */
    public com.google.protobuf.ByteString getAltTextBytes() {
      java.lang.Object ref = altText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        altText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @param value The altText to set.
     * @return This builder for chaining.
     */
    public Builder setAltText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      altText_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAltText() {
      altText_ = getDefaultInstance().getAltText();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The alternative text of this image that's used for accessibility.
     * </pre>
     *
     * <code>string alt_text = 3;</code>
     *
     * @param value The bytes for altText to set.
     * @return This builder for chaining.
     */
    public Builder setAltTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      altText_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Image)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.Image)
  private static final com.google.apps.card.v1.Image DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.Image();
  }

  public static com.google.apps.card.v1.Image getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Image> PARSER =
      new com.google.protobuf.AbstractParser<Image>() {
        @java.lang.Override
        public Image parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Image> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Image> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.Image getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
