/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.3
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * An action that describes the behavior when the form is submitted.
 * For example, you can invoke an Apps Script script to handle the form.
 * If the action is triggered, the form values are sent to the server.
 *
 * [Google Workspace Add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.Action}
 */
public final class Action extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.Action)
    ActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Action.newBuilder() to construct.
  private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Action() {
    function_ = "";
    parameters_ = java.util.Collections.emptyList();
    loadIndicator_ = 0;
    interaction_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Action();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Action_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Action_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.Action.class, com.google.apps.card.v1.Action.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the loading indicator that the action displays while
   * making the call to the action.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.Action.LoadIndicator}
   */
  public enum LoadIndicator implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Displays a spinner to indicate that content is loading.
     * </pre>
     *
     * <code>SPINNER = 0;</code>
     */
    SPINNER(0),
    /**
     *
     *
     * <pre>
     * Nothing is displayed.
     * </pre>
     *
     * <code>NONE = 1;</code>
     */
    NONE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Displays a spinner to indicate that content is loading.
     * </pre>
     *
     * <code>SPINNER = 0;</code>
     */
    public static final int SPINNER_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Nothing is displayed.
     * </pre>
     *
     * <code>NONE = 1;</code>
     */
    public static final int NONE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LoadIndicator valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LoadIndicator forNumber(int value) {
      switch (value) {
        case 0:
          return SPINNER;
        case 1:
          return NONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LoadIndicator> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LoadIndicator> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LoadIndicator>() {
          public LoadIndicator findValueByNumber(int number) {
            return LoadIndicator.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.Action.getDescriptor().getEnumTypes().get(0);
    }

    private static final LoadIndicator[] VALUES = values();

    public static LoadIndicator valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LoadIndicator(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.Action.LoadIndicator)
  }

  /**
   *
   *
   * <pre>
   * Optional. Required when opening a
   * [dialog](https://developers.google.com/workspace/chat/dialogs).
   *
   * What to do in response to an interaction with a user, such as a user
   * clicking a button in a card message.
   *
   * If unspecified, the app responds by executing an `action`—like opening a
   * link or running a function—as normal.
   *
   * By specifying an `interaction`, the app can respond in special interactive
   * ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
   * open a [dialog](https://developers.google.com/workspace/chat/dialogs).
   *
   * When specified, a loading indicator isn't shown. If specified for
   * an add-on, the entire card is stripped and nothing is shown in the client.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.Action.Interaction}
   */
  public enum Interaction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. The `action` executes as normal.
     * </pre>
     *
     * <code>INTERACTION_UNSPECIFIED = 0;</code>
     */
    INTERACTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Opens a [dialog](https://developers.google.com/workspace/chat/dialogs), a
     * windowed, card-based interface that Chat apps use to interact with users.
     *
     * Only supported by Chat apps in response to button-clicks on card
     * messages. If specified for
     * an add-on, the entire card is stripped and nothing is shown in the
     * client.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>OPEN_DIALOG = 1;</code>
     */
    OPEN_DIALOG(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. The `action` executes as normal.
     * </pre>
     *
     * <code>INTERACTION_UNSPECIFIED = 0;</code>
     */
    public static final int INTERACTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Opens a [dialog](https://developers.google.com/workspace/chat/dialogs), a
     * windowed, card-based interface that Chat apps use to interact with users.
     *
     * Only supported by Chat apps in response to button-clicks on card
     * messages. If specified for
     * an add-on, the entire card is stripped and nothing is shown in the
     * client.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>OPEN_DIALOG = 1;</code>
     */
    public static final int OPEN_DIALOG_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Interaction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Interaction forNumber(int value) {
      switch (value) {
        case 0:
          return INTERACTION_UNSPECIFIED;
        case 1:
          return OPEN_DIALOG;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Interaction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Interaction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Interaction>() {
          public Interaction findValueByNumber(int number) {
            return Interaction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.Action.getDescriptor().getEnumTypes().get(1);
    }

    private static final Interaction[] VALUES = values();

    public static Interaction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Interaction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.Action.Interaction)
  }

  public interface ActionParameterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Action.ActionParameter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the parameter for the action script.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * The name of the parameter for the action script.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * The value of the parameter.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * The value of the parameter.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();
  }
  /**
   *
   *
   * <pre>
   * List of string parameters to supply when the action method is invoked.
   * For example, consider three snooze buttons: snooze now, snooze one day,
   * or snooze next week. You might use `action method = snooze()`, passing the
   * snooze type and snooze time in the list of string parameters.
   *
   * To learn more, see
   * [`CommonEventObject`](https://developers.google.com/workspace/chat/api/reference/rest/v1/Event#commoneventobject).
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Action.ActionParameter}
   */
  public static final class ActionParameter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.Action.ActionParameter)
      ActionParameterOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ActionParameter.newBuilder() to construct.
    private ActionParameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ActionParameter() {
      key_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ActionParameter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Action_ActionParameter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Action_ActionParameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Action.ActionParameter.class,
              com.google.apps.card.v1.Action.ActionParameter.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * The name of the parameter for the action script.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the parameter for the action script.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object value_ = "";
    /**
     *
     *
     * <pre>
     * The value of the parameter.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of the parameter.
     * </pre>
     *
     * <code>string value = 2;</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.Action.ActionParameter)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.Action.ActionParameter other =
          (com.google.apps.card.v1.Action.ActionParameter) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Action.ActionParameter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.apps.card.v1.Action.ActionParameter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * List of string parameters to supply when the action method is invoked.
     * For example, consider three snooze buttons: snooze now, snooze one day,
     * or snooze next week. You might use `action method = snooze()`, passing the
     * snooze type and snooze time in the list of string parameters.
     *
     * To learn more, see
     * [`CommonEventObject`](https://developers.google.com/workspace/chat/api/reference/rest/v1/Event#commoneventobject).
     *
     * [Google Workspace Add-ons and Chat
     * apps](https://developers.google.com/workspace/extend):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.Action.ActionParameter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Action.ActionParameter)
        com.google.apps.card.v1.Action.ActionParameterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Action_ActionParameter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Action_ActionParameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.Action.ActionParameter.class,
                com.google.apps.card.v1.Action.ActionParameter.Builder.class);
      }

      // Construct using com.google.apps.card.v1.Action.ActionParameter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        key_ = "";
        value_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Action_ActionParameter_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Action.ActionParameter getDefaultInstanceForType() {
        return com.google.apps.card.v1.Action.ActionParameter.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.Action.ActionParameter build() {
        com.google.apps.card.v1.Action.ActionParameter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Action.ActionParameter buildPartial() {
        com.google.apps.card.v1.Action.ActionParameter result =
            new com.google.apps.card.v1.Action.ActionParameter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.apps.card.v1.Action.ActionParameter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.key_ = key_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.Action.ActionParameter) {
          return mergeFrom((com.google.apps.card.v1.Action.ActionParameter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.Action.ActionParameter other) {
        if (other == com.google.apps.card.v1.Action.ActionParameter.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  key_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  value_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        key_ = getDefaultInstance().getKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the parameter for the action script.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = getDefaultInstance().getValue();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value of the parameter.
       * </pre>
       *
       * <code>string value = 2;</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        value_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Action.ActionParameter)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.Action.ActionParameter)
    private static final com.google.apps.card.v1.Action.ActionParameter DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.Action.ActionParameter();
    }

    public static com.google.apps.card.v1.Action.ActionParameter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ActionParameter> PARSER =
        new com.google.protobuf.AbstractParser<ActionParameter>() {
          @java.lang.Override
          public ActionParameter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ActionParameter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ActionParameter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Action.ActionParameter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FUNCTION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object function_ = "";
  /**
   *
   *
   * <pre>
   * A custom function to invoke when the containing element is
   * clicked or othrwise activated.
   *
   * For example usage, see [Read form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string function = 1;</code>
   *
   * @return The function.
   */
  @java.lang.Override
  public java.lang.String getFunction() {
    java.lang.Object ref = function_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      function_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A custom function to invoke when the containing element is
   * clicked or othrwise activated.
   *
   * For example usage, see [Read form
   * data](https://developers.google.com/workspace/chat/read-form-data).
   * </pre>
   *
   * <code>string function = 1;</code>
   *
   * @return The bytes for function.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFunctionBytes() {
    java.lang.Object ref = function_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      function_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.apps.card.v1.Action.ActionParameter> parameters_;
  /**
   *
   *
   * <pre>
   * List of action parameters.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.apps.card.v1.Action.ActionParameter> getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * List of action parameters.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.apps.card.v1.Action.ActionParameterOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * List of action parameters.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * List of action parameters.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action.ActionParameter getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of action parameters.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action.ActionParameterOrBuilder getParametersOrBuilder(int index) {
    return parameters_.get(index);
  }

  public static final int LOAD_INDICATOR_FIELD_NUMBER = 3;
  private int loadIndicator_ = 0;
  /**
   *
   *
   * <pre>
   * Specifies the loading indicator that the action displays while
   * making the call to the action.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action.LoadIndicator load_indicator = 3;</code>
   *
   * @return The enum numeric value on the wire for loadIndicator.
   */
  @java.lang.Override
  public int getLoadIndicatorValue() {
    return loadIndicator_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the loading indicator that the action displays while
   * making the call to the action.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action.LoadIndicator load_indicator = 3;</code>
   *
   * @return The loadIndicator.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action.LoadIndicator getLoadIndicator() {
    com.google.apps.card.v1.Action.LoadIndicator result =
        com.google.apps.card.v1.Action.LoadIndicator.forNumber(loadIndicator_);
    return result == null ? com.google.apps.card.v1.Action.LoadIndicator.UNRECOGNIZED : result;
  }

  public static final int PERSIST_VALUES_FIELD_NUMBER = 4;
  private boolean persistValues_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether form values persist after the action. The default value
   * is `false`.
   *
   * If `true`, form values remain after the action is triggered. To let the
   * user make changes while the action is being processed, set
   * [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
   * to `NONE`. For [card
   * messages](https://developers.google.com/workspace/chat/api/guides/v1/messages/create#create)
   * in Chat apps, you must also set the action's
   * [`ResponseType`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#responsetype)
   * to `UPDATE_MESSAGE` and use the same
   * [`card_id`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#CardWithId)
   * from the card that contained the action.
   *
   * If `false`, the form values are cleared when the action is triggered.
   * To prevent the user from making changes while the action is being
   * processed, set
   * [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
   * to `SPINNER`.
   * </pre>
   *
   * <code>bool persist_values = 4;</code>
   *
   * @return The persistValues.
   */
  @java.lang.Override
  public boolean getPersistValues() {
    return persistValues_;
  }

  public static final int INTERACTION_FIELD_NUMBER = 5;
  private int interaction_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Required when opening a
   * [dialog](https://developers.google.com/workspace/chat/dialogs).
   *
   * What to do in response to an interaction with a user, such as a user
   * clicking a button in a card message.
   *
   * If unspecified, the app responds by executing an `action`—like opening a
   * link or running a function—as normal.
   *
   * By specifying an `interaction`, the app can respond in special interactive
   * ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
   * open a [dialog](https://developers.google.com/workspace/chat/dialogs). When
   * specified, a loading indicator isn't shown. If specified for
   * an add-on, the entire card is stripped and nothing is shown in the client.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action.Interaction interaction = 5;</code>
   *
   * @return The enum numeric value on the wire for interaction.
   */
  @java.lang.Override
  public int getInteractionValue() {
    return interaction_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Required when opening a
   * [dialog](https://developers.google.com/workspace/chat/dialogs).
   *
   * What to do in response to an interaction with a user, such as a user
   * clicking a button in a card message.
   *
   * If unspecified, the app responds by executing an `action`—like opening a
   * link or running a function—as normal.
   *
   * By specifying an `interaction`, the app can respond in special interactive
   * ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
   * open a [dialog](https://developers.google.com/workspace/chat/dialogs). When
   * specified, a loading indicator isn't shown. If specified for
   * an add-on, the entire card is stripped and nothing is shown in the client.
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action.Interaction interaction = 5;</code>
   *
   * @return The interaction.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action.Interaction getInteraction() {
    com.google.apps.card.v1.Action.Interaction result =
        com.google.apps.card.v1.Action.Interaction.forNumber(interaction_);
    return result == null ? com.google.apps.card.v1.Action.Interaction.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(function_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, function_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(2, parameters_.get(i));
    }
    if (loadIndicator_ != com.google.apps.card.v1.Action.LoadIndicator.SPINNER.getNumber()) {
      output.writeEnum(3, loadIndicator_);
    }
    if (persistValues_ != false) {
      output.writeBool(4, persistValues_);
    }
    if (interaction_
        != com.google.apps.card.v1.Action.Interaction.INTERACTION_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, interaction_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(function_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, function_);
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameters_.get(i));
    }
    if (loadIndicator_ != com.google.apps.card.v1.Action.LoadIndicator.SPINNER.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, loadIndicator_);
    }
    if (persistValues_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, persistValues_);
    }
    if (interaction_
        != com.google.apps.card.v1.Action.Interaction.INTERACTION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, interaction_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.Action)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.Action other = (com.google.apps.card.v1.Action) obj;

    if (!getFunction().equals(other.getFunction())) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (loadIndicator_ != other.loadIndicator_) return false;
    if (getPersistValues() != other.getPersistValues()) return false;
    if (interaction_ != other.interaction_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FUNCTION_FIELD_NUMBER;
    hash = (53 * hash) + getFunction().hashCode();
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (37 * hash) + LOAD_INDICATOR_FIELD_NUMBER;
    hash = (53 * hash) + loadIndicator_;
    hash = (37 * hash) + PERSIST_VALUES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPersistValues());
    hash = (37 * hash) + INTERACTION_FIELD_NUMBER;
    hash = (53 * hash) + interaction_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.Action parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Action parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Action parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Action parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Action parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Action parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Action parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Action parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Action parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Action parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Action parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Action parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.Action prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An action that describes the behavior when the form is submitted.
   * For example, you can invoke an Apps Script script to handle the form.
   * If the action is triggered, the form values are sent to the server.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Action}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Action)
      com.google.apps.card.v1.ActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Action_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Action.class, com.google.apps.card.v1.Action.Builder.class);
    }

    // Construct using com.google.apps.card.v1.Action.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      function_ = "";
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      loadIndicator_ = 0;
      persistValues_ = false;
      interaction_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Action_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Action getDefaultInstanceForType() {
      return com.google.apps.card.v1.Action.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.Action build() {
      com.google.apps.card.v1.Action result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Action buildPartial() {
      com.google.apps.card.v1.Action result = new com.google.apps.card.v1.Action(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.apps.card.v1.Action result) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.apps.card.v1.Action result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.function_ = function_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.loadIndicator_ = loadIndicator_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.persistValues_ = persistValues_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.interaction_ = interaction_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.Action) {
        return mergeFrom((com.google.apps.card.v1.Action) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.Action other) {
      if (other == com.google.apps.card.v1.Action.getDefaultInstance()) return this;
      if (!other.getFunction().isEmpty()) {
        function_ = other.function_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000002);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (other.loadIndicator_ != 0) {
        setLoadIndicatorValue(other.getLoadIndicatorValue());
      }
      if (other.getPersistValues() != false) {
        setPersistValues(other.getPersistValues());
      }
      if (other.interaction_ != 0) {
        setInteractionValue(other.getInteractionValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                function_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.apps.card.v1.Action.ActionParameter m =
                    input.readMessage(
                        com.google.apps.card.v1.Action.ActionParameter.parser(), extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                loadIndicator_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                persistValues_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                interaction_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object function_ = "";
    /**
     *
     *
     * <pre>
     * A custom function to invoke when the containing element is
     * clicked or othrwise activated.
     *
     * For example usage, see [Read form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @return The function.
     */
    public java.lang.String getFunction() {
      java.lang.Object ref = function_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        function_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A custom function to invoke when the containing element is
     * clicked or othrwise activated.
     *
     * For example usage, see [Read form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @return The bytes for function.
     */
    public com.google.protobuf.ByteString getFunctionBytes() {
      java.lang.Object ref = function_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        function_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A custom function to invoke when the containing element is
     * clicked or othrwise activated.
     *
     * For example usage, see [Read form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @param value The function to set.
     * @return This builder for chaining.
     */
    public Builder setFunction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      function_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A custom function to invoke when the containing element is
     * clicked or othrwise activated.
     *
     * For example usage, see [Read form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFunction() {
      function_ = getDefaultInstance().getFunction();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A custom function to invoke when the containing element is
     * clicked or othrwise activated.
     *
     * For example usage, see [Read form
     * data](https://developers.google.com/workspace/chat/read-form-data).
     * </pre>
     *
     * <code>string function = 1;</code>
     *
     * @param value The bytes for function to set.
     * @return This builder for chaining.
     */
    public Builder setFunctionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      function_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.apps.card.v1.Action.ActionParameter> parameters_ =
        java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.apps.card.v1.Action.ActionParameter>(parameters_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.Action.ActionParameter,
            com.google.apps.card.v1.Action.ActionParameter.Builder,
            com.google.apps.card.v1.Action.ActionParameterOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public java.util.List<com.google.apps.card.v1.Action.ActionParameter> getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public com.google.apps.card.v1.Action.ActionParameter getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder setParameters(int index, com.google.apps.card.v1.Action.ActionParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder setParameters(
        int index, com.google.apps.card.v1.Action.ActionParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder addParameters(com.google.apps.card.v1.Action.ActionParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder addParameters(int index, com.google.apps.card.v1.Action.ActionParameter value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder addParameters(
        com.google.apps.card.v1.Action.ActionParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder addParameters(
        int index, com.google.apps.card.v1.Action.ActionParameter.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.apps.card.v1.Action.ActionParameter> values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public com.google.apps.card.v1.Action.ActionParameter.Builder getParametersBuilder(int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public com.google.apps.card.v1.Action.ActionParameterOrBuilder getParametersOrBuilder(
        int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public java.util.List<? extends com.google.apps.card.v1.Action.ActionParameterOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public com.google.apps.card.v1.Action.ActionParameter.Builder addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(com.google.apps.card.v1.Action.ActionParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public com.google.apps.card.v1.Action.ActionParameter.Builder addParametersBuilder(int index) {
      return getParametersFieldBuilder()
          .addBuilder(index, com.google.apps.card.v1.Action.ActionParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of action parameters.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Action.ActionParameter parameters = 2;</code>
     */
    public java.util.List<com.google.apps.card.v1.Action.ActionParameter.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.Action.ActionParameter,
            com.google.apps.card.v1.Action.ActionParameter.Builder,
            com.google.apps.card.v1.Action.ActionParameterOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.apps.card.v1.Action.ActionParameter,
                com.google.apps.card.v1.Action.ActionParameter.Builder,
                com.google.apps.card.v1.Action.ActionParameterOrBuilder>(
                parameters_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private int loadIndicator_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies the loading indicator that the action displays while
     * making the call to the action.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.LoadIndicator load_indicator = 3;</code>
     *
     * @return The enum numeric value on the wire for loadIndicator.
     */
    @java.lang.Override
    public int getLoadIndicatorValue() {
      return loadIndicator_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the loading indicator that the action displays while
     * making the call to the action.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.LoadIndicator load_indicator = 3;</code>
     *
     * @param value The enum numeric value on the wire for loadIndicator to set.
     * @return This builder for chaining.
     */
    public Builder setLoadIndicatorValue(int value) {
      loadIndicator_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the loading indicator that the action displays while
     * making the call to the action.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.LoadIndicator load_indicator = 3;</code>
     *
     * @return The loadIndicator.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Action.LoadIndicator getLoadIndicator() {
      com.google.apps.card.v1.Action.LoadIndicator result =
          com.google.apps.card.v1.Action.LoadIndicator.forNumber(loadIndicator_);
      return result == null ? com.google.apps.card.v1.Action.LoadIndicator.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Specifies the loading indicator that the action displays while
     * making the call to the action.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.LoadIndicator load_indicator = 3;</code>
     *
     * @param value The loadIndicator to set.
     * @return This builder for chaining.
     */
    public Builder setLoadIndicator(com.google.apps.card.v1.Action.LoadIndicator value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      loadIndicator_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the loading indicator that the action displays while
     * making the call to the action.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.LoadIndicator load_indicator = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoadIndicator() {
      bitField0_ = (bitField0_ & ~0x00000004);
      loadIndicator_ = 0;
      onChanged();
      return this;
    }

    private boolean persistValues_;
    /**
     *
     *
     * <pre>
     * Indicates whether form values persist after the action. The default value
     * is `false`.
     *
     * If `true`, form values remain after the action is triggered. To let the
     * user make changes while the action is being processed, set
     * [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
     * to `NONE`. For [card
     * messages](https://developers.google.com/workspace/chat/api/guides/v1/messages/create#create)
     * in Chat apps, you must also set the action's
     * [`ResponseType`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#responsetype)
     * to `UPDATE_MESSAGE` and use the same
     * [`card_id`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#CardWithId)
     * from the card that contained the action.
     *
     * If `false`, the form values are cleared when the action is triggered.
     * To prevent the user from making changes while the action is being
     * processed, set
     * [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
     * to `SPINNER`.
     * </pre>
     *
     * <code>bool persist_values = 4;</code>
     *
     * @return The persistValues.
     */
    @java.lang.Override
    public boolean getPersistValues() {
      return persistValues_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether form values persist after the action. The default value
     * is `false`.
     *
     * If `true`, form values remain after the action is triggered. To let the
     * user make changes while the action is being processed, set
     * [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
     * to `NONE`. For [card
     * messages](https://developers.google.com/workspace/chat/api/guides/v1/messages/create#create)
     * in Chat apps, you must also set the action's
     * [`ResponseType`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#responsetype)
     * to `UPDATE_MESSAGE` and use the same
     * [`card_id`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#CardWithId)
     * from the card that contained the action.
     *
     * If `false`, the form values are cleared when the action is triggered.
     * To prevent the user from making changes while the action is being
     * processed, set
     * [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
     * to `SPINNER`.
     * </pre>
     *
     * <code>bool persist_values = 4;</code>
     *
     * @param value The persistValues to set.
     * @return This builder for chaining.
     */
    public Builder setPersistValues(boolean value) {

      persistValues_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether form values persist after the action. The default value
     * is `false`.
     *
     * If `true`, form values remain after the action is triggered. To let the
     * user make changes while the action is being processed, set
     * [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
     * to `NONE`. For [card
     * messages](https://developers.google.com/workspace/chat/api/guides/v1/messages/create#create)
     * in Chat apps, you must also set the action's
     * [`ResponseType`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#responsetype)
     * to `UPDATE_MESSAGE` and use the same
     * [`card_id`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages#CardWithId)
     * from the card that contained the action.
     *
     * If `false`, the form values are cleared when the action is triggered.
     * To prevent the user from making changes while the action is being
     * processed, set
     * [`LoadIndicator`](https://developers.google.com/workspace/add-ons/reference/rpc/google.apps.card.v1#loadindicator)
     * to `SPINNER`.
     * </pre>
     *
     * <code>bool persist_values = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPersistValues() {
      bitField0_ = (bitField0_ & ~0x00000008);
      persistValues_ = false;
      onChanged();
      return this;
    }

    private int interaction_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Required when opening a
     * [dialog](https://developers.google.com/workspace/chat/dialogs).
     *
     * What to do in response to an interaction with a user, such as a user
     * clicking a button in a card message.
     *
     * If unspecified, the app responds by executing an `action`—like opening a
     * link or running a function—as normal.
     *
     * By specifying an `interaction`, the app can respond in special interactive
     * ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
     * open a [dialog](https://developers.google.com/workspace/chat/dialogs). When
     * specified, a loading indicator isn't shown. If specified for
     * an add-on, the entire card is stripped and nothing is shown in the client.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.Interaction interaction = 5;</code>
     *
     * @return The enum numeric value on the wire for interaction.
     */
    @java.lang.Override
    public int getInteractionValue() {
      return interaction_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required when opening a
     * [dialog](https://developers.google.com/workspace/chat/dialogs).
     *
     * What to do in response to an interaction with a user, such as a user
     * clicking a button in a card message.
     *
     * If unspecified, the app responds by executing an `action`—like opening a
     * link or running a function—as normal.
     *
     * By specifying an `interaction`, the app can respond in special interactive
     * ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
     * open a [dialog](https://developers.google.com/workspace/chat/dialogs). When
     * specified, a loading indicator isn't shown. If specified for
     * an add-on, the entire card is stripped and nothing is shown in the client.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.Interaction interaction = 5;</code>
     *
     * @param value The enum numeric value on the wire for interaction to set.
     * @return This builder for chaining.
     */
    public Builder setInteractionValue(int value) {
      interaction_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required when opening a
     * [dialog](https://developers.google.com/workspace/chat/dialogs).
     *
     * What to do in response to an interaction with a user, such as a user
     * clicking a button in a card message.
     *
     * If unspecified, the app responds by executing an `action`—like opening a
     * link or running a function—as normal.
     *
     * By specifying an `interaction`, the app can respond in special interactive
     * ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
     * open a [dialog](https://developers.google.com/workspace/chat/dialogs). When
     * specified, a loading indicator isn't shown. If specified for
     * an add-on, the entire card is stripped and nothing is shown in the client.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.Interaction interaction = 5;</code>
     *
     * @return The interaction.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Action.Interaction getInteraction() {
      com.google.apps.card.v1.Action.Interaction result =
          com.google.apps.card.v1.Action.Interaction.forNumber(interaction_);
      return result == null ? com.google.apps.card.v1.Action.Interaction.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required when opening a
     * [dialog](https://developers.google.com/workspace/chat/dialogs).
     *
     * What to do in response to an interaction with a user, such as a user
     * clicking a button in a card message.
     *
     * If unspecified, the app responds by executing an `action`—like opening a
     * link or running a function—as normal.
     *
     * By specifying an `interaction`, the app can respond in special interactive
     * ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
     * open a [dialog](https://developers.google.com/workspace/chat/dialogs). When
     * specified, a loading indicator isn't shown. If specified for
     * an add-on, the entire card is stripped and nothing is shown in the client.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.Interaction interaction = 5;</code>
     *
     * @param value The interaction to set.
     * @return This builder for chaining.
     */
    public Builder setInteraction(com.google.apps.card.v1.Action.Interaction value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      interaction_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required when opening a
     * [dialog](https://developers.google.com/workspace/chat/dialogs).
     *
     * What to do in response to an interaction with a user, such as a user
     * clicking a button in a card message.
     *
     * If unspecified, the app responds by executing an `action`—like opening a
     * link or running a function—as normal.
     *
     * By specifying an `interaction`, the app can respond in special interactive
     * ways. For example, by setting `interaction` to `OPEN_DIALOG`, the app can
     * open a [dialog](https://developers.google.com/workspace/chat/dialogs). When
     * specified, a loading indicator isn't shown. If specified for
     * an add-on, the entire card is stripped and nothing is shown in the client.
     *
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action.Interaction interaction = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInteraction() {
      bitField0_ = (bitField0_ & ~0x00000010);
      interaction_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Action)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.Action)
  private static final com.google.apps.card.v1.Action DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.Action();
  }

  public static com.google.apps.card.v1.Action getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Action> PARSER =
      new com.google.protobuf.AbstractParser<Action>() {
        @java.lang.Override
        public Action parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Action> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Action> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.Action getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
