/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/error_reason.proto

// Protobuf Java Version: 3.25.3
package com.google.api;

/**
 *
 *
 * <pre>
 * Defines the supported values for `google.rpc.ErrorInfo.reason` for the
 * `googleapis.com` error domain. This error domain is reserved for [Service
 * Infrastructure](https://cloud.google.com/service-infrastructure/docs/overview).
 * For each error info of this domain, the metadata key "service" refers to the
 * logical identifier of an API service, such as "pubsub.googleapis.com". The
 * "consumer" refers to the entity that consumes an API Service. It typically is
 * a Google project that owns the client application or the server resource,
 * such as "projects/123". Other metadata keys are specific to each error
 * reason. For more information, see the definition of the specific error
 * reason.
 * </pre>
 *
 * Protobuf enum {@code google.api.ErrorReason}
 */
public enum ErrorReason implements com.google.protobuf.ProtocolMessageEnum {
  /**
   *
   *
   * <pre>
   * Do not use this default value.
   * </pre>
   *
   * <code>ERROR_REASON_UNSPECIFIED = 0;</code>
   */
  ERROR_REASON_UNSPECIFIED(0),
  /**
   *
   *
   * <pre>
   * The request is calling a disabled service for a consumer.
   *
   * Example of an ErrorInfo when the consumer "projects/123" contacting
   * "pubsub.googleapis.com" service which is disabled:
   *
   *     { "reason": "SERVICE_DISABLED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com"
   *       }
   *     }
   *
   * This response indicates the "pubsub.googleapis.com" has been disabled in
   * "projects/123".
   * </pre>
   *
   * <code>SERVICE_DISABLED = 1;</code>
   */
  SERVICE_DISABLED(1),
  /**
   *
   *
   * <pre>
   * The request whose associated billing account is disabled.
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to contact
   * "pubsub.googleapis.com" service because the associated billing account is
   * disabled:
   *
   *     { "reason": "BILLING_DISABLED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com"
   *       }
   *     }
   *
   * This response indicates the billing account associated has been disabled.
   * </pre>
   *
   * <code>BILLING_DISABLED = 2;</code>
   */
  BILLING_DISABLED(2),
  /**
   *
   *
   * <pre>
   * The request is denied because the provided [API
   * key](https://cloud.google.com/docs/authentication/api-keys) is invalid. It
   * may be in a bad format, cannot be found, or has been expired).
   *
   * Example of an ErrorInfo when the request is contacting
   * "storage.googleapis.com" service with an invalid API key:
   *
   *     { "reason": "API_KEY_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_INVALID = 3;</code>
   */
  API_KEY_INVALID(3),
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key API
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_api_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call the
   * "storage.googleapis.com" service because this service is restricted in the
   * API key:
   *
   *     { "reason": "API_KEY_SERVICE_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_SERVICE_BLOCKED = 4;</code>
   */
  API_KEY_SERVICE_BLOCKED(4),
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key HTTP
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_http_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * "storage.googleapis.com" service because the http referrer of the request
   * violates API key HTTP restrictions:
   *
   *     { "reason": "API_KEY_HTTP_REFERRER_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com",
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_HTTP_REFERRER_BLOCKED = 7;</code>
   */
  API_KEY_HTTP_REFERRER_BLOCKED(7),
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key IP address
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_application_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * "storage.googleapis.com" service because the caller IP of the request
   * violates API key IP address restrictions:
   *
   *     { "reason": "API_KEY_IP_ADDRESS_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com",
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_IP_ADDRESS_BLOCKED = 8;</code>
   */
  API_KEY_IP_ADDRESS_BLOCKED(8),
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key Android application
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_application_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * "storage.googleapis.com" service because the request from the Android apps
   * violates the API key Android application restrictions:
   *
   *     { "reason": "API_KEY_ANDROID_APP_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_ANDROID_APP_BLOCKED = 9;</code>
   */
  API_KEY_ANDROID_APP_BLOCKED(9),
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key iOS application
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_application_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * "storage.googleapis.com" service because the request from the iOS apps
   * violates the API key iOS application restrictions:
   *
   *     { "reason": "API_KEY_IOS_APP_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_IOS_APP_BLOCKED = 13;</code>
   */
  API_KEY_IOS_APP_BLOCKED(13),
  /**
   *
   *
   * <pre>
   * The request is denied because there is not enough rate quota for the
   * consumer.
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to contact
   * "pubsub.googleapis.com" service because consumer's rate quota usage has
   * reached the maximum value set for the quota limit
   * "ReadsPerMinutePerProject" on the quota metric
   * "pubsub.googleapis.com/read_requests":
   *
   *     { "reason": "RATE_LIMIT_EXCEEDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com",
   *         "quota_metric": "pubsub.googleapis.com/read_requests",
   *         "quota_limit": "ReadsPerMinutePerProject"
   *       }
   *     }
   *
   * Example of an ErrorInfo when the consumer "projects/123" checks quota on
   * the service "dataflow.googleapis.com" and hits the organization quota
   * limit "DefaultRequestsPerMinutePerOrganization" on the metric
   * "dataflow.googleapis.com/default_requests".
   *
   *     { "reason": "RATE_LIMIT_EXCEEDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "dataflow.googleapis.com",
   *         "quota_metric": "dataflow.googleapis.com/default_requests",
   *         "quota_limit": "DefaultRequestsPerMinutePerOrganization"
   *       }
   *     }
   * </pre>
   *
   * <code>RATE_LIMIT_EXCEEDED = 5;</code>
   */
  RATE_LIMIT_EXCEEDED(5),
  /**
   *
   *
   * <pre>
   * The request is denied because there is not enough resource quota for the
   * consumer.
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to contact
   * "compute.googleapis.com" service because consumer's resource quota usage
   * has reached the maximum value set for the quota limit "VMsPerProject"
   * on the quota metric "compute.googleapis.com/vms":
   *
   *     { "reason": "RESOURCE_QUOTA_EXCEEDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "compute.googleapis.com",
   *         "quota_metric": "compute.googleapis.com/vms",
   *         "quota_limit": "VMsPerProject"
   *       }
   *     }
   *
   * Example of an ErrorInfo when the consumer "projects/123" checks resource
   * quota on the service "dataflow.googleapis.com" and hits the organization
   * quota limit "jobs-per-organization" on the metric
   * "dataflow.googleapis.com/job_count".
   *
   *     { "reason": "RESOURCE_QUOTA_EXCEEDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "dataflow.googleapis.com",
   *         "quota_metric": "dataflow.googleapis.com/job_count",
   *         "quota_limit": "jobs-per-organization"
   *       }
   *     }
   * </pre>
   *
   * <code>RESOURCE_QUOTA_EXCEEDED = 6;</code>
   */
  RESOURCE_QUOTA_EXCEEDED(6),
  /**
   *
   *
   * <pre>
   * The request whose associated billing account address is in a tax restricted
   * location, violates the local tax restrictions when creating resources in
   * the restricted region.
   *
   * Example of an ErrorInfo when creating the Cloud Storage Bucket in the
   * container "projects/123" under a tax restricted region
   * "locations/asia-northeast3":
   *
   *     { "reason": "LOCATION_TAX_POLICY_VIOLATED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com",
   *         "location": "locations/asia-northeast3"
   *       }
   *     }
   *
   * This response indicates creating the Cloud Storage Bucket in
   * "locations/asia-northeast3" violates the location tax restriction.
   * </pre>
   *
   * <code>LOCATION_TAX_POLICY_VIOLATED = 10;</code>
   */
  LOCATION_TAX_POLICY_VIOLATED(10),
  /**
   *
   *
   * <pre>
   * The request is denied because the caller does not have required permission
   * on the user project "projects/123" or the user project is invalid. For more
   * information, check the [userProject System
   * Parameters](https://cloud.google.com/apis/docs/system-parameters).
   *
   * Example of an ErrorInfo when the caller is calling Cloud Storage service
   * with insufficient permissions on the user project:
   *
   *     { "reason": "USER_PROJECT_DENIED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>USER_PROJECT_DENIED = 11;</code>
   */
  USER_PROJECT_DENIED(11),
  /**
   *
   *
   * <pre>
   * The request is denied because the consumer "projects/123" is suspended due
   * to Terms of Service(Tos) violations. Check [Project suspension
   * guidelines](https://cloud.google.com/resource-manager/docs/project-suspension-guidelines)
   * for more information.
   *
   * Example of an ErrorInfo when calling Cloud Storage service with the
   * suspended consumer "projects/123":
   *
   *     { "reason": "CONSUMER_SUSPENDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>CONSUMER_SUSPENDED = 12;</code>
   */
  CONSUMER_SUSPENDED(12),
  /**
   *
   *
   * <pre>
   * The request is denied because the associated consumer is invalid. It may be
   * in a bad format, cannot be found, or have been deleted.
   *
   * Example of an ErrorInfo when calling Cloud Storage service with the
   * invalid consumer "projects/123":
   *
   *     { "reason": "CONSUMER_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>CONSUMER_INVALID = 14;</code>
   */
  CONSUMER_INVALID(14),
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [VPC Service
   * Controls](https://cloud.google.com/vpc-service-controls/docs/overview).
   * The 'uid' field is a random generated identifier that customer can use it
   * to search the audit log for a request rejected by VPC Service Controls. For
   * more information, please refer [VPC Service Controls
   * Troubleshooting](https://cloud.google.com/vpc-service-controls/docs/troubleshooting#unique-id)
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * Cloud Storage service because the request is prohibited by the VPC Service
   * Controls.
   *
   *     { "reason": "SECURITY_POLICY_VIOLATED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "uid": "123456789abcde",
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>SECURITY_POLICY_VIOLATED = 15;</code>
   */
  SECURITY_POLICY_VIOLATED(15),
  /**
   *
   *
   * <pre>
   * The request is denied because the provided access token has expired.
   *
   * Example of an ErrorInfo when the request is calling Cloud Storage service
   * with an expired access token:
   *
   *     { "reason": "ACCESS_TOKEN_EXPIRED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject"
   *       }
   *     }
   * </pre>
   *
   * <code>ACCESS_TOKEN_EXPIRED = 16;</code>
   */
  ACCESS_TOKEN_EXPIRED(16),
  /**
   *
   *
   * <pre>
   * The request is denied because the provided access token doesn't have at
   * least one of the acceptable scopes required for the API. Please check
   * [OAuth 2.0 Scopes for Google
   * APIs](https://developers.google.com/identity/protocols/oauth2/scopes) for
   * the list of the OAuth 2.0 scopes that you might need to request to access
   * the API.
   *
   * Example of an ErrorInfo when the request is calling Cloud Storage service
   * with an access token that is missing required scopes:
   *
   *     { "reason": "ACCESS_TOKEN_SCOPE_INSUFFICIENT",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject"
   *       }
   *     }
   * </pre>
   *
   * <code>ACCESS_TOKEN_SCOPE_INSUFFICIENT = 17;</code>
   */
  ACCESS_TOKEN_SCOPE_INSUFFICIENT(17),
  /**
   *
   *
   * <pre>
   * The request is denied because the account associated with the provided
   * access token is in an invalid state, such as disabled or deleted.
   * For more information, see https://cloud.google.com/docs/authentication.
   *
   * Warning: For privacy reasons, the server may not be able to disclose the
   * email address for some accounts. The client MUST NOT depend on the
   * availability of the `email` attribute.
   *
   * Example of an ErrorInfo when the request is to the Cloud Storage API with
   * an access token that is associated with a disabled or deleted [service
   * account](http://cloud/iam/docs/service-accounts):
   *
   *     { "reason": "ACCOUNT_STATE_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject",
   *         "email": "user&#64;123.iam.gserviceaccount.com"
   *       }
   *     }
   * </pre>
   *
   * <code>ACCOUNT_STATE_INVALID = 18;</code>
   */
  ACCOUNT_STATE_INVALID(18),
  /**
   *
   *
   * <pre>
   * The request is denied because the type of the provided access token is not
   * supported by the API being called.
   *
   * Example of an ErrorInfo when the request is to the Cloud Storage API with
   * an unsupported token type.
   *
   *     { "reason": "ACCESS_TOKEN_TYPE_UNSUPPORTED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject"
   *       }
   *     }
   * </pre>
   *
   * <code>ACCESS_TOKEN_TYPE_UNSUPPORTED = 19;</code>
   */
  ACCESS_TOKEN_TYPE_UNSUPPORTED(19),
  /**
   *
   *
   * <pre>
   * The request is denied because the request doesn't have any authentication
   * credentials. For more information regarding the supported authentication
   * strategies for Google Cloud APIs, see
   * https://cloud.google.com/docs/authentication.
   *
   * Example of an ErrorInfo when the request is to the Cloud Storage API
   * without any authentication credentials.
   *
   *     { "reason": "CREDENTIALS_MISSING",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject"
   *       }
   *     }
   * </pre>
   *
   * <code>CREDENTIALS_MISSING = 20;</code>
   */
  CREDENTIALS_MISSING(20),
  /**
   *
   *
   * <pre>
   * The request is denied because the provided project owning the resource
   * which acts as the [API
   * consumer](https://cloud.google.com/apis/design/glossary#api_consumer) is
   * invalid. It may be in a bad format or empty.
   *
   * Example of an ErrorInfo when the request is to the Cloud Functions API,
   * but the offered resource project in the request in a bad format which can't
   * perform the ListFunctions method.
   *
   *     { "reason": "RESOURCE_PROJECT_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "cloudfunctions.googleapis.com",
   *         "method":
   *         "google.cloud.functions.v1.CloudFunctionsService.ListFunctions"
   *       }
   *     }
   * </pre>
   *
   * <code>RESOURCE_PROJECT_INVALID = 21;</code>
   */
  RESOURCE_PROJECT_INVALID(21),
  /**
   *
   *
   * <pre>
   * The request is denied because the provided session cookie is missing,
   * invalid or failed to decode.
   *
   * Example of an ErrorInfo when the request is calling Cloud Storage service
   * with a SID cookie which can't be decoded.
   *
   *     { "reason": "SESSION_COOKIE_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject",
   *         "cookie": "SID"
   *       }
   *     }
   * </pre>
   *
   * <code>SESSION_COOKIE_INVALID = 23;</code>
   */
  SESSION_COOKIE_INVALID(23),
  /**
   *
   *
   * <pre>
   * The request is denied because the user is from a Google Workspace customer
   * that blocks their users from accessing a particular service.
   *
   * Example scenario: https://support.google.com/a/answer/9197205?hl=en
   *
   * Example of an ErrorInfo when access to Google Cloud Storage service is
   * blocked by the Google Workspace administrator:
   *
   *     { "reason": "USER_BLOCKED_BY_ADMIN",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject",
   *       }
   *     }
   * </pre>
   *
   * <code>USER_BLOCKED_BY_ADMIN = 24;</code>
   */
  USER_BLOCKED_BY_ADMIN(24),
  /**
   *
   *
   * <pre>
   * The request is denied because the resource service usage is restricted
   * by administrators according to the organization policy constraint.
   * For more information see
   * https://cloud.google.com/resource-manager/docs/organization-policy/restricting-services.
   *
   * Example of an ErrorInfo when access to Google Cloud Storage service is
   * restricted by Resource Usage Restriction policy:
   *
   *     { "reason": "RESOURCE_USAGE_RESTRICTION_VIOLATED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/project-123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>RESOURCE_USAGE_RESTRICTION_VIOLATED = 25;</code>
   */
  RESOURCE_USAGE_RESTRICTION_VIOLATED(25),
  /**
   *
   *
   * <pre>
   * Unimplemented. Do not use.
   *
   * The request is denied because it contains unsupported system parameters in
   * URL query parameters or HTTP headers. For more information,
   * see https://cloud.google.com/apis/docs/system-parameters
   *
   * Example of an ErrorInfo when access "pubsub.googleapis.com" service with
   * a request header of "x-goog-user-ip":
   *
   *     { "reason": "SYSTEM_PARAMETER_UNSUPPORTED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "pubsub.googleapis.com"
   *         "parameter": "x-goog-user-ip"
   *       }
   *     }
   * </pre>
   *
   * <code>SYSTEM_PARAMETER_UNSUPPORTED = 26;</code>
   */
  SYSTEM_PARAMETER_UNSUPPORTED(26),
  /**
   *
   *
   * <pre>
   * The request is denied because it violates Org Restriction: the requested
   * resource does not belong to allowed organizations specified in
   * "X-Goog-Allowed-Resources" header.
   *
   * Example of an ErrorInfo when accessing a GCP resource that is restricted by
   * Org Restriction for "pubsub.googleapis.com" service.
   *
   * {
   *   reason: "ORG_RESTRICTION_VIOLATION"
   *   domain: "googleapis.com"
   *   metadata {
   *     "consumer":"projects/123456"
   *     "service": "pubsub.googleapis.com"
   *   }
   * }
   * </pre>
   *
   * <code>ORG_RESTRICTION_VIOLATION = 27;</code>
   */
  ORG_RESTRICTION_VIOLATION(27),
  /**
   *
   *
   * <pre>
   * The request is denied because "X-Goog-Allowed-Resources" header is in a bad
   * format.
   *
   * Example of an ErrorInfo when
   * accessing "pubsub.googleapis.com" service with an invalid
   * "X-Goog-Allowed-Resources" request header.
   *
   * {
   *   reason: "ORG_RESTRICTION_HEADER_INVALID"
   *   domain: "googleapis.com"
   *   metadata {
   *     "consumer":"projects/123456"
   *     "service": "pubsub.googleapis.com"
   *   }
   * }
   * </pre>
   *
   * <code>ORG_RESTRICTION_HEADER_INVALID = 28;</code>
   */
  ORG_RESTRICTION_HEADER_INVALID(28),
  /**
   *
   *
   * <pre>
   * Unimplemented. Do not use.
   *
   * The request is calling a service that is not visible to the consumer.
   *
   * Example of an ErrorInfo when the consumer "projects/123" contacting
   *  "pubsub.googleapis.com" service which is not visible to the consumer.
   *
   *     { "reason": "SERVICE_NOT_VISIBLE",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com"
   *       }
   *     }
   *
   * This response indicates the "pubsub.googleapis.com" is not visible to
   * "projects/123" (or it may not exist).
   * </pre>
   *
   * <code>SERVICE_NOT_VISIBLE = 29;</code>
   */
  SERVICE_NOT_VISIBLE(29),
  /**
   *
   *
   * <pre>
   * The request is related to a project for which GCP access is suspended.
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to contact
   * "pubsub.googleapis.com" service because GCP access is suspended:
   *
   *     { "reason": "GCP_SUSPENDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com"
   *       }
   *     }
   *
   * This response indicates the associated GCP account has been suspended.
   * </pre>
   *
   * <code>GCP_SUSPENDED = 30;</code>
   */
  GCP_SUSPENDED(30),
  /**
   *
   *
   * <pre>
   * The request violates the location policies when creating resources in
   * the restricted region.
   *
   * Example of an ErrorInfo when creating the Cloud Storage Bucket by
   * "projects/123" for service storage.googleapis.com:
   *
   *     { "reason": "LOCATION_POLICY_VIOLATED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com",
   *       }
   *     }
   *
   * This response indicates creating the Cloud Storage Bucket in
   * "locations/asia-northeast3" violates at least one location policy.
   * The troubleshooting guidance is provided in the Help links.
   * </pre>
   *
   * <code>LOCATION_POLICY_VIOLATED = 31;</code>
   */
  LOCATION_POLICY_VIOLATED(31),
  UNRECOGNIZED(-1),
  ;

  /**
   *
   *
   * <pre>
   * Do not use this default value.
   * </pre>
   *
   * <code>ERROR_REASON_UNSPECIFIED = 0;</code>
   */
  public static final int ERROR_REASON_UNSPECIFIED_VALUE = 0;
  /**
   *
   *
   * <pre>
   * The request is calling a disabled service for a consumer.
   *
   * Example of an ErrorInfo when the consumer "projects/123" contacting
   * "pubsub.googleapis.com" service which is disabled:
   *
   *     { "reason": "SERVICE_DISABLED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com"
   *       }
   *     }
   *
   * This response indicates the "pubsub.googleapis.com" has been disabled in
   * "projects/123".
   * </pre>
   *
   * <code>SERVICE_DISABLED = 1;</code>
   */
  public static final int SERVICE_DISABLED_VALUE = 1;
  /**
   *
   *
   * <pre>
   * The request whose associated billing account is disabled.
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to contact
   * "pubsub.googleapis.com" service because the associated billing account is
   * disabled:
   *
   *     { "reason": "BILLING_DISABLED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com"
   *       }
   *     }
   *
   * This response indicates the billing account associated has been disabled.
   * </pre>
   *
   * <code>BILLING_DISABLED = 2;</code>
   */
  public static final int BILLING_DISABLED_VALUE = 2;
  /**
   *
   *
   * <pre>
   * The request is denied because the provided [API
   * key](https://cloud.google.com/docs/authentication/api-keys) is invalid. It
   * may be in a bad format, cannot be found, or has been expired).
   *
   * Example of an ErrorInfo when the request is contacting
   * "storage.googleapis.com" service with an invalid API key:
   *
   *     { "reason": "API_KEY_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_INVALID = 3;</code>
   */
  public static final int API_KEY_INVALID_VALUE = 3;
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key API
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_api_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call the
   * "storage.googleapis.com" service because this service is restricted in the
   * API key:
   *
   *     { "reason": "API_KEY_SERVICE_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_SERVICE_BLOCKED = 4;</code>
   */
  public static final int API_KEY_SERVICE_BLOCKED_VALUE = 4;
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key HTTP
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_http_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * "storage.googleapis.com" service because the http referrer of the request
   * violates API key HTTP restrictions:
   *
   *     { "reason": "API_KEY_HTTP_REFERRER_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com",
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_HTTP_REFERRER_BLOCKED = 7;</code>
   */
  public static final int API_KEY_HTTP_REFERRER_BLOCKED_VALUE = 7;
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key IP address
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_application_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * "storage.googleapis.com" service because the caller IP of the request
   * violates API key IP address restrictions:
   *
   *     { "reason": "API_KEY_IP_ADDRESS_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com",
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_IP_ADDRESS_BLOCKED = 8;</code>
   */
  public static final int API_KEY_IP_ADDRESS_BLOCKED_VALUE = 8;
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key Android application
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_application_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * "storage.googleapis.com" service because the request from the Android apps
   * violates the API key Android application restrictions:
   *
   *     { "reason": "API_KEY_ANDROID_APP_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_ANDROID_APP_BLOCKED = 9;</code>
   */
  public static final int API_KEY_ANDROID_APP_BLOCKED_VALUE = 9;
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [API key iOS application
   * restrictions](https://cloud.google.com/docs/authentication/api-keys#adding_application_restrictions).
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * "storage.googleapis.com" service because the request from the iOS apps
   * violates the API key iOS application restrictions:
   *
   *     { "reason": "API_KEY_IOS_APP_BLOCKED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>API_KEY_IOS_APP_BLOCKED = 13;</code>
   */
  public static final int API_KEY_IOS_APP_BLOCKED_VALUE = 13;
  /**
   *
   *
   * <pre>
   * The request is denied because there is not enough rate quota for the
   * consumer.
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to contact
   * "pubsub.googleapis.com" service because consumer's rate quota usage has
   * reached the maximum value set for the quota limit
   * "ReadsPerMinutePerProject" on the quota metric
   * "pubsub.googleapis.com/read_requests":
   *
   *     { "reason": "RATE_LIMIT_EXCEEDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com",
   *         "quota_metric": "pubsub.googleapis.com/read_requests",
   *         "quota_limit": "ReadsPerMinutePerProject"
   *       }
   *     }
   *
   * Example of an ErrorInfo when the consumer "projects/123" checks quota on
   * the service "dataflow.googleapis.com" and hits the organization quota
   * limit "DefaultRequestsPerMinutePerOrganization" on the metric
   * "dataflow.googleapis.com/default_requests".
   *
   *     { "reason": "RATE_LIMIT_EXCEEDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "dataflow.googleapis.com",
   *         "quota_metric": "dataflow.googleapis.com/default_requests",
   *         "quota_limit": "DefaultRequestsPerMinutePerOrganization"
   *       }
   *     }
   * </pre>
   *
   * <code>RATE_LIMIT_EXCEEDED = 5;</code>
   */
  public static final int RATE_LIMIT_EXCEEDED_VALUE = 5;
  /**
   *
   *
   * <pre>
   * The request is denied because there is not enough resource quota for the
   * consumer.
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to contact
   * "compute.googleapis.com" service because consumer's resource quota usage
   * has reached the maximum value set for the quota limit "VMsPerProject"
   * on the quota metric "compute.googleapis.com/vms":
   *
   *     { "reason": "RESOURCE_QUOTA_EXCEEDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "compute.googleapis.com",
   *         "quota_metric": "compute.googleapis.com/vms",
   *         "quota_limit": "VMsPerProject"
   *       }
   *     }
   *
   * Example of an ErrorInfo when the consumer "projects/123" checks resource
   * quota on the service "dataflow.googleapis.com" and hits the organization
   * quota limit "jobs-per-organization" on the metric
   * "dataflow.googleapis.com/job_count".
   *
   *     { "reason": "RESOURCE_QUOTA_EXCEEDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "dataflow.googleapis.com",
   *         "quota_metric": "dataflow.googleapis.com/job_count",
   *         "quota_limit": "jobs-per-organization"
   *       }
   *     }
   * </pre>
   *
   * <code>RESOURCE_QUOTA_EXCEEDED = 6;</code>
   */
  public static final int RESOURCE_QUOTA_EXCEEDED_VALUE = 6;
  /**
   *
   *
   * <pre>
   * The request whose associated billing account address is in a tax restricted
   * location, violates the local tax restrictions when creating resources in
   * the restricted region.
   *
   * Example of an ErrorInfo when creating the Cloud Storage Bucket in the
   * container "projects/123" under a tax restricted region
   * "locations/asia-northeast3":
   *
   *     { "reason": "LOCATION_TAX_POLICY_VIOLATED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com",
   *         "location": "locations/asia-northeast3"
   *       }
   *     }
   *
   * This response indicates creating the Cloud Storage Bucket in
   * "locations/asia-northeast3" violates the location tax restriction.
   * </pre>
   *
   * <code>LOCATION_TAX_POLICY_VIOLATED = 10;</code>
   */
  public static final int LOCATION_TAX_POLICY_VIOLATED_VALUE = 10;
  /**
   *
   *
   * <pre>
   * The request is denied because the caller does not have required permission
   * on the user project "projects/123" or the user project is invalid. For more
   * information, check the [userProject System
   * Parameters](https://cloud.google.com/apis/docs/system-parameters).
   *
   * Example of an ErrorInfo when the caller is calling Cloud Storage service
   * with insufficient permissions on the user project:
   *
   *     { "reason": "USER_PROJECT_DENIED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>USER_PROJECT_DENIED = 11;</code>
   */
  public static final int USER_PROJECT_DENIED_VALUE = 11;
  /**
   *
   *
   * <pre>
   * The request is denied because the consumer "projects/123" is suspended due
   * to Terms of Service(Tos) violations. Check [Project suspension
   * guidelines](https://cloud.google.com/resource-manager/docs/project-suspension-guidelines)
   * for more information.
   *
   * Example of an ErrorInfo when calling Cloud Storage service with the
   * suspended consumer "projects/123":
   *
   *     { "reason": "CONSUMER_SUSPENDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>CONSUMER_SUSPENDED = 12;</code>
   */
  public static final int CONSUMER_SUSPENDED_VALUE = 12;
  /**
   *
   *
   * <pre>
   * The request is denied because the associated consumer is invalid. It may be
   * in a bad format, cannot be found, or have been deleted.
   *
   * Example of an ErrorInfo when calling Cloud Storage service with the
   * invalid consumer "projects/123":
   *
   *     { "reason": "CONSUMER_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>CONSUMER_INVALID = 14;</code>
   */
  public static final int CONSUMER_INVALID_VALUE = 14;
  /**
   *
   *
   * <pre>
   * The request is denied because it violates [VPC Service
   * Controls](https://cloud.google.com/vpc-service-controls/docs/overview).
   * The 'uid' field is a random generated identifier that customer can use it
   * to search the audit log for a request rejected by VPC Service Controls. For
   * more information, please refer [VPC Service Controls
   * Troubleshooting](https://cloud.google.com/vpc-service-controls/docs/troubleshooting#unique-id)
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to call
   * Cloud Storage service because the request is prohibited by the VPC Service
   * Controls.
   *
   *     { "reason": "SECURITY_POLICY_VIOLATED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "uid": "123456789abcde",
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>SECURITY_POLICY_VIOLATED = 15;</code>
   */
  public static final int SECURITY_POLICY_VIOLATED_VALUE = 15;
  /**
   *
   *
   * <pre>
   * The request is denied because the provided access token has expired.
   *
   * Example of an ErrorInfo when the request is calling Cloud Storage service
   * with an expired access token:
   *
   *     { "reason": "ACCESS_TOKEN_EXPIRED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject"
   *       }
   *     }
   * </pre>
   *
   * <code>ACCESS_TOKEN_EXPIRED = 16;</code>
   */
  public static final int ACCESS_TOKEN_EXPIRED_VALUE = 16;
  /**
   *
   *
   * <pre>
   * The request is denied because the provided access token doesn't have at
   * least one of the acceptable scopes required for the API. Please check
   * [OAuth 2.0 Scopes for Google
   * APIs](https://developers.google.com/identity/protocols/oauth2/scopes) for
   * the list of the OAuth 2.0 scopes that you might need to request to access
   * the API.
   *
   * Example of an ErrorInfo when the request is calling Cloud Storage service
   * with an access token that is missing required scopes:
   *
   *     { "reason": "ACCESS_TOKEN_SCOPE_INSUFFICIENT",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject"
   *       }
   *     }
   * </pre>
   *
   * <code>ACCESS_TOKEN_SCOPE_INSUFFICIENT = 17;</code>
   */
  public static final int ACCESS_TOKEN_SCOPE_INSUFFICIENT_VALUE = 17;
  /**
   *
   *
   * <pre>
   * The request is denied because the account associated with the provided
   * access token is in an invalid state, such as disabled or deleted.
   * For more information, see https://cloud.google.com/docs/authentication.
   *
   * Warning: For privacy reasons, the server may not be able to disclose the
   * email address for some accounts. The client MUST NOT depend on the
   * availability of the `email` attribute.
   *
   * Example of an ErrorInfo when the request is to the Cloud Storage API with
   * an access token that is associated with a disabled or deleted [service
   * account](http://cloud/iam/docs/service-accounts):
   *
   *     { "reason": "ACCOUNT_STATE_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject",
   *         "email": "user&#64;123.iam.gserviceaccount.com"
   *       }
   *     }
   * </pre>
   *
   * <code>ACCOUNT_STATE_INVALID = 18;</code>
   */
  public static final int ACCOUNT_STATE_INVALID_VALUE = 18;
  /**
   *
   *
   * <pre>
   * The request is denied because the type of the provided access token is not
   * supported by the API being called.
   *
   * Example of an ErrorInfo when the request is to the Cloud Storage API with
   * an unsupported token type.
   *
   *     { "reason": "ACCESS_TOKEN_TYPE_UNSUPPORTED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject"
   *       }
   *     }
   * </pre>
   *
   * <code>ACCESS_TOKEN_TYPE_UNSUPPORTED = 19;</code>
   */
  public static final int ACCESS_TOKEN_TYPE_UNSUPPORTED_VALUE = 19;
  /**
   *
   *
   * <pre>
   * The request is denied because the request doesn't have any authentication
   * credentials. For more information regarding the supported authentication
   * strategies for Google Cloud APIs, see
   * https://cloud.google.com/docs/authentication.
   *
   * Example of an ErrorInfo when the request is to the Cloud Storage API
   * without any authentication credentials.
   *
   *     { "reason": "CREDENTIALS_MISSING",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject"
   *       }
   *     }
   * </pre>
   *
   * <code>CREDENTIALS_MISSING = 20;</code>
   */
  public static final int CREDENTIALS_MISSING_VALUE = 20;
  /**
   *
   *
   * <pre>
   * The request is denied because the provided project owning the resource
   * which acts as the [API
   * consumer](https://cloud.google.com/apis/design/glossary#api_consumer) is
   * invalid. It may be in a bad format or empty.
   *
   * Example of an ErrorInfo when the request is to the Cloud Functions API,
   * but the offered resource project in the request in a bad format which can't
   * perform the ListFunctions method.
   *
   *     { "reason": "RESOURCE_PROJECT_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "cloudfunctions.googleapis.com",
   *         "method":
   *         "google.cloud.functions.v1.CloudFunctionsService.ListFunctions"
   *       }
   *     }
   * </pre>
   *
   * <code>RESOURCE_PROJECT_INVALID = 21;</code>
   */
  public static final int RESOURCE_PROJECT_INVALID_VALUE = 21;
  /**
   *
   *
   * <pre>
   * The request is denied because the provided session cookie is missing,
   * invalid or failed to decode.
   *
   * Example of an ErrorInfo when the request is calling Cloud Storage service
   * with a SID cookie which can't be decoded.
   *
   *     { "reason": "SESSION_COOKIE_INVALID",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject",
   *         "cookie": "SID"
   *       }
   *     }
   * </pre>
   *
   * <code>SESSION_COOKIE_INVALID = 23;</code>
   */
  public static final int SESSION_COOKIE_INVALID_VALUE = 23;
  /**
   *
   *
   * <pre>
   * The request is denied because the user is from a Google Workspace customer
   * that blocks their users from accessing a particular service.
   *
   * Example scenario: https://support.google.com/a/answer/9197205?hl=en
   *
   * Example of an ErrorInfo when access to Google Cloud Storage service is
   * blocked by the Google Workspace administrator:
   *
   *     { "reason": "USER_BLOCKED_BY_ADMIN",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "storage.googleapis.com",
   *         "method": "google.storage.v1.Storage.GetObject",
   *       }
   *     }
   * </pre>
   *
   * <code>USER_BLOCKED_BY_ADMIN = 24;</code>
   */
  public static final int USER_BLOCKED_BY_ADMIN_VALUE = 24;
  /**
   *
   *
   * <pre>
   * The request is denied because the resource service usage is restricted
   * by administrators according to the organization policy constraint.
   * For more information see
   * https://cloud.google.com/resource-manager/docs/organization-policy/restricting-services.
   *
   * Example of an ErrorInfo when access to Google Cloud Storage service is
   * restricted by Resource Usage Restriction policy:
   *
   *     { "reason": "RESOURCE_USAGE_RESTRICTION_VIOLATED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/project-123",
   *         "service": "storage.googleapis.com"
   *       }
   *     }
   * </pre>
   *
   * <code>RESOURCE_USAGE_RESTRICTION_VIOLATED = 25;</code>
   */
  public static final int RESOURCE_USAGE_RESTRICTION_VIOLATED_VALUE = 25;
  /**
   *
   *
   * <pre>
   * Unimplemented. Do not use.
   *
   * The request is denied because it contains unsupported system parameters in
   * URL query parameters or HTTP headers. For more information,
   * see https://cloud.google.com/apis/docs/system-parameters
   *
   * Example of an ErrorInfo when access "pubsub.googleapis.com" service with
   * a request header of "x-goog-user-ip":
   *
   *     { "reason": "SYSTEM_PARAMETER_UNSUPPORTED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "service": "pubsub.googleapis.com"
   *         "parameter": "x-goog-user-ip"
   *       }
   *     }
   * </pre>
   *
   * <code>SYSTEM_PARAMETER_UNSUPPORTED = 26;</code>
   */
  public static final int SYSTEM_PARAMETER_UNSUPPORTED_VALUE = 26;
  /**
   *
   *
   * <pre>
   * The request is denied because it violates Org Restriction: the requested
   * resource does not belong to allowed organizations specified in
   * "X-Goog-Allowed-Resources" header.
   *
   * Example of an ErrorInfo when accessing a GCP resource that is restricted by
   * Org Restriction for "pubsub.googleapis.com" service.
   *
   * {
   *   reason: "ORG_RESTRICTION_VIOLATION"
   *   domain: "googleapis.com"
   *   metadata {
   *     "consumer":"projects/123456"
   *     "service": "pubsub.googleapis.com"
   *   }
   * }
   * </pre>
   *
   * <code>ORG_RESTRICTION_VIOLATION = 27;</code>
   */
  public static final int ORG_RESTRICTION_VIOLATION_VALUE = 27;
  /**
   *
   *
   * <pre>
   * The request is denied because "X-Goog-Allowed-Resources" header is in a bad
   * format.
   *
   * Example of an ErrorInfo when
   * accessing "pubsub.googleapis.com" service with an invalid
   * "X-Goog-Allowed-Resources" request header.
   *
   * {
   *   reason: "ORG_RESTRICTION_HEADER_INVALID"
   *   domain: "googleapis.com"
   *   metadata {
   *     "consumer":"projects/123456"
   *     "service": "pubsub.googleapis.com"
   *   }
   * }
   * </pre>
   *
   * <code>ORG_RESTRICTION_HEADER_INVALID = 28;</code>
   */
  public static final int ORG_RESTRICTION_HEADER_INVALID_VALUE = 28;
  /**
   *
   *
   * <pre>
   * Unimplemented. Do not use.
   *
   * The request is calling a service that is not visible to the consumer.
   *
   * Example of an ErrorInfo when the consumer "projects/123" contacting
   *  "pubsub.googleapis.com" service which is not visible to the consumer.
   *
   *     { "reason": "SERVICE_NOT_VISIBLE",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com"
   *       }
   *     }
   *
   * This response indicates the "pubsub.googleapis.com" is not visible to
   * "projects/123" (or it may not exist).
   * </pre>
   *
   * <code>SERVICE_NOT_VISIBLE = 29;</code>
   */
  public static final int SERVICE_NOT_VISIBLE_VALUE = 29;
  /**
   *
   *
   * <pre>
   * The request is related to a project for which GCP access is suspended.
   *
   * Example of an ErrorInfo when the consumer "projects/123" fails to contact
   * "pubsub.googleapis.com" service because GCP access is suspended:
   *
   *     { "reason": "GCP_SUSPENDED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "pubsub.googleapis.com"
   *       }
   *     }
   *
   * This response indicates the associated GCP account has been suspended.
   * </pre>
   *
   * <code>GCP_SUSPENDED = 30;</code>
   */
  public static final int GCP_SUSPENDED_VALUE = 30;
  /**
   *
   *
   * <pre>
   * The request violates the location policies when creating resources in
   * the restricted region.
   *
   * Example of an ErrorInfo when creating the Cloud Storage Bucket by
   * "projects/123" for service storage.googleapis.com:
   *
   *     { "reason": "LOCATION_POLICY_VIOLATED",
   *       "domain": "googleapis.com",
   *       "metadata": {
   *         "consumer": "projects/123",
   *         "service": "storage.googleapis.com",
   *       }
   *     }
   *
   * This response indicates creating the Cloud Storage Bucket in
   * "locations/asia-northeast3" violates at least one location policy.
   * The troubleshooting guidance is provided in the Help links.
   * </pre>
   *
   * <code>LOCATION_POLICY_VIOLATED = 31;</code>
   */
  public static final int LOCATION_POLICY_VIOLATED_VALUE = 31;

  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static ErrorReason valueOf(int value) {
    return forNumber(value);
  }

  /**
   * @param value The numeric wire value of the corresponding enum entry.
   * @return The enum associated with the given numeric wire value.
   */
  public static ErrorReason forNumber(int value) {
    switch (value) {
      case 0:
        return ERROR_REASON_UNSPECIFIED;
      case 1:
        return SERVICE_DISABLED;
      case 2:
        return BILLING_DISABLED;
      case 3:
        return API_KEY_INVALID;
      case 4:
        return API_KEY_SERVICE_BLOCKED;
      case 7:
        return API_KEY_HTTP_REFERRER_BLOCKED;
      case 8:
        return API_KEY_IP_ADDRESS_BLOCKED;
      case 9:
        return API_KEY_ANDROID_APP_BLOCKED;
      case 13:
        return API_KEY_IOS_APP_BLOCKED;
      case 5:
        return RATE_LIMIT_EXCEEDED;
      case 6:
        return RESOURCE_QUOTA_EXCEEDED;
      case 10:
        return LOCATION_TAX_POLICY_VIOLATED;
      case 11:
        return USER_PROJECT_DENIED;
      case 12:
        return CONSUMER_SUSPENDED;
      case 14:
        return CONSUMER_INVALID;
      case 15:
        return SECURITY_POLICY_VIOLATED;
      case 16:
        return ACCESS_TOKEN_EXPIRED;
      case 17:
        return ACCESS_TOKEN_SCOPE_INSUFFICIENT;
      case 18:
        return ACCOUNT_STATE_INVALID;
      case 19:
        return ACCESS_TOKEN_TYPE_UNSUPPORTED;
      case 20:
        return CREDENTIALS_MISSING;
      case 21:
        return RESOURCE_PROJECT_INVALID;
      case 23:
        return SESSION_COOKIE_INVALID;
      case 24:
        return USER_BLOCKED_BY_ADMIN;
      case 25:
        return RESOURCE_USAGE_RESTRICTION_VIOLATED;
      case 26:
        return SYSTEM_PARAMETER_UNSUPPORTED;
      case 27:
        return ORG_RESTRICTION_VIOLATION;
      case 28:
        return ORG_RESTRICTION_HEADER_INVALID;
      case 29:
        return SERVICE_NOT_VISIBLE;
      case 30:
        return GCP_SUSPENDED;
      case 31:
        return LOCATION_POLICY_VIOLATED;
      default:
        return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<ErrorReason> internalGetValueMap() {
    return internalValueMap;
  }

  private static final com.google.protobuf.Internal.EnumLiteMap<ErrorReason> internalValueMap =
      new com.google.protobuf.Internal.EnumLiteMap<ErrorReason>() {
        public ErrorReason findValueByNumber(int number) {
          return ErrorReason.forNumber(number);
        }
      };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalStateException(
          "Can't get the descriptor of an unrecognized enum value.");
    }
    return getDescriptor().getValues().get(ordinal());
  }

  public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
    return getDescriptor();
  }

  public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
    return com.google.api.ErrorReasonProto.getDescriptor().getEnumTypes().get(0);
  }

  private static final ErrorReason[] VALUES = values();

  public static ErrorReason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private ErrorReason(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.api.ErrorReason)
}
