/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/documentation.proto

// Protobuf Java Version: 3.25.3
package com.google.api;

/**
 *
 *
 * <pre>
 * `Documentation` provides the information for describing a service.
 *
 * Example:
 * &lt;pre&gt;&lt;code&gt;documentation:
 *   summary: &gt;
 *     The Google Calendar API gives access
 *     to most calendar features.
 *   pages:
 *   - name: Overview
 *     content: &amp;#40;== include google/foo/overview.md ==&amp;#41;
 *   - name: Tutorial
 *     content: &amp;#40;== include google/foo/tutorial.md ==&amp;#41;
 *     subpages:
 *     - name: Java
 *       content: &amp;#40;== include google/foo/tutorial_java.md ==&amp;#41;
 *   rules:
 *   - selector: google.calendar.Calendar.Get
 *     description: &gt;
 *       ...
 *   - selector: google.calendar.Calendar.Put
 *     description: &gt;
 *       ...
 * &lt;/code&gt;&lt;/pre&gt;
 * Documentation is provided in markdown syntax. In addition to
 * standard markdown features, definition lists, tables and fenced
 * code blocks are supported. Section headers can be provided and are
 * interpreted relative to the section nesting of the context where
 * a documentation fragment is embedded.
 *
 * Documentation from the IDL is merged with documentation defined
 * via the config at normalization time, where documentation provided
 * by config rules overrides IDL provided.
 *
 * A number of constructs specific to the API platform are supported
 * in documentation text.
 *
 * In order to reference a proto element, the following
 * notation can be used:
 * &lt;pre&gt;&lt;code&gt;&amp;#91;fully.qualified.proto.name]&amp;#91;]&lt;/code&gt;&lt;/pre&gt;
 * To override the display text used for the link, this can be used:
 * &lt;pre&gt;&lt;code&gt;&amp;#91;display text]&amp;#91;fully.qualified.proto.name]&lt;/code&gt;&lt;/pre&gt;
 * Text can be excluded from doc using the following notation:
 * &lt;pre&gt;&lt;code&gt;&amp;#40;-- internal comment --&amp;#41;&lt;/code&gt;&lt;/pre&gt;
 *
 * A few directives are available in documentation. Note that
 * directives must appear on a single line to be properly
 * identified. The `include` directive includes a markdown file from
 * an external source:
 * &lt;pre&gt;&lt;code&gt;&amp;#40;== include path/to/file ==&amp;#41;&lt;/code&gt;&lt;/pre&gt;
 * The `resource_for` directive marks a message to be the resource of
 * a collection in REST view. If it is not specified, tools attempt
 * to infer the resource from the operations in a collection:
 * &lt;pre&gt;&lt;code&gt;&amp;#40;== resource_for v1.shelves.books ==&amp;#41;&lt;/code&gt;&lt;/pre&gt;
 * The directive `suppress_warning` does not directly affect documentation
 * and is documented together with service config validation.
 * </pre>
 *
 * Protobuf type {@code google.api.Documentation}
 */
public final class Documentation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Documentation)
    DocumentationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Documentation.newBuilder() to construct.
  private Documentation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Documentation() {
    summary_ = "";
    pages_ = java.util.Collections.emptyList();
    rules_ = java.util.Collections.emptyList();
    documentationRootUrl_ = "";
    serviceRootUrl_ = "";
    overview_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Documentation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.DocumentationProto.internal_static_google_api_Documentation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.DocumentationProto
        .internal_static_google_api_Documentation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Documentation.class, com.google.api.Documentation.Builder.class);
  }

  public static final int SUMMARY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object summary_ = "";
  /**
   *
   *
   * <pre>
   * A short description of what the service does. The summary must be plain
   * text. It becomes the overview of the service displayed in Google Cloud
   * Console.
   * NOTE: This field is equivalent to the standard field `description`.
   * </pre>
   *
   * <code>string summary = 1;</code>
   *
   * @return The summary.
   */
  @java.lang.Override
  public java.lang.String getSummary() {
    java.lang.Object ref = summary_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      summary_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A short description of what the service does. The summary must be plain
   * text. It becomes the overview of the service displayed in Google Cloud
   * Console.
   * NOTE: This field is equivalent to the standard field `description`.
   * </pre>
   *
   * <code>string summary = 1;</code>
   *
   * @return The bytes for summary.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSummaryBytes() {
    java.lang.Object ref = summary_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      summary_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.Page> pages_;
  /**
   *
   *
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.Page> getPagesList() {
    return pages_;
  }
  /**
   *
   *
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.PageOrBuilder> getPagesOrBuilderList() {
    return pages_;
  }
  /**
   *
   *
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  @java.lang.Override
  public int getPagesCount() {
    return pages_.size();
  }
  /**
   *
   *
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  @java.lang.Override
  public com.google.api.Page getPages(int index) {
    return pages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  @java.lang.Override
  public com.google.api.PageOrBuilder getPagesOrBuilder(int index) {
    return pages_.get(index);
  }

  public static final int RULES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.DocumentationRule> rules_;
  /**
   *
   *
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.DocumentationRule> getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.DocumentationRuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  @java.lang.Override
  public com.google.api.DocumentationRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   *
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  @java.lang.Override
  public com.google.api.DocumentationRuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  public static final int DOCUMENTATION_ROOT_URL_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object documentationRootUrl_ = "";
  /**
   *
   *
   * <pre>
   * The URL to the root of documentation.
   * </pre>
   *
   * <code>string documentation_root_url = 4;</code>
   *
   * @return The documentationRootUrl.
   */
  @java.lang.Override
  public java.lang.String getDocumentationRootUrl() {
    java.lang.Object ref = documentationRootUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentationRootUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL to the root of documentation.
   * </pre>
   *
   * <code>string documentation_root_url = 4;</code>
   *
   * @return The bytes for documentationRootUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDocumentationRootUrlBytes() {
    java.lang.Object ref = documentationRootUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      documentationRootUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ROOT_URL_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceRootUrl_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the service root url if the default one (the service name
   * from the yaml file) is not suitable. This can be seen in any fully
   * specified service urls as well as sections that show a base that other
   * urls are relative to.
   * </pre>
   *
   * <code>string service_root_url = 6;</code>
   *
   * @return The serviceRootUrl.
   */
  @java.lang.Override
  public java.lang.String getServiceRootUrl() {
    java.lang.Object ref = serviceRootUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceRootUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the service root url if the default one (the service name
   * from the yaml file) is not suitable. This can be seen in any fully
   * specified service urls as well as sections that show a base that other
   * urls are relative to.
   * </pre>
   *
   * <code>string service_root_url = 6;</code>
   *
   * @return The bytes for serviceRootUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceRootUrlBytes() {
    java.lang.Object ref = serviceRootUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceRootUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OVERVIEW_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object overview_ = "";
  /**
   *
   *
   * <pre>
   * Declares a single overview page. For example:
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: ...
   *   overview: &amp;#40;== include overview.md ==&amp;#41;
   * &lt;/code&gt;&lt;/pre&gt;
   * This is a shortcut for the following declaration (using pages style):
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: ...
   *   pages:
   *   - name: Overview
   *     content: &amp;#40;== include overview.md ==&amp;#41;
   * &lt;/code&gt;&lt;/pre&gt;
   * Note: you cannot specify both `overview` field and `pages` field.
   * </pre>
   *
   * <code>string overview = 2;</code>
   *
   * @return The overview.
   */
  @java.lang.Override
  public java.lang.String getOverview() {
    java.lang.Object ref = overview_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      overview_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Declares a single overview page. For example:
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: ...
   *   overview: &amp;#40;== include overview.md ==&amp;#41;
   * &lt;/code&gt;&lt;/pre&gt;
   * This is a shortcut for the following declaration (using pages style):
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: ...
   *   pages:
   *   - name: Overview
   *     content: &amp;#40;== include overview.md ==&amp;#41;
   * &lt;/code&gt;&lt;/pre&gt;
   * Note: you cannot specify both `overview` field and `pages` field.
   * </pre>
   *
   * <code>string overview = 2;</code>
   *
   * @return The bytes for overview.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOverviewBytes() {
    java.lang.Object ref = overview_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      overview_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, summary_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(overview_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, overview_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(3, rules_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentationRootUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, documentationRootUrl_);
    }
    for (int i = 0; i < pages_.size(); i++) {
      output.writeMessage(5, pages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceRootUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, serviceRootUrl_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, summary_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(overview_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, overview_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, rules_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(documentationRootUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, documentationRootUrl_);
    }
    for (int i = 0; i < pages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, pages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceRootUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, serviceRootUrl_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Documentation)) {
      return super.equals(obj);
    }
    com.google.api.Documentation other = (com.google.api.Documentation) obj;

    if (!getSummary().equals(other.getSummary())) return false;
    if (!getPagesList().equals(other.getPagesList())) return false;
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (!getDocumentationRootUrl().equals(other.getDocumentationRootUrl())) return false;
    if (!getServiceRootUrl().equals(other.getServiceRootUrl())) return false;
    if (!getOverview().equals(other.getOverview())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
    hash = (53 * hash) + getSummary().hashCode();
    if (getPagesCount() > 0) {
      hash = (37 * hash) + PAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPagesList().hashCode();
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    hash = (37 * hash) + DOCUMENTATION_ROOT_URL_FIELD_NUMBER;
    hash = (53 * hash) + getDocumentationRootUrl().hashCode();
    hash = (37 * hash) + SERVICE_ROOT_URL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceRootUrl().hashCode();
    hash = (37 * hash) + OVERVIEW_FIELD_NUMBER;
    hash = (53 * hash) + getOverview().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.Documentation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Documentation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Documentation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Documentation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Documentation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Documentation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Documentation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.Documentation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.Documentation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.Documentation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.Documentation parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.Documentation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.Documentation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `Documentation` provides the information for describing a service.
   *
   * Example:
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: &gt;
   *     The Google Calendar API gives access
   *     to most calendar features.
   *   pages:
   *   - name: Overview
   *     content: &amp;#40;== include google/foo/overview.md ==&amp;#41;
   *   - name: Tutorial
   *     content: &amp;#40;== include google/foo/tutorial.md ==&amp;#41;
   *     subpages:
   *     - name: Java
   *       content: &amp;#40;== include google/foo/tutorial_java.md ==&amp;#41;
   *   rules:
   *   - selector: google.calendar.Calendar.Get
   *     description: &gt;
   *       ...
   *   - selector: google.calendar.Calendar.Put
   *     description: &gt;
   *       ...
   * &lt;/code&gt;&lt;/pre&gt;
   * Documentation is provided in markdown syntax. In addition to
   * standard markdown features, definition lists, tables and fenced
   * code blocks are supported. Section headers can be provided and are
   * interpreted relative to the section nesting of the context where
   * a documentation fragment is embedded.
   *
   * Documentation from the IDL is merged with documentation defined
   * via the config at normalization time, where documentation provided
   * by config rules overrides IDL provided.
   *
   * A number of constructs specific to the API platform are supported
   * in documentation text.
   *
   * In order to reference a proto element, the following
   * notation can be used:
   * &lt;pre&gt;&lt;code&gt;&amp;#91;fully.qualified.proto.name]&amp;#91;]&lt;/code&gt;&lt;/pre&gt;
   * To override the display text used for the link, this can be used:
   * &lt;pre&gt;&lt;code&gt;&amp;#91;display text]&amp;#91;fully.qualified.proto.name]&lt;/code&gt;&lt;/pre&gt;
   * Text can be excluded from doc using the following notation:
   * &lt;pre&gt;&lt;code&gt;&amp;#40;-- internal comment --&amp;#41;&lt;/code&gt;&lt;/pre&gt;
   *
   * A few directives are available in documentation. Note that
   * directives must appear on a single line to be properly
   * identified. The `include` directive includes a markdown file from
   * an external source:
   * &lt;pre&gt;&lt;code&gt;&amp;#40;== include path/to/file ==&amp;#41;&lt;/code&gt;&lt;/pre&gt;
   * The `resource_for` directive marks a message to be the resource of
   * a collection in REST view. If it is not specified, tools attempt
   * to infer the resource from the operations in a collection:
   * &lt;pre&gt;&lt;code&gt;&amp;#40;== resource_for v1.shelves.books ==&amp;#41;&lt;/code&gt;&lt;/pre&gt;
   * The directive `suppress_warning` does not directly affect documentation
   * and is documented together with service config validation.
   * </pre>
   *
   * Protobuf type {@code google.api.Documentation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Documentation)
      com.google.api.DocumentationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.DocumentationProto.internal_static_google_api_Documentation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.DocumentationProto
          .internal_static_google_api_Documentation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Documentation.class, com.google.api.Documentation.Builder.class);
    }

    // Construct using com.google.api.Documentation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      summary_ = "";
      if (pagesBuilder_ == null) {
        pages_ = java.util.Collections.emptyList();
      } else {
        pages_ = null;
        pagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
      } else {
        rules_ = null;
        rulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      documentationRootUrl_ = "";
      serviceRootUrl_ = "";
      overview_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.DocumentationProto.internal_static_google_api_Documentation_descriptor;
    }

    @java.lang.Override
    public com.google.api.Documentation getDefaultInstanceForType() {
      return com.google.api.Documentation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.Documentation build() {
      com.google.api.Documentation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.Documentation buildPartial() {
      com.google.api.Documentation result = new com.google.api.Documentation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.Documentation result) {
      if (pagesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          pages_ = java.util.Collections.unmodifiableList(pages_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.pages_ = pages_;
      } else {
        result.pages_ = pagesBuilder_.build();
      }
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.Documentation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.summary_ = summary_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.documentationRootUrl_ = documentationRootUrl_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.serviceRootUrl_ = serviceRootUrl_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.overview_ = overview_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Documentation) {
        return mergeFrom((com.google.api.Documentation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.Documentation other) {
      if (other == com.google.api.Documentation.getDefaultInstance()) return this;
      if (!other.getSummary().isEmpty()) {
        summary_ = other.summary_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (pagesBuilder_ == null) {
        if (!other.pages_.isEmpty()) {
          if (pages_.isEmpty()) {
            pages_ = other.pages_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePagesIsMutable();
            pages_.addAll(other.pages_);
          }
          onChanged();
        }
      } else {
        if (!other.pages_.isEmpty()) {
          if (pagesBuilder_.isEmpty()) {
            pagesBuilder_.dispose();
            pagesBuilder_ = null;
            pages_ = other.pages_;
            bitField0_ = (bitField0_ & ~0x00000002);
            pagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPagesFieldBuilder()
                    : null;
          } else {
            pagesBuilder_.addAllMessages(other.pages_);
          }
        }
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000004);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      if (!other.getDocumentationRootUrl().isEmpty()) {
        documentationRootUrl_ = other.documentationRootUrl_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getServiceRootUrl().isEmpty()) {
        serviceRootUrl_ = other.serviceRootUrl_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getOverview().isEmpty()) {
        overview_ = other.overview_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                summary_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                overview_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 18
            case 26:
              {
                com.google.api.DocumentationRule m =
                    input.readMessage(com.google.api.DocumentationRule.parser(), extensionRegistry);
                if (rulesBuilder_ == null) {
                  ensureRulesIsMutable();
                  rules_.add(m);
                } else {
                  rulesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                documentationRootUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.api.Page m =
                    input.readMessage(com.google.api.Page.parser(), extensionRegistry);
                if (pagesBuilder_ == null) {
                  ensurePagesIsMutable();
                  pages_.add(m);
                } else {
                  pagesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                serviceRootUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object summary_ = "";
    /**
     *
     *
     * <pre>
     * A short description of what the service does. The summary must be plain
     * text. It becomes the overview of the service displayed in Google Cloud
     * Console.
     * NOTE: This field is equivalent to the standard field `description`.
     * </pre>
     *
     * <code>string summary = 1;</code>
     *
     * @return The summary.
     */
    public java.lang.String getSummary() {
      java.lang.Object ref = summary_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        summary_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A short description of what the service does. The summary must be plain
     * text. It becomes the overview of the service displayed in Google Cloud
     * Console.
     * NOTE: This field is equivalent to the standard field `description`.
     * </pre>
     *
     * <code>string summary = 1;</code>
     *
     * @return The bytes for summary.
     */
    public com.google.protobuf.ByteString getSummaryBytes() {
      java.lang.Object ref = summary_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        summary_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A short description of what the service does. The summary must be plain
     * text. It becomes the overview of the service displayed in Google Cloud
     * Console.
     * NOTE: This field is equivalent to the standard field `description`.
     * </pre>
     *
     * <code>string summary = 1;</code>
     *
     * @param value The summary to set.
     * @return This builder for chaining.
     */
    public Builder setSummary(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      summary_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short description of what the service does. The summary must be plain
     * text. It becomes the overview of the service displayed in Google Cloud
     * Console.
     * NOTE: This field is equivalent to the standard field `description`.
     * </pre>
     *
     * <code>string summary = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSummary() {
      summary_ = getDefaultInstance().getSummary();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short description of what the service does. The summary must be plain
     * text. It becomes the overview of the service displayed in Google Cloud
     * Console.
     * NOTE: This field is equivalent to the standard field `description`.
     * </pre>
     *
     * <code>string summary = 1;</code>
     *
     * @param value The bytes for summary to set.
     * @return This builder for chaining.
     */
    public Builder setSummaryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      summary_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.Page> pages_ = java.util.Collections.emptyList();

    private void ensurePagesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        pages_ = new java.util.ArrayList<com.google.api.Page>(pages_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Page, com.google.api.Page.Builder, com.google.api.PageOrBuilder>
        pagesBuilder_;

    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public java.util.List<com.google.api.Page> getPagesList() {
      if (pagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pages_);
      } else {
        return pagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public int getPagesCount() {
      if (pagesBuilder_ == null) {
        return pages_.size();
      } else {
        return pagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public com.google.api.Page getPages(int index) {
      if (pagesBuilder_ == null) {
        return pages_.get(index);
      } else {
        return pagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder setPages(int index, com.google.api.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.set(index, value);
        onChanged();
      } else {
        pagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder setPages(int index, com.google.api.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.set(index, builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addPages(com.google.api.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.add(value);
        onChanged();
      } else {
        pagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addPages(int index, com.google.api.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.add(index, value);
        onChanged();
      } else {
        pagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addPages(com.google.api.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.add(builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addPages(int index, com.google.api.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.add(index, builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addAllPages(java.lang.Iterable<? extends com.google.api.Page> values) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pages_);
        onChanged();
      } else {
        pagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder clearPages() {
      if (pagesBuilder_ == null) {
        pages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        pagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder removePages(int index) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.remove(index);
        onChanged();
      } else {
        pagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public com.google.api.Page.Builder getPagesBuilder(int index) {
      return getPagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public com.google.api.PageOrBuilder getPagesOrBuilder(int index) {
      if (pagesBuilder_ == null) {
        return pages_.get(index);
      } else {
        return pagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public java.util.List<? extends com.google.api.PageOrBuilder> getPagesOrBuilderList() {
      if (pagesBuilder_ != null) {
        return pagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pages_);
      }
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public com.google.api.Page.Builder addPagesBuilder() {
      return getPagesFieldBuilder().addBuilder(com.google.api.Page.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public com.google.api.Page.Builder addPagesBuilder(int index) {
      return getPagesFieldBuilder().addBuilder(index, com.google.api.Page.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public java.util.List<com.google.api.Page.Builder> getPagesBuilderList() {
      return getPagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Page, com.google.api.Page.Builder, com.google.api.PageOrBuilder>
        getPagesFieldBuilder() {
      if (pagesBuilder_ == null) {
        pagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Page, com.google.api.Page.Builder, com.google.api.PageOrBuilder>(
                pages_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        pages_ = null;
      }
      return pagesBuilder_;
    }

    private java.util.List<com.google.api.DocumentationRule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        rules_ = new java.util.ArrayList<com.google.api.DocumentationRule>(rules_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.DocumentationRule,
            com.google.api.DocumentationRule.Builder,
            com.google.api.DocumentationRuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public java.util.List<com.google.api.DocumentationRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public com.google.api.DocumentationRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder setRules(int index, com.google.api.DocumentationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder setRules(int index, com.google.api.DocumentationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addRules(com.google.api.DocumentationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addRules(int index, com.google.api.DocumentationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addRules(com.google.api.DocumentationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addRules(int index, com.google.api.DocumentationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends com.google.api.DocumentationRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public com.google.api.DocumentationRule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public com.google.api.DocumentationRuleOrBuilder getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public java.util.List<? extends com.google.api.DocumentationRuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public com.google.api.DocumentationRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(com.google.api.DocumentationRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public com.google.api.DocumentationRule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(index, com.google.api.DocumentationRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     *
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public java.util.List<com.google.api.DocumentationRule.Builder> getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.DocumentationRule,
            com.google.api.DocumentationRule.Builder,
            com.google.api.DocumentationRuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.DocumentationRule,
                com.google.api.DocumentationRule.Builder,
                com.google.api.DocumentationRuleOrBuilder>(
                rules_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    private java.lang.Object documentationRootUrl_ = "";
    /**
     *
     *
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     *
     * @return The documentationRootUrl.
     */
    public java.lang.String getDocumentationRootUrl() {
      java.lang.Object ref = documentationRootUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentationRootUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     *
     * @return The bytes for documentationRootUrl.
     */
    public com.google.protobuf.ByteString getDocumentationRootUrlBytes() {
      java.lang.Object ref = documentationRootUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        documentationRootUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     *
     * @param value The documentationRootUrl to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationRootUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      documentationRootUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocumentationRootUrl() {
      documentationRootUrl_ = getDefaultInstance().getDocumentationRootUrl();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     *
     * @param value The bytes for documentationRootUrl to set.
     * @return This builder for chaining.
     */
    public Builder setDocumentationRootUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      documentationRootUrl_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object serviceRootUrl_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the service root url if the default one (the service name
     * from the yaml file) is not suitable. This can be seen in any fully
     * specified service urls as well as sections that show a base that other
     * urls are relative to.
     * </pre>
     *
     * <code>string service_root_url = 6;</code>
     *
     * @return The serviceRootUrl.
     */
    public java.lang.String getServiceRootUrl() {
      java.lang.Object ref = serviceRootUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceRootUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the service root url if the default one (the service name
     * from the yaml file) is not suitable. This can be seen in any fully
     * specified service urls as well as sections that show a base that other
     * urls are relative to.
     * </pre>
     *
     * <code>string service_root_url = 6;</code>
     *
     * @return The bytes for serviceRootUrl.
     */
    public com.google.protobuf.ByteString getServiceRootUrlBytes() {
      java.lang.Object ref = serviceRootUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceRootUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the service root url if the default one (the service name
     * from the yaml file) is not suitable. This can be seen in any fully
     * specified service urls as well as sections that show a base that other
     * urls are relative to.
     * </pre>
     *
     * <code>string service_root_url = 6;</code>
     *
     * @param value The serviceRootUrl to set.
     * @return This builder for chaining.
     */
    public Builder setServiceRootUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceRootUrl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the service root url if the default one (the service name
     * from the yaml file) is not suitable. This can be seen in any fully
     * specified service urls as well as sections that show a base that other
     * urls are relative to.
     * </pre>
     *
     * <code>string service_root_url = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceRootUrl() {
      serviceRootUrl_ = getDefaultInstance().getServiceRootUrl();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the service root url if the default one (the service name
     * from the yaml file) is not suitable. This can be seen in any fully
     * specified service urls as well as sections that show a base that other
     * urls are relative to.
     * </pre>
     *
     * <code>string service_root_url = 6;</code>
     *
     * @param value The bytes for serviceRootUrl to set.
     * @return This builder for chaining.
     */
    public Builder setServiceRootUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceRootUrl_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object overview_ = "";
    /**
     *
     *
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     *
     * @return The overview.
     */
    public java.lang.String getOverview() {
      java.lang.Object ref = overview_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        overview_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     *
     * @return The bytes for overview.
     */
    public com.google.protobuf.ByteString getOverviewBytes() {
      java.lang.Object ref = overview_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        overview_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     *
     * @param value The overview to set.
     * @return This builder for chaining.
     */
    public Builder setOverview(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      overview_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverview() {
      overview_ = getDefaultInstance().getOverview();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     *
     * @param value The bytes for overview to set.
     * @return This builder for chaining.
     */
    public Builder setOverviewBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      overview_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Documentation)
  }

  // @@protoc_insertion_point(class_scope:google.api.Documentation)
  private static final com.google.api.Documentation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Documentation();
  }

  public static com.google.api.Documentation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Documentation> PARSER =
      new com.google.protobuf.AbstractParser<Documentation>() {
        @java.lang.Override
        public Documentation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Documentation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Documentation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.Documentation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
