/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/endpoint.proto

// Protobuf Java Version: 3.25.2
package com.google.api;

/**
 *
 *
 * <pre>
 * `Endpoint` describes a network address of a service that serves a set of
 * APIs. It is commonly known as a service endpoint. A service may expose
 * any number of service endpoints, and all service endpoints share the same
 * service definition, such as quota limits and monitoring metrics.
 *
 * Example:
 *
 *     type: google.api.Service
 *     name: library-example.googleapis.com
 *     endpoints:
 *       # Declares network address `https://library-example.googleapis.com`
 *       # for service `library-example.googleapis.com`. The `https` scheme
 *       # is implicit for all service endpoints. Other schemes may be
 *       # supported in the future.
 *     - name: library-example.googleapis.com
 *       allow_cors: false
 *     - name: content-staging-library-example.googleapis.com
 *       # Allows HTTP OPTIONS calls to be passed to the API frontend, for it
 *       # to decide whether the subsequent cross-origin request is allowed
 *       # to proceed.
 *       allow_cors: true
 * </pre>
 *
 * Protobuf type {@code google.api.Endpoint}
 */
public final class Endpoint extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.Endpoint)
    EndpointOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Endpoint.newBuilder() to construct.
  private Endpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Endpoint() {
    name_ = "";
    aliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
    target_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Endpoint();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.EndpointProto.internal_static_google_api_Endpoint_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.EndpointProto.internal_static_google_api_Endpoint_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.Endpoint.class, com.google.api.Endpoint.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The canonical name of this endpoint.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The canonical name of this endpoint.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALIASES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList aliases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Unimplemented. Dot not use.
   *
   * DEPRECATED: This field is no longer supported. Instead of using aliases,
   * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
   * of the intended aliases.
   *
   * Additional names that this endpoint will be hosted on.
   * </pre>
   *
   * <code>repeated string aliases = 2 [deprecated = true];</code>
   *
   * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
   * @return A list containing the aliases.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ProtocolStringList getAliasesList() {
    return aliases_;
  }
  /**
   *
   *
   * <pre>
   * Unimplemented. Dot not use.
   *
   * DEPRECATED: This field is no longer supported. Instead of using aliases,
   * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
   * of the intended aliases.
   *
   * Additional names that this endpoint will be hosted on.
   * </pre>
   *
   * <code>repeated string aliases = 2 [deprecated = true];</code>
   *
   * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
   * @return The count of aliases.
   */
  @java.lang.Deprecated
  public int getAliasesCount() {
    return aliases_.size();
  }
  /**
   *
   *
   * <pre>
   * Unimplemented. Dot not use.
   *
   * DEPRECATED: This field is no longer supported. Instead of using aliases,
   * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
   * of the intended aliases.
   *
   * Additional names that this endpoint will be hosted on.
   * </pre>
   *
   * <code>repeated string aliases = 2 [deprecated = true];</code>
   *
   * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
   * @param index The index of the element to return.
   * @return The aliases at the given index.
   */
  @java.lang.Deprecated
  public java.lang.String getAliases(int index) {
    return aliases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Unimplemented. Dot not use.
   *
   * DEPRECATED: This field is no longer supported. Instead of using aliases,
   * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
   * of the intended aliases.
   *
   * Additional names that this endpoint will be hosted on.
   * </pre>
   *
   * <code>repeated string aliases = 2 [deprecated = true];</code>
   *
   * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
   * @param index The index of the value to return.
   * @return The bytes of the aliases at the given index.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getAliasesBytes(int index) {
    return aliases_.getByteString(index);
  }

  public static final int TARGET_FIELD_NUMBER = 101;

  @SuppressWarnings("serial")
  private volatile java.lang.Object target_ = "";
  /**
   *
   *
   * <pre>
   * The specification of an Internet routable address of API frontend that will
   * handle requests to this [API
   * Endpoint](https://cloud.google.com/apis/design/glossary). It should be
   * either a valid IPv4 address or a fully-qualified domain name. For example,
   * "8.8.8.8" or "myservice.appspot.com".
   * </pre>
   *
   * <code>string target = 101;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The specification of an Internet routable address of API frontend that will
   * handle requests to this [API
   * Endpoint](https://cloud.google.com/apis/design/glossary). It should be
   * either a valid IPv4 address or a fully-qualified domain name. For example,
   * "8.8.8.8" or "myservice.appspot.com".
   * </pre>
   *
   * <code>string target = 101;</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALLOW_CORS_FIELD_NUMBER = 5;
  private boolean allowCors_ = false;
  /**
   *
   *
   * <pre>
   * Allowing
   * [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
   * cross-domain traffic, would allow the backends served from this endpoint to
   * receive and respond to HTTP OPTIONS requests. The response will be used by
   * the browser to determine whether the subsequent cross-origin request is
   * allowed to proceed.
   * </pre>
   *
   * <code>bool allow_cors = 5;</code>
   *
   * @return The allowCors.
   */
  @java.lang.Override
  public boolean getAllowCors() {
    return allowCors_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < aliases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, aliases_.getRaw(i));
    }
    if (allowCors_ != false) {
      output.writeBool(5, allowCors_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 101, target_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < aliases_.size(); i++) {
        dataSize += computeStringSizeNoTag(aliases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAliasesList().size();
    }
    if (allowCors_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, allowCors_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(101, target_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Endpoint)) {
      return super.equals(obj);
    }
    com.google.api.Endpoint other = (com.google.api.Endpoint) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAliasesList().equals(other.getAliasesList())) return false;
    if (!getTarget().equals(other.getTarget())) return false;
    if (getAllowCors() != other.getAllowCors()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getAliasesCount() > 0) {
      hash = (37 * hash) + ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + getAliasesList().hashCode();
    }
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget().hashCode();
    hash = (37 * hash) + ALLOW_CORS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowCors());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.Endpoint parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Endpoint parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Endpoint parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Endpoint parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Endpoint parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.Endpoint parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.Endpoint parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.Endpoint parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.Endpoint parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.Endpoint parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.Endpoint parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.Endpoint parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.Endpoint prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `Endpoint` describes a network address of a service that serves a set of
   * APIs. It is commonly known as a service endpoint. A service may expose
   * any number of service endpoints, and all service endpoints share the same
   * service definition, such as quota limits and monitoring metrics.
   *
   * Example:
   *
   *     type: google.api.Service
   *     name: library-example.googleapis.com
   *     endpoints:
   *       # Declares network address `https://library-example.googleapis.com`
   *       # for service `library-example.googleapis.com`. The `https` scheme
   *       # is implicit for all service endpoints. Other schemes may be
   *       # supported in the future.
   *     - name: library-example.googleapis.com
   *       allow_cors: false
   *     - name: content-staging-library-example.googleapis.com
   *       # Allows HTTP OPTIONS calls to be passed to the API frontend, for it
   *       # to decide whether the subsequent cross-origin request is allowed
   *       # to proceed.
   *       allow_cors: true
   * </pre>
   *
   * Protobuf type {@code google.api.Endpoint}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.Endpoint)
      com.google.api.EndpointOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.EndpointProto.internal_static_google_api_Endpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.EndpointProto.internal_static_google_api_Endpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.Endpoint.class, com.google.api.Endpoint.Builder.class);
    }

    // Construct using com.google.api.Endpoint.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      aliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      target_ = "";
      allowCors_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.EndpointProto.internal_static_google_api_Endpoint_descriptor;
    }

    @java.lang.Override
    public com.google.api.Endpoint getDefaultInstanceForType() {
      return com.google.api.Endpoint.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.Endpoint build() {
      com.google.api.Endpoint result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.Endpoint buildPartial() {
      com.google.api.Endpoint result = new com.google.api.Endpoint(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.api.Endpoint result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        aliases_.makeImmutable();
        result.aliases_ = aliases_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.target_ = target_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.allowCors_ = allowCors_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Endpoint) {
        return mergeFrom((com.google.api.Endpoint) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.Endpoint other) {
      if (other == com.google.api.Endpoint.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.aliases_.isEmpty()) {
        if (aliases_.isEmpty()) {
          aliases_ = other.aliases_;
          bitField0_ |= 0x00000002;
        } else {
          ensureAliasesIsMutable();
          aliases_.addAll(other.aliases_);
        }
        onChanged();
      }
      if (!other.getTarget().isEmpty()) {
        target_ = other.target_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getAllowCors() != false) {
        setAllowCors(other.getAllowCors());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAliasesIsMutable();
                aliases_.add(s);
                break;
              } // case 18
            case 40:
              {
                allowCors_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 810:
              {
                target_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 810
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The canonical name of this endpoint.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList aliases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAliasesIsMutable() {
      if (!aliases_.isModifiable()) {
        aliases_ = new com.google.protobuf.LazyStringArrayList(aliases_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @return A list containing the aliases.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getAliasesList() {
      aliases_.makeImmutable();
      return aliases_;
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @return The count of aliases.
     */
    @java.lang.Deprecated
    public int getAliasesCount() {
      return aliases_.size();
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @param index The index of the element to return.
     * @return The aliases at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getAliases(int index) {
      return aliases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @param index The index of the value to return.
     * @return The bytes of the aliases at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getAliasesBytes(int index) {
      return aliases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @param index The index to set the value at.
     * @param value The aliases to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setAliases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAliasesIsMutable();
      aliases_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @param value The aliases to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAliases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAliasesIsMutable();
      aliases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @param values The aliases to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllAliases(java.lang.Iterable<java.lang.String> values) {
      ensureAliasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aliases_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearAliases() {
      aliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unimplemented. Dot not use.
     *
     * DEPRECATED: This field is no longer supported. Instead of using aliases,
     * please specify multiple [google.api.Endpoint][google.api.Endpoint] for each
     * of the intended aliases.
     *
     * Additional names that this endpoint will be hosted on.
     * </pre>
     *
     * <code>repeated string aliases = 2 [deprecated = true];</code>
     *
     * @deprecated google.api.Endpoint.aliases is deprecated. See google/api/endpoint.proto;l=56
     * @param value The bytes of the aliases to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAliasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAliasesIsMutable();
      aliases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API
     * Endpoint](https://cloud.google.com/apis/design/glossary). It should be
     * either a valid IPv4 address or a fully-qualified domain name. For example,
     * "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API
     * Endpoint](https://cloud.google.com/apis/design/glossary). It should be
     * either a valid IPv4 address or a fully-qualified domain name. For example,
     * "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API
     * Endpoint](https://cloud.google.com/apis/design/glossary). It should be
     * either a valid IPv4 address or a fully-qualified domain name. For example,
     * "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      target_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API
     * Endpoint](https://cloud.google.com/apis/design/glossary). It should be
     * either a valid IPv4 address or a fully-qualified domain name. For example,
     * "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      target_ = getDefaultInstance().getTarget();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The specification of an Internet routable address of API frontend that will
     * handle requests to this [API
     * Endpoint](https://cloud.google.com/apis/design/glossary). It should be
     * either a valid IPv4 address or a fully-qualified domain name. For example,
     * "8.8.8.8" or "myservice.appspot.com".
     * </pre>
     *
     * <code>string target = 101;</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      target_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean allowCors_;
    /**
     *
     *
     * <pre>
     * Allowing
     * [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
     * cross-domain traffic, would allow the backends served from this endpoint to
     * receive and respond to HTTP OPTIONS requests. The response will be used by
     * the browser to determine whether the subsequent cross-origin request is
     * allowed to proceed.
     * </pre>
     *
     * <code>bool allow_cors = 5;</code>
     *
     * @return The allowCors.
     */
    @java.lang.Override
    public boolean getAllowCors() {
      return allowCors_;
    }
    /**
     *
     *
     * <pre>
     * Allowing
     * [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
     * cross-domain traffic, would allow the backends served from this endpoint to
     * receive and respond to HTTP OPTIONS requests. The response will be used by
     * the browser to determine whether the subsequent cross-origin request is
     * allowed to proceed.
     * </pre>
     *
     * <code>bool allow_cors = 5;</code>
     *
     * @param value The allowCors to set.
     * @return This builder for chaining.
     */
    public Builder setAllowCors(boolean value) {

      allowCors_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allowing
     * [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
     * cross-domain traffic, would allow the backends served from this endpoint to
     * receive and respond to HTTP OPTIONS requests. The response will be used by
     * the browser to determine whether the subsequent cross-origin request is
     * allowed to proceed.
     * </pre>
     *
     * <code>bool allow_cors = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowCors() {
      bitField0_ = (bitField0_ & ~0x00000008);
      allowCors_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.Endpoint)
  }

  // @@protoc_insertion_point(class_scope:google.api.Endpoint)
  private static final com.google.api.Endpoint DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Endpoint();
  }

  public static com.google.api.Endpoint getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Endpoint> PARSER =
      new com.google.protobuf.AbstractParser<Endpoint>() {
        @java.lang.Override
        public Endpoint parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Endpoint> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Endpoint> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.Endpoint getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
