/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.events.subscriptions.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SubscriptionName
implements ResourceName {
    private static final PathTemplate SUBSCRIPTION = PathTemplate.createWithoutUrlEncoding((String)"subscriptions/{subscription}");
    private volatile Map<String, String> fieldValuesMap;
    private final String subscription;

    @Deprecated
    protected SubscriptionName() {
        this.subscription = null;
    }

    private SubscriptionName(Builder builder) {
        this.subscription = (String)Preconditions.checkNotNull((Object)builder.getSubscription());
    }

    public String getSubscription() {
        return this.subscription;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SubscriptionName of(String subscription) {
        return SubscriptionName.newBuilder().setSubscription(subscription).build();
    }

    public static String format(String subscription) {
        return SubscriptionName.newBuilder().setSubscription(subscription).build().toString();
    }

    public static SubscriptionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SUBSCRIPTION.validatedMatch(formattedString, "SubscriptionName.parse: formattedString not in valid format");
        return SubscriptionName.of((String)matchMap.get("subscription"));
    }

    public static List<SubscriptionName> parseList(List<String> formattedStrings) {
        ArrayList<SubscriptionName> list = new ArrayList<SubscriptionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SubscriptionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SubscriptionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SubscriptionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SUBSCRIPTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SubscriptionName subscriptionName = this;
            synchronized (subscriptionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.subscription != null) {
                        fieldMapBuilder.put((Object)"subscription", (Object)this.subscription);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SUBSCRIPTION.instantiate(new String[]{"subscription", this.subscription});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SubscriptionName that = (SubscriptionName)o;
            return Objects.equals(this.subscription, that.subscription);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.subscription);
    }

    public static class Builder {
        private String subscription;

        protected Builder() {
        }

        public String getSubscription() {
            return this.subscription;
        }

        public Builder setSubscription(String subscription) {
            this.subscription = subscription;
            return this;
        }

        private Builder(SubscriptionName subscriptionName) {
            this.subscription = subscriptionName.subscription;
        }

        public SubscriptionName build() {
            return new SubscriptionName(this);
        }
    }
}

