/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.executions.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExecutionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workflow;
    private final String execution;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public String getExecution() {
        return this.execution;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ExecutionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workflow = (String)Preconditions.checkNotNull((Object)builder.getWorkflow());
        this.execution = (String)Preconditions.checkNotNull((Object)builder.getExecution());
    }

    public static ExecutionName of(String project, String location, String workflow, String execution) {
        return ExecutionName.newBuilder().setProject(project).setLocation(location).setWorkflow(workflow).setExecution(execution).build();
    }

    public static String format(String project, String location, String workflow, String execution) {
        return ExecutionName.newBuilder().setProject(project).setLocation(location).setWorkflow(workflow).setExecution(execution).build().toString();
    }

    public static ExecutionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ExecutionName.parse: formattedString not in valid format");
        return ExecutionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("workflow"), (String)matchMap.get("execution"));
    }

    public static List<ExecutionName> parseList(List<String> formattedStrings) {
        ArrayList<ExecutionName> list = new ArrayList<ExecutionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExecutionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExecutionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExecutionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExecutionName executionName = this;
            synchronized (executionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"workflow", (Object)this.workflow);
                    fieldMapBuilder.put((Object)"execution", (Object)this.execution);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "workflow", this.workflow, "execution", this.execution});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExecutionName) {
            ExecutionName that = (ExecutionName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.workflow.equals(that.workflow) && this.execution.equals(that.execution);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.workflow.hashCode();
        h *= 1000003;
        return h ^= this.execution.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String workflow;
        private String execution;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public String getExecution() {
            return this.execution;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkflow(String workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder setExecution(String execution) {
            this.execution = execution;
            return this;
        }

        private Builder() {
        }

        private Builder(ExecutionName executionName) {
            this.project = executionName.project;
            this.location = executionName.location;
            this.workflow = executionName.workflow;
            this.execution = executionName.execution;
        }

        public ExecutionName build() {
            return new ExecutionName(this);
        }
    }
}

