/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.workflows.executions.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
@Generated("by gapic-generator-java")
public class ExecutionName implements ResourceName {
  private static final PathTemplate PROJECT_LOCATION_WORKFLOW_EXECUTION =
      PathTemplate.createWithoutUrlEncoding(
          "projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}");
  private volatile Map<String, String> fieldValuesMap;
  private final String project;
  private final String location;
  private final String workflow;
  private final String execution;

  @Deprecated
  protected ExecutionName() {
    project = null;
    location = null;
    workflow = null;
    execution = null;
  }

  private ExecutionName(Builder builder) {
    project = Preconditions.checkNotNull(builder.getProject());
    location = Preconditions.checkNotNull(builder.getLocation());
    workflow = Preconditions.checkNotNull(builder.getWorkflow());
    execution = Preconditions.checkNotNull(builder.getExecution());
  }

  public String getProject() {
    return project;
  }

  public String getLocation() {
    return location;
  }

  public String getWorkflow() {
    return workflow;
  }

  public String getExecution() {
    return execution;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Builder toBuilder() {
    return new Builder(this);
  }

  public static ExecutionName of(
      String project, String location, String workflow, String execution) {
    return newBuilder()
        .setProject(project)
        .setLocation(location)
        .setWorkflow(workflow)
        .setExecution(execution)
        .build();
  }

  public static String format(String project, String location, String workflow, String execution) {
    return newBuilder()
        .setProject(project)
        .setLocation(location)
        .setWorkflow(workflow)
        .setExecution(execution)
        .build()
        .toString();
  }

  public static ExecutionName parse(String formattedString) {
    if (formattedString.isEmpty()) {
      return null;
    }
    Map<String, String> matchMap =
        PROJECT_LOCATION_WORKFLOW_EXECUTION.validatedMatch(
            formattedString, "ExecutionName.parse: formattedString not in valid format");
    return of(
        matchMap.get("project"),
        matchMap.get("location"),
        matchMap.get("workflow"),
        matchMap.get("execution"));
  }

  public static List<ExecutionName> parseList(List<String> formattedStrings) {
    List<ExecutionName> list = new ArrayList<>(formattedStrings.size());
    for (String formattedString : formattedStrings) {
      list.add(parse(formattedString));
    }
    return list;
  }

  public static List<String> toStringList(List<ExecutionName> values) {
    List<String> list = new ArrayList<>(values.size());
    for (ExecutionName value : values) {
      if (value == null) {
        list.add("");
      } else {
        list.add(value.toString());
      }
    }
    return list;
  }

  public static boolean isParsableFrom(String formattedString) {
    return PROJECT_LOCATION_WORKFLOW_EXECUTION.matches(formattedString);
  }

  @Override
  public Map<String, String> getFieldValuesMap() {
    if (fieldValuesMap == null) {
      synchronized (this) {
        if (fieldValuesMap == null) {
          ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
          if (project != null) {
            fieldMapBuilder.put("project", project);
          }
          if (location != null) {
            fieldMapBuilder.put("location", location);
          }
          if (workflow != null) {
            fieldMapBuilder.put("workflow", workflow);
          }
          if (execution != null) {
            fieldMapBuilder.put("execution", execution);
          }
          fieldValuesMap = fieldMapBuilder.build();
        }
      }
    }
    return fieldValuesMap;
  }

  public String getFieldValue(String fieldName) {
    return getFieldValuesMap().get(fieldName);
  }

  @Override
  public String toString() {
    return PROJECT_LOCATION_WORKFLOW_EXECUTION.instantiate(
        "project", project, "location", location, "workflow", workflow, "execution", execution);
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o != null && getClass() == o.getClass()) {
      ExecutionName that = ((ExecutionName) o);
      return Objects.equals(this.project, that.project)
          && Objects.equals(this.location, that.location)
          && Objects.equals(this.workflow, that.workflow)
          && Objects.equals(this.execution, that.execution);
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= Objects.hashCode(project);
    h *= 1000003;
    h ^= Objects.hashCode(location);
    h *= 1000003;
    h ^= Objects.hashCode(workflow);
    h *= 1000003;
    h ^= Objects.hashCode(execution);
    return h;
  }

  /**
   * Builder for
   * projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}.
   */
  public static class Builder {
    private String project;
    private String location;
    private String workflow;
    private String execution;

    protected Builder() {}

    public String getProject() {
      return project;
    }

    public String getLocation() {
      return location;
    }

    public String getWorkflow() {
      return workflow;
    }

    public String getExecution() {
      return execution;
    }

    public Builder setProject(String project) {
      this.project = project;
      return this;
    }

    public Builder setLocation(String location) {
      this.location = location;
      return this;
    }

    public Builder setWorkflow(String workflow) {
      this.workflow = workflow;
      return this;
    }

    public Builder setExecution(String execution) {
      this.execution = execution;
      return this;
    }

    private Builder(ExecutionName executionName) {
      this.project = executionName.project;
      this.location = executionName.location;
      this.workflow = executionName.workflow;
      this.execution = executionName.execution;
    }

    public ExecutionName build() {
      return new ExecutionName(this);
    }
  }
}
