/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.websecurityscanner.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScanRunName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/scanConfigs/{scan_config}/scanRuns/{scan_run}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String scanConfig;
    private final String scanRun;

    public String getProject() {
        return this.project;
    }

    public String getScanConfig() {
        return this.scanConfig;
    }

    public String getScanRun() {
        return this.scanRun;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ScanRunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.scanConfig = (String)Preconditions.checkNotNull((Object)builder.getScanConfig());
        this.scanRun = (String)Preconditions.checkNotNull((Object)builder.getScanRun());
    }

    public static ScanRunName of(String project, String scanConfig, String scanRun) {
        return ScanRunName.newBuilder().setProject(project).setScanConfig(scanConfig).setScanRun(scanRun).build();
    }

    public static String format(String project, String scanConfig, String scanRun) {
        return ScanRunName.newBuilder().setProject(project).setScanConfig(scanConfig).setScanRun(scanRun).build().toString();
    }

    public static ScanRunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ScanRunName.parse: formattedString not in valid format");
        return ScanRunName.of((String)matchMap.get("project"), (String)matchMap.get("scan_config"), (String)matchMap.get("scan_run"));
    }

    public static List<ScanRunName> parseList(List<String> formattedStrings) {
        ArrayList<ScanRunName> list = new ArrayList<ScanRunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ScanRunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ScanRunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ScanRunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ScanRunName scanRunName = this;
            synchronized (scanRunName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"scanConfig", (Object)this.scanConfig);
                    fieldMapBuilder.put((Object)"scanRun", (Object)this.scanRun);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "scan_config", this.scanConfig, "scan_run", this.scanRun});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ScanRunName) {
            ScanRunName that = (ScanRunName)o;
            return this.project.equals(that.project) && this.scanConfig.equals(that.scanConfig) && this.scanRun.equals(that.scanRun);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.scanConfig.hashCode();
        h *= 1000003;
        return h ^= this.scanRun.hashCode();
    }

    public static class Builder {
        private String project;
        private String scanConfig;
        private String scanRun;

        public String getProject() {
            return this.project;
        }

        public String getScanConfig() {
            return this.scanConfig;
        }

        public String getScanRun() {
            return this.scanRun;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setScanConfig(String scanConfig) {
            this.scanConfig = scanConfig;
            return this;
        }

        public Builder setScanRun(String scanRun) {
            this.scanRun = scanRun;
            return this;
        }

        private Builder() {
        }

        private Builder(ScanRunName scanRunName) {
            this.project = scanRunName.project;
            this.scanConfig = scanRunName.scanConfig;
            this.scanRun = scanRunName.scanRun;
        }

        public ScanRunName build() {
            return new ScanRunName(this);
        }
    }
}

