/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.cloud.vmwareengine.v1.NodeTypeOrBuilder;
import com.google.cloud.vmwareengine.v1.VmwareengineResourcesProto;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class NodeType
extends GeneratedMessageV3
implements NodeTypeOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int NODE_TYPE_ID_FIELD_NUMBER = 2;
    private volatile Object nodeTypeId_ = "";
    public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
    private volatile Object displayName_ = "";
    public static final int VIRTUAL_CPU_COUNT_FIELD_NUMBER = 4;
    private int virtualCpuCount_ = 0;
    public static final int TOTAL_CORE_COUNT_FIELD_NUMBER = 5;
    private int totalCoreCount_ = 0;
    public static final int MEMORY_GB_FIELD_NUMBER = 7;
    private int memoryGb_ = 0;
    public static final int DISK_SIZE_GB_FIELD_NUMBER = 8;
    private int diskSizeGb_ = 0;
    public static final int AVAILABLE_CUSTOM_CORE_COUNTS_FIELD_NUMBER = 11;
    private Internal.IntList availableCustomCoreCounts_;
    private int availableCustomCoreCountsMemoizedSerializedSize = -1;
    public static final int KIND_FIELD_NUMBER = 12;
    private int kind_ = 0;
    public static final int FAMILIES_FIELD_NUMBER = 13;
    private LazyStringArrayList families_ = LazyStringArrayList.emptyList();
    public static final int CAPABILITIES_FIELD_NUMBER = 14;
    private List<Integer> capabilities_;
    private static final Internal.ListAdapter.Converter<Integer, Capability> capabilities_converter_ = new Internal.ListAdapter.Converter<Integer, Capability>(){

        public Capability convert(Integer from) {
            Capability result = Capability.forNumber(from);
            return result == null ? Capability.UNRECOGNIZED : result;
        }
    };
    private int capabilitiesMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final NodeType DEFAULT_INSTANCE = new NodeType();
    private static final Parser<NodeType> PARSER = new AbstractParser<NodeType>(){

        public NodeType parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = NodeType.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private NodeType(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private NodeType() {
        this.name_ = "";
        this.nodeTypeId_ = "";
        this.displayName_ = "";
        this.availableCustomCoreCounts_ = NodeType.emptyIntList();
        this.kind_ = 0;
        this.families_ = LazyStringArrayList.emptyList();
        this.capabilities_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new NodeType();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return VmwareengineResourcesProto.internal_static_google_cloud_vmwareengine_v1_NodeType_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return VmwareengineResourcesProto.internal_static_google_cloud_vmwareengine_v1_NodeType_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeType.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getNodeTypeId() {
        Object ref = this.nodeTypeId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.nodeTypeId_ = s;
        return s;
    }

    @Override
    public ByteString getNodeTypeIdBytes() {
        Object ref = this.nodeTypeId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.nodeTypeId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDisplayName() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.displayName_ = s;
        return s;
    }

    @Override
    public ByteString getDisplayNameBytes() {
        Object ref = this.displayName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.displayName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getVirtualCpuCount() {
        return this.virtualCpuCount_;
    }

    @Override
    public int getTotalCoreCount() {
        return this.totalCoreCount_;
    }

    @Override
    public int getMemoryGb() {
        return this.memoryGb_;
    }

    @Override
    public int getDiskSizeGb() {
        return this.diskSizeGb_;
    }

    @Override
    public List<Integer> getAvailableCustomCoreCountsList() {
        return this.availableCustomCoreCounts_;
    }

    @Override
    public int getAvailableCustomCoreCountsCount() {
        return this.availableCustomCoreCounts_.size();
    }

    @Override
    public int getAvailableCustomCoreCounts(int index) {
        return this.availableCustomCoreCounts_.getInt(index);
    }

    @Override
    public int getKindValue() {
        return this.kind_;
    }

    @Override
    public Kind getKind() {
        Kind result = Kind.forNumber(this.kind_);
        return result == null ? Kind.UNRECOGNIZED : result;
    }

    public ProtocolStringList getFamiliesList() {
        return this.families_;
    }

    @Override
    public int getFamiliesCount() {
        return this.families_.size();
    }

    @Override
    public String getFamilies(int index) {
        return this.families_.get(index);
    }

    @Override
    public ByteString getFamiliesBytes(int index) {
        return this.families_.getByteString(index);
    }

    @Override
    public List<Capability> getCapabilitiesList() {
        return new Internal.ListAdapter(this.capabilities_, capabilities_converter_);
    }

    @Override
    public int getCapabilitiesCount() {
        return this.capabilities_.size();
    }

    @Override
    public Capability getCapabilities(int index) {
        return (Capability)((Object)capabilities_converter_.convert((Object)this.capabilities_.get(index)));
    }

    @Override
    public List<Integer> getCapabilitiesValueList() {
        return this.capabilities_;
    }

    @Override
    public int getCapabilitiesValue(int index) {
        return this.capabilities_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.nodeTypeId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.nodeTypeId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.displayName_);
        }
        if (this.virtualCpuCount_ != 0) {
            output.writeInt32(4, this.virtualCpuCount_);
        }
        if (this.totalCoreCount_ != 0) {
            output.writeInt32(5, this.totalCoreCount_);
        }
        if (this.memoryGb_ != 0) {
            output.writeInt32(7, this.memoryGb_);
        }
        if (this.diskSizeGb_ != 0) {
            output.writeInt32(8, this.diskSizeGb_);
        }
        if (this.getAvailableCustomCoreCountsList().size() > 0) {
            output.writeUInt32NoTag(90);
            output.writeUInt32NoTag(this.availableCustomCoreCountsMemoizedSerializedSize);
        }
        for (i = 0; i < this.availableCustomCoreCounts_.size(); ++i) {
            output.writeInt32NoTag(this.availableCustomCoreCounts_.getInt(i));
        }
        if (this.kind_ != Kind.KIND_UNSPECIFIED.getNumber()) {
            output.writeEnum(12, this.kind_);
        }
        for (i = 0; i < this.families_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.families_.getRaw(i));
        }
        if (this.getCapabilitiesList().size() > 0) {
            output.writeUInt32NoTag(114);
            output.writeUInt32NoTag(this.capabilitiesMemoizedSerializedSize);
        }
        for (i = 0; i < this.capabilities_.size(); ++i) {
            output.writeEnumNoTag(this.capabilities_.get(i).intValue());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.nodeTypeId_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.nodeTypeId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.displayName_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.displayName_);
        }
        if (this.virtualCpuCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)4, (int)this.virtualCpuCount_);
        }
        if (this.totalCoreCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)5, (int)this.totalCoreCount_);
        }
        if (this.memoryGb_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)7, (int)this.memoryGb_);
        }
        if (this.diskSizeGb_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)8, (int)this.diskSizeGb_);
        }
        int dataSize = 0;
        for (i = 0; i < this.availableCustomCoreCounts_.size(); ++i) {
            dataSize += CodedOutputStream.computeInt32SizeNoTag((int)this.availableCustomCoreCounts_.getInt(i));
        }
        size += dataSize;
        if (!this.getAvailableCustomCoreCountsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
        }
        this.availableCustomCoreCountsMemoizedSerializedSize = dataSize;
        if (this.kind_ != Kind.KIND_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)12, (int)this.kind_);
        }
        dataSize = 0;
        for (i = 0; i < this.families_.size(); ++i) {
            dataSize += NodeType.computeStringSizeNoTag((Object)this.families_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getFamiliesList().size();
        dataSize = 0;
        for (i = 0; i < this.capabilities_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.capabilities_.get(i));
        }
        size += dataSize;
        if (!this.getCapabilitiesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.capabilitiesMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeType)) {
            return super.equals(obj);
        }
        NodeType other = (NodeType)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getNodeTypeId().equals(other.getNodeTypeId())) {
            return false;
        }
        if (!this.getDisplayName().equals(other.getDisplayName())) {
            return false;
        }
        if (this.getVirtualCpuCount() != other.getVirtualCpuCount()) {
            return false;
        }
        if (this.getTotalCoreCount() != other.getTotalCoreCount()) {
            return false;
        }
        if (this.getMemoryGb() != other.getMemoryGb()) {
            return false;
        }
        if (this.getDiskSizeGb() != other.getDiskSizeGb()) {
            return false;
        }
        if (!this.getAvailableCustomCoreCountsList().equals(other.getAvailableCustomCoreCountsList())) {
            return false;
        }
        if (this.kind_ != other.kind_) {
            return false;
        }
        if (!this.getFamiliesList().equals(other.getFamiliesList())) {
            return false;
        }
        if (!this.capabilities_.equals(other.capabilities_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + NodeType.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getNodeTypeId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getDisplayName().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getVirtualCpuCount();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getTotalCoreCount();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getMemoryGb();
        hash = 37 * hash + 8;
        hash = 53 * hash + this.getDiskSizeGb();
        if (this.getAvailableCustomCoreCountsCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getAvailableCustomCoreCountsList().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.kind_;
        if (this.getFamiliesCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getFamiliesList().hashCode();
        }
        if (this.getCapabilitiesCount() > 0) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.capabilities_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static NodeType parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (NodeType)PARSER.parseFrom(data);
    }

    public static NodeType parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeType)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeType parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (NodeType)PARSER.parseFrom(data);
    }

    public static NodeType parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeType)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeType parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (NodeType)PARSER.parseFrom(data);
    }

    public static NodeType parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NodeType)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NodeType parseFrom(InputStream input) throws IOException {
        return (NodeType)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static NodeType parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeType)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NodeType parseDelimitedFrom(InputStream input) throws IOException {
        return (NodeType)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static NodeType parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeType)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NodeType parseFrom(CodedInputStream input) throws IOException {
        return (NodeType)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static NodeType parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NodeType)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return NodeType.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NodeType prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static NodeType getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<NodeType> parser() {
        return PARSER;
    }

    public Parser<NodeType> getParserForType() {
        return PARSER;
    }

    public NodeType getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.IntList access$1800() {
        return NodeType.emptyIntList();
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements NodeTypeOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private Object nodeTypeId_ = "";
        private Object displayName_ = "";
        private int virtualCpuCount_;
        private int totalCoreCount_;
        private int memoryGb_;
        private int diskSizeGb_;
        private Internal.IntList availableCustomCoreCounts_ = NodeType.access$1800();
        private int kind_ = 0;
        private LazyStringArrayList families_ = LazyStringArrayList.emptyList();
        private List<Integer> capabilities_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return VmwareengineResourcesProto.internal_static_google_cloud_vmwareengine_v1_NodeType_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return VmwareengineResourcesProto.internal_static_google_cloud_vmwareengine_v1_NodeType_fieldAccessorTable.ensureFieldAccessorsInitialized(NodeType.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.nodeTypeId_ = "";
            this.displayName_ = "";
            this.virtualCpuCount_ = 0;
            this.totalCoreCount_ = 0;
            this.memoryGb_ = 0;
            this.diskSizeGb_ = 0;
            this.availableCustomCoreCounts_ = NodeType.emptyIntList();
            this.kind_ = 0;
            this.families_ = LazyStringArrayList.emptyList();
            this.capabilities_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFBFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return VmwareengineResourcesProto.internal_static_google_cloud_vmwareengine_v1_NodeType_descriptor;
        }

        public NodeType getDefaultInstanceForType() {
            return NodeType.getDefaultInstance();
        }

        public NodeType build() {
            NodeType result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public NodeType buildPartial() {
            NodeType result = new NodeType(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(NodeType result) {
            if ((this.bitField0_ & 0x80) != 0) {
                this.availableCustomCoreCounts_.makeImmutable();
                this.bitField0_ &= 0xFFFFFF7F;
            }
            result.availableCustomCoreCounts_ = this.availableCustomCoreCounts_;
            if ((this.bitField0_ & 0x400) != 0) {
                this.capabilities_ = Collections.unmodifiableList(this.capabilities_);
                this.bitField0_ &= 0xFFFFFBFF;
            }
            result.capabilities_ = this.capabilities_;
        }

        private void buildPartial0(NodeType result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.nodeTypeId_ = this.nodeTypeId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.displayName_ = this.displayName_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.virtualCpuCount_ = this.virtualCpuCount_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.totalCoreCount_ = this.totalCoreCount_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.memoryGb_ = this.memoryGb_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.diskSizeGb_ = this.diskSizeGb_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.kind_ = this.kind_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                this.families_.makeImmutable();
                result.families_ = this.families_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof NodeType) {
                return this.mergeFrom((NodeType)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(NodeType other) {
            if (other == NodeType.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getNodeTypeId().isEmpty()) {
                this.nodeTypeId_ = other.nodeTypeId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getDisplayName().isEmpty()) {
                this.displayName_ = other.displayName_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.getVirtualCpuCount() != 0) {
                this.setVirtualCpuCount(other.getVirtualCpuCount());
            }
            if (other.getTotalCoreCount() != 0) {
                this.setTotalCoreCount(other.getTotalCoreCount());
            }
            if (other.getMemoryGb() != 0) {
                this.setMemoryGb(other.getMemoryGb());
            }
            if (other.getDiskSizeGb() != 0) {
                this.setDiskSizeGb(other.getDiskSizeGb());
            }
            if (!other.availableCustomCoreCounts_.isEmpty()) {
                if (this.availableCustomCoreCounts_.isEmpty()) {
                    this.availableCustomCoreCounts_ = other.availableCustomCoreCounts_;
                    this.bitField0_ &= 0xFFFFFF7F;
                } else {
                    this.ensureAvailableCustomCoreCountsIsMutable();
                    this.availableCustomCoreCounts_.addAll((Collection)other.availableCustomCoreCounts_);
                }
                this.onChanged();
            }
            if (other.kind_ != 0) {
                this.setKindValue(other.getKindValue());
            }
            if (!other.families_.isEmpty()) {
                if (this.families_.isEmpty()) {
                    this.families_ = other.families_;
                    this.bitField0_ |= 0x200;
                } else {
                    this.ensureFamiliesIsMutable();
                    this.families_.addAll((Collection)other.families_);
                }
                this.onChanged();
            }
            if (!other.capabilities_.isEmpty()) {
                if (this.capabilities_.isEmpty()) {
                    this.capabilities_ = other.capabilities_;
                    this.bitField0_ &= 0xFFFFFBFF;
                } else {
                    this.ensureCapabilitiesIsMutable();
                    this.capabilities_.addAll(other.capabilities_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block21: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block21;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block21;
                        }
                        case 18: {
                            this.nodeTypeId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block21;
                        }
                        case 26: {
                            this.displayName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block21;
                        }
                        case 32: {
                            this.virtualCpuCount_ = input.readInt32();
                            this.bitField0_ |= 8;
                            continue block21;
                        }
                        case 40: {
                            this.totalCoreCount_ = input.readInt32();
                            this.bitField0_ |= 0x10;
                            continue block21;
                        }
                        case 56: {
                            this.memoryGb_ = input.readInt32();
                            this.bitField0_ |= 0x20;
                            continue block21;
                        }
                        case 64: {
                            this.diskSizeGb_ = input.readInt32();
                            this.bitField0_ |= 0x40;
                            continue block21;
                        }
                        case 88: {
                            int v = input.readInt32();
                            this.ensureAvailableCustomCoreCountsIsMutable();
                            this.availableCustomCoreCounts_.addInt(v);
                            continue block21;
                        }
                        case 90: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            this.ensureAvailableCustomCoreCountsIsMutable();
                            while (input.getBytesUntilLimit() > 0) {
                                this.availableCustomCoreCounts_.addInt(input.readInt32());
                            }
                            input.popLimit(limit);
                            continue block21;
                        }
                        case 96: {
                            this.kind_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block21;
                        }
                        case 106: {
                            String s = input.readStringRequireUtf8();
                            this.ensureFamiliesIsMutable();
                            this.families_.add((Object)s);
                            continue block21;
                        }
                        case 112: {
                            int tmpRaw = input.readEnum();
                            this.ensureCapabilitiesIsMutable();
                            this.capabilities_.add(tmpRaw);
                            continue block21;
                        }
                        case 114: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureCapabilitiesIsMutable();
                                this.capabilities_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block21;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = NodeType.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeType.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getNodeTypeId() {
            Object ref = this.nodeTypeId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.nodeTypeId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNodeTypeIdBytes() {
            Object ref = this.nodeTypeId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.nodeTypeId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNodeTypeId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.nodeTypeId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearNodeTypeId() {
            this.nodeTypeId_ = NodeType.getDefaultInstance().getNodeTypeId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setNodeTypeIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeType.checkByteStringIsUtf8((ByteString)value);
            this.nodeTypeId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getDisplayName() {
            Object ref = this.displayName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.displayName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDisplayNameBytes() {
            Object ref = this.displayName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.displayName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDisplayName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.displayName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearDisplayName() {
            this.displayName_ = NodeType.getDefaultInstance().getDisplayName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setDisplayNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeType.checkByteStringIsUtf8((ByteString)value);
            this.displayName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public int getVirtualCpuCount() {
            return this.virtualCpuCount_;
        }

        public Builder setVirtualCpuCount(int value) {
            this.virtualCpuCount_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearVirtualCpuCount() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.virtualCpuCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getTotalCoreCount() {
            return this.totalCoreCount_;
        }

        public Builder setTotalCoreCount(int value) {
            this.totalCoreCount_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearTotalCoreCount() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.totalCoreCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getMemoryGb() {
            return this.memoryGb_;
        }

        public Builder setMemoryGb(int value) {
            this.memoryGb_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearMemoryGb() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.memoryGb_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getDiskSizeGb() {
            return this.diskSizeGb_;
        }

        public Builder setDiskSizeGb(int value) {
            this.diskSizeGb_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearDiskSizeGb() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.diskSizeGb_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureAvailableCustomCoreCountsIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.availableCustomCoreCounts_ = NodeType.mutableCopy((Internal.IntList)this.availableCustomCoreCounts_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<Integer> getAvailableCustomCoreCountsList() {
            return (this.bitField0_ & 0x80) != 0 ? Collections.unmodifiableList(this.availableCustomCoreCounts_) : this.availableCustomCoreCounts_;
        }

        @Override
        public int getAvailableCustomCoreCountsCount() {
            return this.availableCustomCoreCounts_.size();
        }

        @Override
        public int getAvailableCustomCoreCounts(int index) {
            return this.availableCustomCoreCounts_.getInt(index);
        }

        public Builder setAvailableCustomCoreCounts(int index, int value) {
            this.ensureAvailableCustomCoreCountsIsMutable();
            this.availableCustomCoreCounts_.setInt(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAvailableCustomCoreCounts(int value) {
            this.ensureAvailableCustomCoreCountsIsMutable();
            this.availableCustomCoreCounts_.addInt(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAvailableCustomCoreCounts(Iterable<? extends Integer> values) {
            this.ensureAvailableCustomCoreCountsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.availableCustomCoreCounts_);
            this.onChanged();
            return this;
        }

        public Builder clearAvailableCustomCoreCounts() {
            this.availableCustomCoreCounts_ = NodeType.emptyIntList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        @Override
        public int getKindValue() {
            return this.kind_;
        }

        public Builder setKindValue(int value) {
            this.kind_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public Kind getKind() {
            Kind result = Kind.forNumber(this.kind_);
            return result == null ? Kind.UNRECOGNIZED : result;
        }

        public Builder setKind(Kind value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.kind_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearKind() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.kind_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureFamiliesIsMutable() {
            if (!this.families_.isModifiable()) {
                this.families_ = new LazyStringArrayList((LazyStringList)this.families_);
            }
            this.bitField0_ |= 0x200;
        }

        public ProtocolStringList getFamiliesList() {
            this.families_.makeImmutable();
            return this.families_;
        }

        @Override
        public int getFamiliesCount() {
            return this.families_.size();
        }

        @Override
        public String getFamilies(int index) {
            return this.families_.get(index);
        }

        @Override
        public ByteString getFamiliesBytes(int index) {
            return this.families_.getByteString(index);
        }

        public Builder setFamilies(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFamiliesIsMutable();
            this.families_.set(index, value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addFamilies(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureFamiliesIsMutable();
            this.families_.add((Object)value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder addAllFamilies(Iterable<String> values) {
            this.ensureFamiliesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.families_);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearFamilies() {
            this.families_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder addFamiliesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NodeType.checkByteStringIsUtf8((ByteString)value);
            this.ensureFamiliesIsMutable();
            this.families_.add(value);
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        private void ensureCapabilitiesIsMutable() {
            if ((this.bitField0_ & 0x400) == 0) {
                this.capabilities_ = new ArrayList<Integer>(this.capabilities_);
                this.bitField0_ |= 0x400;
            }
        }

        @Override
        public List<Capability> getCapabilitiesList() {
            return new Internal.ListAdapter(this.capabilities_, capabilities_converter_);
        }

        @Override
        public int getCapabilitiesCount() {
            return this.capabilities_.size();
        }

        @Override
        public Capability getCapabilities(int index) {
            return (Capability)((Object)capabilities_converter_.convert((Object)this.capabilities_.get(index)));
        }

        public Builder setCapabilities(int index, Capability value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCapabilitiesIsMutable();
            this.capabilities_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addCapabilities(Capability value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureCapabilitiesIsMutable();
            this.capabilities_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllCapabilities(Iterable<? extends Capability> values) {
            this.ensureCapabilitiesIsMutable();
            for (Capability capability : values) {
                this.capabilities_.add(capability.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearCapabilities() {
            this.capabilities_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFBFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getCapabilitiesValueList() {
            return Collections.unmodifiableList(this.capabilities_);
        }

        @Override
        public int getCapabilitiesValue(int index) {
            return this.capabilities_.get(index);
        }

        public Builder setCapabilitiesValue(int index, int value) {
            this.ensureCapabilitiesIsMutable();
            this.capabilities_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addCapabilitiesValue(int value) {
            this.ensureCapabilitiesIsMutable();
            this.capabilities_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllCapabilitiesValue(Iterable<Integer> values) {
            this.ensureCapabilitiesIsMutable();
            for (int value : values) {
                this.capabilities_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum Capability implements ProtocolMessageEnum
    {
        CAPABILITY_UNSPECIFIED(0),
        STRETCHED_CLUSTERS(1),
        UNRECOGNIZED(-1);

        public static final int CAPABILITY_UNSPECIFIED_VALUE = 0;
        public static final int STRETCHED_CLUSTERS_VALUE = 1;
        private static final Internal.EnumLiteMap<Capability> internalValueMap;
        private static final Capability[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Capability valueOf(int value) {
            return Capability.forNumber(value);
        }

        public static Capability forNumber(int value) {
            switch (value) {
                case 0: {
                    return CAPABILITY_UNSPECIFIED;
                }
                case 1: {
                    return STRETCHED_CLUSTERS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Capability> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Capability.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Capability.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)NodeType.getDescriptor().getEnumTypes().get(1);
        }

        public static Capability valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Capability.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Capability(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Capability>(){

                public Capability findValueByNumber(int number) {
                    return Capability.forNumber(number);
                }
            };
            VALUES = Capability.values();
        }
    }

    public static enum Kind implements ProtocolMessageEnum
    {
        KIND_UNSPECIFIED(0),
        STANDARD(1),
        STORAGE_ONLY(2),
        UNRECOGNIZED(-1);

        public static final int KIND_UNSPECIFIED_VALUE = 0;
        public static final int STANDARD_VALUE = 1;
        public static final int STORAGE_ONLY_VALUE = 2;
        private static final Internal.EnumLiteMap<Kind> internalValueMap;
        private static final Kind[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Kind valueOf(int value) {
            return Kind.forNumber(value);
        }

        public static Kind forNumber(int value) {
            switch (value) {
                case 0: {
                    return KIND_UNSPECIFIED;
                }
                case 1: {
                    return STANDARD;
                }
                case 2: {
                    return STORAGE_ONLY;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Kind> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Kind.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Kind.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)NodeType.getDescriptor().getEnumTypes().get(0);
        }

        public static Kind valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Kind.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Kind(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Kind>(){

                public Kind findValueByNumber(int number) {
                    return Kind.forNumber(number);
                }
            };
            VALUES = Kind.values();
        }
    }
}

