/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HcxActivationKeyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PRIVATE_CLOUD_HCX_ACTIVATION_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/privateClouds/{private_cloud}/hcxActivationKeys/{hcx_activation_key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String privateCloud;
    private final String hcxActivationKey;

    @Deprecated
    protected HcxActivationKeyName() {
        this.project = null;
        this.location = null;
        this.privateCloud = null;
        this.hcxActivationKey = null;
    }

    private HcxActivationKeyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.privateCloud = (String)Preconditions.checkNotNull((Object)builder.getPrivateCloud());
        this.hcxActivationKey = (String)Preconditions.checkNotNull((Object)builder.getHcxActivationKey());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPrivateCloud() {
        return this.privateCloud;
    }

    public String getHcxActivationKey() {
        return this.hcxActivationKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HcxActivationKeyName of(String project, String location, String privateCloud, String hcxActivationKey) {
        return HcxActivationKeyName.newBuilder().setProject(project).setLocation(location).setPrivateCloud(privateCloud).setHcxActivationKey(hcxActivationKey).build();
    }

    public static String format(String project, String location, String privateCloud, String hcxActivationKey) {
        return HcxActivationKeyName.newBuilder().setProject(project).setLocation(location).setPrivateCloud(privateCloud).setHcxActivationKey(hcxActivationKey).build().toString();
    }

    public static HcxActivationKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PRIVATE_CLOUD_HCX_ACTIVATION_KEY.validatedMatch(formattedString, "HcxActivationKeyName.parse: formattedString not in valid format");
        return HcxActivationKeyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("private_cloud"), (String)matchMap.get("hcx_activation_key"));
    }

    public static List<HcxActivationKeyName> parseList(List<String> formattedStrings) {
        ArrayList<HcxActivationKeyName> list = new ArrayList<HcxActivationKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HcxActivationKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HcxActivationKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HcxActivationKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PRIVATE_CLOUD_HCX_ACTIVATION_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HcxActivationKeyName hcxActivationKeyName = this;
            synchronized (hcxActivationKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.privateCloud != null) {
                        fieldMapBuilder.put((Object)"private_cloud", (Object)this.privateCloud);
                    }
                    if (this.hcxActivationKey != null) {
                        fieldMapBuilder.put((Object)"hcx_activation_key", (Object)this.hcxActivationKey);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PRIVATE_CLOUD_HCX_ACTIVATION_KEY.instantiate(new String[]{"project", this.project, "location", this.location, "private_cloud", this.privateCloud, "hcx_activation_key", this.hcxActivationKey});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            HcxActivationKeyName that = (HcxActivationKeyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.privateCloud, that.privateCloud) && Objects.equals(this.hcxActivationKey, that.hcxActivationKey);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.privateCloud);
        h *= 1000003;
        return h ^= Objects.hashCode(this.hcxActivationKey);
    }

    public static class Builder {
        private String project;
        private String location;
        private String privateCloud;
        private String hcxActivationKey;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrivateCloud() {
            return this.privateCloud;
        }

        public String getHcxActivationKey() {
            return this.hcxActivationKey;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPrivateCloud(String privateCloud) {
            this.privateCloud = privateCloud;
            return this;
        }

        public Builder setHcxActivationKey(String hcxActivationKey) {
            this.hcxActivationKey = hcxActivationKey;
            return this;
        }

        private Builder(HcxActivationKeyName hcxActivationKeyName) {
            this.project = hcxActivationKeyName.project;
            this.location = hcxActivationKeyName.location;
            this.privateCloud = hcxActivationKeyName.privateCloud;
            this.hcxActivationKey = hcxActivationKeyName.hcxActivationKey;
        }

        public HcxActivationKeyName build() {
            return new HcxActivationKeyName(this);
        }
    }
}

