/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ImageImportJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_JOB_RESULT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/imageImports/{job}/imageImportJobs/{result}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String job;
    private final String result;

    @Deprecated
    protected ImageImportJobName() {
        this.project = null;
        this.location = null;
        this.job = null;
        this.result = null;
    }

    private ImageImportJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.job = (String)Preconditions.checkNotNull((Object)builder.getJob());
        this.result = (String)Preconditions.checkNotNull((Object)builder.getResult());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getJob() {
        return this.job;
    }

    public String getResult() {
        return this.result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ImageImportJobName of(String project, String location, String job, String result) {
        return ImageImportJobName.newBuilder().setProject(project).setLocation(location).setJob(job).setResult(result).build();
    }

    public static String format(String project, String location, String job, String result) {
        return ImageImportJobName.newBuilder().setProject(project).setLocation(location).setJob(job).setResult(result).build().toString();
    }

    public static ImageImportJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_JOB_RESULT.validatedMatch(formattedString, "ImageImportJobName.parse: formattedString not in valid format");
        return ImageImportJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("job"), (String)matchMap.get("result"));
    }

    public static List<ImageImportJobName> parseList(List<String> formattedStrings) {
        ArrayList<ImageImportJobName> list = new ArrayList<ImageImportJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ImageImportJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ImageImportJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ImageImportJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_JOB_RESULT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ImageImportJobName imageImportJobName = this;
            synchronized (imageImportJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.job != null) {
                        fieldMapBuilder.put((Object)"job", (Object)this.job);
                    }
                    if (this.result != null) {
                        fieldMapBuilder.put((Object)"result", (Object)this.result);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_JOB_RESULT.instantiate(new String[]{"project", this.project, "location", this.location, "job", this.job, "result", this.result});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ImageImportJobName that = (ImageImportJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.job, that.job) && Objects.equals(this.result, that.result);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.job);
        h *= 1000003;
        return h ^= Objects.hashCode(this.result);
    }

    public static class Builder {
        private String project;
        private String location;
        private String job;
        private String result;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getJob() {
            return this.job;
        }

        public String getResult() {
            return this.result;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setJob(String job) {
            this.job = job;
            return this;
        }

        public Builder setResult(String result) {
            this.result = result;
            return this;
        }

        private Builder(ImageImportJobName imageImportJobName) {
            this.project = imageImportJobName.project;
            this.location = imageImportJobName.location;
            this.job = imageImportJobName.job;
            this.result = imageImportJobName.result;
        }

        public ImageImportJobName build() {
            return new ImageImportJobName(this);
        }
    }
}

