/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CutoverJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE_MIGRATING_VM_CUTOVER_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/cutoverJobs/{cutover_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;
    private final String migratingVm;
    private final String cutoverJob;

    @Deprecated
    protected CutoverJobName() {
        this.project = null;
        this.location = null;
        this.source = null;
        this.migratingVm = null;
        this.cutoverJob = null;
    }

    private CutoverJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.migratingVm = (String)Preconditions.checkNotNull((Object)builder.getMigratingVm());
        this.cutoverJob = (String)Preconditions.checkNotNull((Object)builder.getCutoverJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public String getMigratingVm() {
        return this.migratingVm;
    }

    public String getCutoverJob() {
        return this.cutoverJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CutoverJobName of(String project, String location, String source, String migratingVm, String cutoverJob) {
        return CutoverJobName.newBuilder().setProject(project).setLocation(location).setSource(source).setMigratingVm(migratingVm).setCutoverJob(cutoverJob).build();
    }

    public static String format(String project, String location, String source, String migratingVm, String cutoverJob) {
        return CutoverJobName.newBuilder().setProject(project).setLocation(location).setSource(source).setMigratingVm(migratingVm).setCutoverJob(cutoverJob).build().toString();
    }

    public static CutoverJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE_MIGRATING_VM_CUTOVER_JOB.validatedMatch(formattedString, "CutoverJobName.parse: formattedString not in valid format");
        return CutoverJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"), (String)matchMap.get("migrating_vm"), (String)matchMap.get("cutover_job"));
    }

    public static List<CutoverJobName> parseList(List<String> formattedStrings) {
        ArrayList<CutoverJobName> list = new ArrayList<CutoverJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CutoverJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CutoverJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CutoverJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE_MIGRATING_VM_CUTOVER_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CutoverJobName cutoverJobName = this;
            synchronized (cutoverJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.migratingVm != null) {
                        fieldMapBuilder.put((Object)"migrating_vm", (Object)this.migratingVm);
                    }
                    if (this.cutoverJob != null) {
                        fieldMapBuilder.put((Object)"cutover_job", (Object)this.cutoverJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE_MIGRATING_VM_CUTOVER_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source, "migrating_vm", this.migratingVm, "cutover_job", this.cutoverJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CutoverJobName that = (CutoverJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source) && Objects.equals(this.migratingVm, that.migratingVm) && Objects.equals(this.cutoverJob, that.cutoverJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        h ^= Objects.hashCode(this.migratingVm);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cutoverJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;
        private String migratingVm;
        private String cutoverJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public String getMigratingVm() {
            return this.migratingVm;
        }

        public String getCutoverJob() {
            return this.cutoverJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setMigratingVm(String migratingVm) {
            this.migratingVm = migratingVm;
            return this;
        }

        public Builder setCutoverJob(String cutoverJob) {
            this.cutoverJob = cutoverJob;
            return this;
        }

        private Builder(CutoverJobName cutoverJobName) {
            this.project = cutoverJobName.project;
            this.location = cutoverJobName.location;
            this.source = cutoverJobName.source;
            this.migratingVm = cutoverJobName.migratingVm;
            this.cutoverJob = cutoverJobName.cutoverJob;
        }

        public CutoverJobName build() {
            return new CutoverJobName(this);
        }
    }
}

