/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProcessName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_PROCESS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/processes/{process}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;
    private final String process;

    @Deprecated
    protected ProcessName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.process = null;
    }

    private ProcessName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.process = (String)Preconditions.checkNotNull((Object)builder.getProcess());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getProcess() {
        return this.process;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProcessName of(String project, String location, String cluster, String process) {
        return ProcessName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setProcess(process).build();
    }

    public static String format(String project, String location, String cluster, String process) {
        return ProcessName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setProcess(process).build().toString();
    }

    public static ProcessName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER_PROCESS.validatedMatch(formattedString, "ProcessName.parse: formattedString not in valid format");
        return ProcessName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("process"));
    }

    public static List<ProcessName> parseList(List<String> formattedStrings) {
        ArrayList<ProcessName> list = new ArrayList<ProcessName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProcessName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProcessName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProcessName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER_PROCESS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProcessName processName = this;
            synchronized (processName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.process != null) {
                        fieldMapBuilder.put((Object)"process", (Object)this.process);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER_PROCESS.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster, "process", this.process});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProcessName that = (ProcessName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.process, that.process);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.process);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;
        private String process;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getProcess() {
            return this.process;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setProcess(String process) {
            this.process = process;
            return this;
        }

        private Builder(ProcessName processName) {
            this.project = processName.project;
            this.location = processName.location;
            this.cluster = processName.cluster;
            this.process = processName.process;
        }

        public ProcessName build() {
            return new ProcessName(this);
        }
    }
}

