/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InstanceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_APPLICATION_INSTANCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/applications/{application}/instances/{instance}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String application;
    private final String instance;

    @Deprecated
    protected InstanceName() {
        this.project = null;
        this.location = null;
        this.application = null;
        this.instance = null;
    }

    private InstanceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.application = (String)Preconditions.checkNotNull((Object)builder.getApplication());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApplication() {
        return this.application;
    }

    public String getInstance() {
        return this.instance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InstanceName of(String project, String location, String application, String instance) {
        return InstanceName.newBuilder().setProject(project).setLocation(location).setApplication(application).setInstance(instance).build();
    }

    public static String format(String project, String location, String application, String instance) {
        return InstanceName.newBuilder().setProject(project).setLocation(location).setApplication(application).setInstance(instance).build().toString();
    }

    public static InstanceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_APPLICATION_INSTANCE.validatedMatch(formattedString, "InstanceName.parse: formattedString not in valid format");
        return InstanceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("application"), (String)matchMap.get("instance"));
    }

    public static List<InstanceName> parseList(List<String> formattedStrings) {
        ArrayList<InstanceName> list = new ArrayList<InstanceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InstanceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InstanceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InstanceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_APPLICATION_INSTANCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InstanceName instanceName = this;
            synchronized (instanceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.application != null) {
                        fieldMapBuilder.put((Object)"application", (Object)this.application);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_APPLICATION_INSTANCE.instantiate(new String[]{"project", this.project, "location", this.location, "application", this.application, "instance", this.instance});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InstanceName that = (InstanceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.application, that.application) && Objects.equals(this.instance, that.instance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.application);
        h *= 1000003;
        return h ^= Objects.hashCode(this.instance);
    }

    public static class Builder {
        private String project;
        private String location;
        private String application;
        private String instance;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApplication() {
            return this.application;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setApplication(String application) {
            this.application = application;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        private Builder(InstanceName instanceName) {
            this.project = instanceName.project;
            this.location = instanceName.location;
            this.application = instanceName.application;
            this.instance = instanceName.instance;
        }

        public InstanceName build() {
            return new InstanceName(this);
        }
    }
}

