/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataSchemaName
implements ResourceName {
    private static final PathTemplate PROJECT_NUMBER_LOCATION_CORPUS_DATA_SCHEMA = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNumber;
    private final String location;
    private final String corpus;
    private final String dataSchema;

    @Deprecated
    protected DataSchemaName() {
        this.projectNumber = null;
        this.location = null;
        this.corpus = null;
        this.dataSchema = null;
    }

    private DataSchemaName(Builder builder) {
        this.projectNumber = (String)Preconditions.checkNotNull((Object)builder.getProjectNumber());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.corpus = (String)Preconditions.checkNotNull((Object)builder.getCorpus());
        this.dataSchema = (String)Preconditions.checkNotNull((Object)builder.getDataSchema());
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public String getDataSchema() {
        return this.dataSchema;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataSchemaName of(String projectNumber, String location, String corpus, String dataSchema) {
        return DataSchemaName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setDataSchema(dataSchema).build();
    }

    public static String format(String projectNumber, String location, String corpus, String dataSchema) {
        return DataSchemaName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setDataSchema(dataSchema).build().toString();
    }

    public static DataSchemaName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUMBER_LOCATION_CORPUS_DATA_SCHEMA.validatedMatch(formattedString, "DataSchemaName.parse: formattedString not in valid format");
        return DataSchemaName.of((String)matchMap.get("project_number"), (String)matchMap.get("location"), (String)matchMap.get("corpus"), (String)matchMap.get("data_schema"));
    }

    public static List<DataSchemaName> parseList(List<String> formattedStrings) {
        ArrayList<DataSchemaName> list = new ArrayList<DataSchemaName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataSchemaName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataSchemaName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataSchemaName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUMBER_LOCATION_CORPUS_DATA_SCHEMA.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataSchemaName dataSchemaName = this;
            synchronized (dataSchemaName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNumber != null) {
                        fieldMapBuilder.put((Object)"project_number", (Object)this.projectNumber);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.corpus != null) {
                        fieldMapBuilder.put((Object)"corpus", (Object)this.corpus);
                    }
                    if (this.dataSchema != null) {
                        fieldMapBuilder.put((Object)"data_schema", (Object)this.dataSchema);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUMBER_LOCATION_CORPUS_DATA_SCHEMA.instantiate(new String[]{"project_number", this.projectNumber, "location", this.location, "corpus", this.corpus, "data_schema", this.dataSchema});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataSchemaName that = (DataSchemaName)o;
            return Objects.equals(this.projectNumber, that.projectNumber) && Objects.equals(this.location, that.location) && Objects.equals(this.corpus, that.corpus) && Objects.equals(this.dataSchema, that.dataSchema);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNumber);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.corpus);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataSchema);
    }

    public static class Builder {
        private String projectNumber;
        private String location;
        private String corpus;
        private String dataSchema;

        protected Builder() {
        }

        public String getProjectNumber() {
            return this.projectNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCorpus() {
            return this.corpus;
        }

        public String getDataSchema() {
            return this.dataSchema;
        }

        public Builder setProjectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCorpus(String corpus) {
            this.corpus = corpus;
            return this;
        }

        public Builder setDataSchema(String dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        private Builder(DataSchemaName dataSchemaName) {
            this.projectNumber = dataSchemaName.projectNumber;
            this.location = dataSchemaName.location;
            this.corpus = dataSchemaName.corpus;
            this.dataSchema = dataSchemaName.dataSchema;
        }

        public DataSchemaName build() {
            return new DataSchemaName(this);
        }
    }
}

