/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CorpusName
implements ResourceName {
    private static final PathTemplate PROJECT_NUMBER_LOCATION_CORPUS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_number}/locations/{location}/corpora/{corpus}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNumber;
    private final String location;
    private final String corpus;

    @Deprecated
    protected CorpusName() {
        this.projectNumber = null;
        this.location = null;
        this.corpus = null;
    }

    private CorpusName(Builder builder) {
        this.projectNumber = (String)Preconditions.checkNotNull((Object)builder.getProjectNumber());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.corpus = (String)Preconditions.checkNotNull((Object)builder.getCorpus());
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CorpusName of(String projectNumber, String location, String corpus) {
        return CorpusName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).build();
    }

    public static String format(String projectNumber, String location, String corpus) {
        return CorpusName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).build().toString();
    }

    public static CorpusName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUMBER_LOCATION_CORPUS.validatedMatch(formattedString, "CorpusName.parse: formattedString not in valid format");
        return CorpusName.of((String)matchMap.get("project_number"), (String)matchMap.get("location"), (String)matchMap.get("corpus"));
    }

    public static List<CorpusName> parseList(List<String> formattedStrings) {
        ArrayList<CorpusName> list = new ArrayList<CorpusName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CorpusName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CorpusName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CorpusName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUMBER_LOCATION_CORPUS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CorpusName corpusName = this;
            synchronized (corpusName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNumber != null) {
                        fieldMapBuilder.put((Object)"project_number", (Object)this.projectNumber);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.corpus != null) {
                        fieldMapBuilder.put((Object)"corpus", (Object)this.corpus);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUMBER_LOCATION_CORPUS.instantiate(new String[]{"project_number", this.projectNumber, "location", this.location, "corpus", this.corpus});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CorpusName that = (CorpusName)o;
            return Objects.equals(this.projectNumber, that.projectNumber) && Objects.equals(this.location, that.location) && Objects.equals(this.corpus, that.corpus);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNumber);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.corpus);
    }

    public static class Builder {
        private String projectNumber;
        private String location;
        private String corpus;

        protected Builder() {
        }

        public String getProjectNumber() {
            return this.projectNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCorpus() {
            return this.corpus;
        }

        public Builder setProjectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCorpus(String corpus) {
            this.corpus = corpus;
            return this;
        }

        private Builder(CorpusName corpusName) {
            this.projectNumber = corpusName.projectNumber;
            this.location = corpusName.location;
            this.corpus = corpusName.corpus;
        }

        public CorpusName build() {
            return new CorpusName(this);
        }
    }
}

