/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IndexEndpointName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INDEX_ENDPOINT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String indexEndpoint;

    @Deprecated
    protected IndexEndpointName() {
        this.project = null;
        this.location = null;
        this.indexEndpoint = null;
    }

    private IndexEndpointName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.indexEndpoint = (String)Preconditions.checkNotNull((Object)builder.getIndexEndpoint());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getIndexEndpoint() {
        return this.indexEndpoint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IndexEndpointName of(String project, String location, String indexEndpoint) {
        return IndexEndpointName.newBuilder().setProject(project).setLocation(location).setIndexEndpoint(indexEndpoint).build();
    }

    public static String format(String project, String location, String indexEndpoint) {
        return IndexEndpointName.newBuilder().setProject(project).setLocation(location).setIndexEndpoint(indexEndpoint).build().toString();
    }

    public static IndexEndpointName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INDEX_ENDPOINT.validatedMatch(formattedString, "IndexEndpointName.parse: formattedString not in valid format");
        return IndexEndpointName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("index_endpoint"));
    }

    public static List<IndexEndpointName> parseList(List<String> formattedStrings) {
        ArrayList<IndexEndpointName> list = new ArrayList<IndexEndpointName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IndexEndpointName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IndexEndpointName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IndexEndpointName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INDEX_ENDPOINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IndexEndpointName indexEndpointName = this;
            synchronized (indexEndpointName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.indexEndpoint != null) {
                        fieldMapBuilder.put((Object)"index_endpoint", (Object)this.indexEndpoint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INDEX_ENDPOINT.instantiate(new String[]{"project", this.project, "location", this.location, "index_endpoint", this.indexEndpoint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            IndexEndpointName that = (IndexEndpointName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.indexEndpoint, that.indexEndpoint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.indexEndpoint);
    }

    public static class Builder {
        private String project;
        private String location;
        private String indexEndpoint;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getIndexEndpoint() {
            return this.indexEndpoint;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setIndexEndpoint(String indexEndpoint) {
            this.indexEndpoint = indexEndpoint;
            return this;
        }

        private Builder(IndexEndpointName indexEndpointName) {
            this.project = indexEndpointName.project;
            this.location = indexEndpointName.location;
            this.indexEndpoint = indexEndpointName.indexEndpoint;
        }

        public IndexEndpointName build() {
            return new IndexEndpointName(this);
        }
    }
}

