/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SearchHypernymName
implements ResourceName {
    private static final PathTemplate PROJECT_NUMBER_LOCATION_CORPUS_SEARCH_HYPERNYM = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_number}/locations/{location}/corpora/{corpus}/searchHypernyms/{search_hypernym}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNumber;
    private final String location;
    private final String corpus;
    private final String searchHypernym;

    @Deprecated
    protected SearchHypernymName() {
        this.projectNumber = null;
        this.location = null;
        this.corpus = null;
        this.searchHypernym = null;
    }

    private SearchHypernymName(Builder builder) {
        this.projectNumber = (String)Preconditions.checkNotNull((Object)builder.getProjectNumber());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.corpus = (String)Preconditions.checkNotNull((Object)builder.getCorpus());
        this.searchHypernym = (String)Preconditions.checkNotNull((Object)builder.getSearchHypernym());
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public String getSearchHypernym() {
        return this.searchHypernym;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SearchHypernymName of(String projectNumber, String location, String corpus, String searchHypernym) {
        return SearchHypernymName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setSearchHypernym(searchHypernym).build();
    }

    public static String format(String projectNumber, String location, String corpus, String searchHypernym) {
        return SearchHypernymName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setSearchHypernym(searchHypernym).build().toString();
    }

    public static SearchHypernymName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUMBER_LOCATION_CORPUS_SEARCH_HYPERNYM.validatedMatch(formattedString, "SearchHypernymName.parse: formattedString not in valid format");
        return SearchHypernymName.of((String)matchMap.get("project_number"), (String)matchMap.get("location"), (String)matchMap.get("corpus"), (String)matchMap.get("search_hypernym"));
    }

    public static List<SearchHypernymName> parseList(List<String> formattedStrings) {
        ArrayList<SearchHypernymName> list = new ArrayList<SearchHypernymName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SearchHypernymName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SearchHypernymName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SearchHypernymName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUMBER_LOCATION_CORPUS_SEARCH_HYPERNYM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SearchHypernymName searchHypernymName = this;
            synchronized (searchHypernymName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNumber != null) {
                        fieldMapBuilder.put((Object)"project_number", (Object)this.projectNumber);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.corpus != null) {
                        fieldMapBuilder.put((Object)"corpus", (Object)this.corpus);
                    }
                    if (this.searchHypernym != null) {
                        fieldMapBuilder.put((Object)"search_hypernym", (Object)this.searchHypernym);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUMBER_LOCATION_CORPUS_SEARCH_HYPERNYM.instantiate(new String[]{"project_number", this.projectNumber, "location", this.location, "corpus", this.corpus, "search_hypernym", this.searchHypernym});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SearchHypernymName that = (SearchHypernymName)o;
            return Objects.equals(this.projectNumber, that.projectNumber) && Objects.equals(this.location, that.location) && Objects.equals(this.corpus, that.corpus) && Objects.equals(this.searchHypernym, that.searchHypernym);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNumber);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.corpus);
        h *= 1000003;
        return h ^= Objects.hashCode(this.searchHypernym);
    }

    public static class Builder {
        private String projectNumber;
        private String location;
        private String corpus;
        private String searchHypernym;

        protected Builder() {
        }

        public String getProjectNumber() {
            return this.projectNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCorpus() {
            return this.corpus;
        }

        public String getSearchHypernym() {
            return this.searchHypernym;
        }

        public Builder setProjectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCorpus(String corpus) {
            this.corpus = corpus;
            return this;
        }

        public Builder setSearchHypernym(String searchHypernym) {
            this.searchHypernym = searchHypernym;
            return this;
        }

        private Builder(SearchHypernymName searchHypernymName) {
            this.projectNumber = searchHypernymName.projectNumber;
            this.location = searchHypernymName.location;
            this.corpus = searchHypernymName.corpus;
            this.searchHypernym = searchHypernymName.searchHypernym;
        }

        public SearchHypernymName build() {
            return new SearchHypernymName(this);
        }
    }
}

