/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SeriesName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_SERIES = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/series/{series}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;
    private final String series;

    @Deprecated
    protected SeriesName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.series = null;
    }

    private SeriesName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.series = (String)Preconditions.checkNotNull((Object)builder.getSeries());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getSeries() {
        return this.series;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SeriesName of(String project, String location, String cluster, String series) {
        return SeriesName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setSeries(series).build();
    }

    public static String format(String project, String location, String cluster, String series) {
        return SeriesName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setSeries(series).build().toString();
    }

    public static SeriesName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER_SERIES.validatedMatch(formattedString, "SeriesName.parse: formattedString not in valid format");
        return SeriesName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("series"));
    }

    public static List<SeriesName> parseList(List<String> formattedStrings) {
        ArrayList<SeriesName> list = new ArrayList<SeriesName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SeriesName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SeriesName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SeriesName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER_SERIES.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SeriesName seriesName = this;
            synchronized (seriesName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.series != null) {
                        fieldMapBuilder.put((Object)"series", (Object)this.series);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER_SERIES.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster, "series", this.series});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SeriesName that = (SeriesName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.series, that.series);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.series);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;
        private String series;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getSeries() {
            return this.series;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setSeries(String series) {
            this.series = series;
            return this;
        }

        private Builder(SeriesName seriesName) {
            this.project = seriesName.project;
            this.location = seriesName.location;
            this.cluster = seriesName.cluster;
            this.series = seriesName.series;
        }

        public SeriesName build() {
            return new SeriesName(this);
        }
    }
}

