/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DraftName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_APPLICATION_DRAFT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/applications/{application}/drafts/{draft}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String application;
    private final String draft;

    @Deprecated
    protected DraftName() {
        this.project = null;
        this.location = null;
        this.application = null;
        this.draft = null;
    }

    private DraftName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.application = (String)Preconditions.checkNotNull((Object)builder.getApplication());
        this.draft = (String)Preconditions.checkNotNull((Object)builder.getDraft());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApplication() {
        return this.application;
    }

    public String getDraft() {
        return this.draft;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DraftName of(String project, String location, String application, String draft) {
        return DraftName.newBuilder().setProject(project).setLocation(location).setApplication(application).setDraft(draft).build();
    }

    public static String format(String project, String location, String application, String draft) {
        return DraftName.newBuilder().setProject(project).setLocation(location).setApplication(application).setDraft(draft).build().toString();
    }

    public static DraftName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_APPLICATION_DRAFT.validatedMatch(formattedString, "DraftName.parse: formattedString not in valid format");
        return DraftName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("application"), (String)matchMap.get("draft"));
    }

    public static List<DraftName> parseList(List<String> formattedStrings) {
        ArrayList<DraftName> list = new ArrayList<DraftName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DraftName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DraftName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DraftName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_APPLICATION_DRAFT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DraftName draftName = this;
            synchronized (draftName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.application != null) {
                        fieldMapBuilder.put((Object)"application", (Object)this.application);
                    }
                    if (this.draft != null) {
                        fieldMapBuilder.put((Object)"draft", (Object)this.draft);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_APPLICATION_DRAFT.instantiate(new String[]{"project", this.project, "location", this.location, "application", this.application, "draft", this.draft});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DraftName that = (DraftName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.application, that.application) && Objects.equals(this.draft, that.draft);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.application);
        h *= 1000003;
        return h ^= Objects.hashCode(this.draft);
    }

    public static class Builder {
        private String project;
        private String location;
        private String application;
        private String draft;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApplication() {
            return this.application;
        }

        public String getDraft() {
            return this.draft;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setApplication(String application) {
            this.application = application;
            return this;
        }

        public Builder setDraft(String draft) {
            this.draft = draft;
            return this;
        }

        private Builder(DraftName draftName) {
            this.project = draftName.project;
            this.location = draftName.location;
            this.application = draftName.application;
            this.draft = draftName.draft;
        }

        public DraftName build() {
            return new DraftName(this);
        }
    }
}

