/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetName
implements ResourceName {
    private static final PathTemplate PROJECT_NUMBER_LOCATION_CORPUS_ASSET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNumber;
    private final String location;
    private final String corpus;
    private final String asset;

    @Deprecated
    protected AssetName() {
        this.projectNumber = null;
        this.location = null;
        this.corpus = null;
        this.asset = null;
    }

    private AssetName(Builder builder) {
        this.projectNumber = (String)Preconditions.checkNotNull((Object)builder.getProjectNumber());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.corpus = (String)Preconditions.checkNotNull((Object)builder.getCorpus());
        this.asset = (String)Preconditions.checkNotNull((Object)builder.getAsset());
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public String getAsset() {
        return this.asset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetName of(String projectNumber, String location, String corpus, String asset) {
        return AssetName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setAsset(asset).build();
    }

    public static String format(String projectNumber, String location, String corpus, String asset) {
        return AssetName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setAsset(asset).build().toString();
    }

    public static AssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUMBER_LOCATION_CORPUS_ASSET.validatedMatch(formattedString, "AssetName.parse: formattedString not in valid format");
        return AssetName.of((String)matchMap.get("project_number"), (String)matchMap.get("location"), (String)matchMap.get("corpus"), (String)matchMap.get("asset"));
    }

    public static List<AssetName> parseList(List<String> formattedStrings) {
        ArrayList<AssetName> list = new ArrayList<AssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUMBER_LOCATION_CORPUS_ASSET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetName assetName = this;
            synchronized (assetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNumber != null) {
                        fieldMapBuilder.put((Object)"project_number", (Object)this.projectNumber);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.corpus != null) {
                        fieldMapBuilder.put((Object)"corpus", (Object)this.corpus);
                    }
                    if (this.asset != null) {
                        fieldMapBuilder.put((Object)"asset", (Object)this.asset);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUMBER_LOCATION_CORPUS_ASSET.instantiate(new String[]{"project_number", this.projectNumber, "location", this.location, "corpus", this.corpus, "asset", this.asset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetName that = (AssetName)o;
            return Objects.equals(this.projectNumber, that.projectNumber) && Objects.equals(this.location, that.location) && Objects.equals(this.corpus, that.corpus) && Objects.equals(this.asset, that.asset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNumber);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.corpus);
        h *= 1000003;
        return h ^= Objects.hashCode(this.asset);
    }

    public static class Builder {
        private String projectNumber;
        private String location;
        private String corpus;
        private String asset;

        protected Builder() {
        }

        public String getProjectNumber() {
            return this.projectNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCorpus() {
            return this.corpus;
        }

        public String getAsset() {
            return this.asset;
        }

        public Builder setProjectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCorpus(String corpus) {
            this.corpus = corpus;
            return this;
        }

        public Builder setAsset(String asset) {
            this.asset = asset;
            return this;
        }

        private Builder(AssetName assetName) {
            this.projectNumber = assetName.projectNumber;
            this.location = assetName.location;
            this.corpus = assetName.corpus;
            this.asset = assetName.asset;
        }

        public AssetName build() {
            return new AssetName(this);
        }
    }
}

