/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApplicationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_APPLICATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/applications/{application}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String application;

    @Deprecated
    protected ApplicationName() {
        this.project = null;
        this.location = null;
        this.application = null;
    }

    private ApplicationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.application = (String)Preconditions.checkNotNull((Object)builder.getApplication());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApplication() {
        return this.application;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ApplicationName of(String project, String location, String application) {
        return ApplicationName.newBuilder().setProject(project).setLocation(location).setApplication(application).build();
    }

    public static String format(String project, String location, String application) {
        return ApplicationName.newBuilder().setProject(project).setLocation(location).setApplication(application).build().toString();
    }

    public static ApplicationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_APPLICATION.validatedMatch(formattedString, "ApplicationName.parse: formattedString not in valid format");
        return ApplicationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("application"));
    }

    public static List<ApplicationName> parseList(List<String> formattedStrings) {
        ArrayList<ApplicationName> list = new ArrayList<ApplicationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ApplicationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ApplicationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ApplicationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_APPLICATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ApplicationName applicationName = this;
            synchronized (applicationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.application != null) {
                        fieldMapBuilder.put((Object)"application", (Object)this.application);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_APPLICATION.instantiate(new String[]{"project", this.project, "location", this.location, "application", this.application});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ApplicationName that = (ApplicationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.application, that.application);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.application);
    }

    public static class Builder {
        private String project;
        private String location;
        private String application;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getApplication() {
            return this.application;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setApplication(String application) {
            this.application = application;
            return this;
        }

        private Builder(ApplicationName applicationName) {
            this.project = applicationName.project;
            this.location = applicationName.location;
            this.application = applicationName.application;
        }

        public ApplicationName build() {
            return new ApplicationName(this);
        }
    }
}

