/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnalysisName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_ANALYSIS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/analyses/{analysis}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;
    private final String analysis;

    @Deprecated
    protected AnalysisName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.analysis = null;
    }

    private AnalysisName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.analysis = (String)Preconditions.checkNotNull((Object)builder.getAnalysis());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getAnalysis() {
        return this.analysis;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnalysisName of(String project, String location, String cluster, String analysis) {
        return AnalysisName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setAnalysis(analysis).build();
    }

    public static String format(String project, String location, String cluster, String analysis) {
        return AnalysisName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setAnalysis(analysis).build().toString();
    }

    public static AnalysisName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER_ANALYSIS.validatedMatch(formattedString, "AnalysisName.parse: formattedString not in valid format");
        return AnalysisName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("analysis"));
    }

    public static List<AnalysisName> parseList(List<String> formattedStrings) {
        ArrayList<AnalysisName> list = new ArrayList<AnalysisName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnalysisName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnalysisName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnalysisName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER_ANALYSIS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnalysisName analysisName = this;
            synchronized (analysisName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.analysis != null) {
                        fieldMapBuilder.put((Object)"analysis", (Object)this.analysis);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER_ANALYSIS.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster, "analysis", this.analysis});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AnalysisName that = (AnalysisName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.analysis, that.analysis);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.analysis);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;
        private String analysis;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getAnalysis() {
            return this.analysis;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setAnalysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        private Builder(AnalysisName analysisName) {
            this.project = analysisName.project;
            this.location = analysisName.location;
            this.cluster = analysisName.cluster;
            this.analysis = analysisName.analysis;
        }

        public AnalysisName build() {
            return new AnalysisName(this);
        }
    }
}

