/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SearchConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_NUMBER_LOCATION_CORPUS_SEARCH_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String projectNumber;
    private final String location;
    private final String corpus;
    private final String searchConfig;

    @Deprecated
    protected SearchConfigName() {
        this.projectNumber = null;
        this.location = null;
        this.corpus = null;
        this.searchConfig = null;
    }

    private SearchConfigName(Builder builder) {
        this.projectNumber = (String)Preconditions.checkNotNull((Object)builder.getProjectNumber());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.corpus = (String)Preconditions.checkNotNull((Object)builder.getCorpus());
        this.searchConfig = (String)Preconditions.checkNotNull((Object)builder.getSearchConfig());
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCorpus() {
        return this.corpus;
    }

    public String getSearchConfig() {
        return this.searchConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SearchConfigName of(String projectNumber, String location, String corpus, String searchConfig) {
        return SearchConfigName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setSearchConfig(searchConfig).build();
    }

    public static String format(String projectNumber, String location, String corpus, String searchConfig) {
        return SearchConfigName.newBuilder().setProjectNumber(projectNumber).setLocation(location).setCorpus(corpus).setSearchConfig(searchConfig).build().toString();
    }

    public static SearchConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_NUMBER_LOCATION_CORPUS_SEARCH_CONFIG.validatedMatch(formattedString, "SearchConfigName.parse: formattedString not in valid format");
        return SearchConfigName.of((String)matchMap.get("project_number"), (String)matchMap.get("location"), (String)matchMap.get("corpus"), (String)matchMap.get("search_config"));
    }

    public static List<SearchConfigName> parseList(List<String> formattedStrings) {
        ArrayList<SearchConfigName> list = new ArrayList<SearchConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SearchConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SearchConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SearchConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_NUMBER_LOCATION_CORPUS_SEARCH_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SearchConfigName searchConfigName = this;
            synchronized (searchConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.projectNumber != null) {
                        fieldMapBuilder.put((Object)"project_number", (Object)this.projectNumber);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.corpus != null) {
                        fieldMapBuilder.put((Object)"corpus", (Object)this.corpus);
                    }
                    if (this.searchConfig != null) {
                        fieldMapBuilder.put((Object)"search_config", (Object)this.searchConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_NUMBER_LOCATION_CORPUS_SEARCH_CONFIG.instantiate(new String[]{"project_number", this.projectNumber, "location", this.location, "corpus", this.corpus, "search_config", this.searchConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SearchConfigName that = (SearchConfigName)o;
            return Objects.equals(this.projectNumber, that.projectNumber) && Objects.equals(this.location, that.location) && Objects.equals(this.corpus, that.corpus) && Objects.equals(this.searchConfig, that.searchConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.projectNumber);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.corpus);
        h *= 1000003;
        return h ^= Objects.hashCode(this.searchConfig);
    }

    public static class Builder {
        private String projectNumber;
        private String location;
        private String corpus;
        private String searchConfig;

        protected Builder() {
        }

        public String getProjectNumber() {
            return this.projectNumber;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCorpus() {
            return this.corpus;
        }

        public String getSearchConfig() {
            return this.searchConfig;
        }

        public Builder setProjectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCorpus(String corpus) {
            this.corpus = corpus;
            return this;
        }

        public Builder setSearchConfig(String searchConfig) {
            this.searchConfig = searchConfig;
            return this;
        }

        private Builder(SearchConfigName searchConfigName) {
            this.projectNumber = searchConfigName.projectNumber;
            this.location = searchConfigName.location;
            this.corpus = searchConfigName.corpus;
            this.searchConfig = searchConfigName.searchConfig;
        }

        public SearchConfigName build() {
            return new SearchConfigName(this);
        }
    }
}

