/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StreamName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_STREAM = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/streams/{stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;
    private final String stream;

    @Deprecated
    protected StreamName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.stream = null;
    }

    private StreamName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.stream = (String)Preconditions.checkNotNull((Object)builder.getStream());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getStream() {
        return this.stream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static StreamName of(String project, String location, String cluster, String stream) {
        return StreamName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setStream(stream).build();
    }

    public static String format(String project, String location, String cluster, String stream) {
        return StreamName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setStream(stream).build().toString();
    }

    public static StreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER_STREAM.validatedMatch(formattedString, "StreamName.parse: formattedString not in valid format");
        return StreamName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("stream"));
    }

    public static List<StreamName> parseList(List<String> formattedStrings) {
        ArrayList<StreamName> list = new ArrayList<StreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(StreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<StreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (StreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER_STREAM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            StreamName streamName = this;
            synchronized (streamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.stream != null) {
                        fieldMapBuilder.put((Object)"stream", (Object)this.stream);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER_STREAM.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster, "stream", this.stream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            StreamName that = (StreamName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.stream, that.stream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.stream);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;
        private String stream;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getStream() {
            return this.stream;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        private Builder(StreamName streamName) {
            this.project = streamName.project;
            this.location = streamName.location;
            this.cluster = streamName.cluster;
            this.stream = streamName.stream;
        }

        public StreamName build() {
            return new StreamName(this);
        }
    }
}

